/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.ConversionException;
import com.sap.conn.jco.XMLParserException;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.jco.util.FastStringBuffer;
import com.sap.conn.jco.util.ObjectList;
import com.sap.conn.jco.util.Utf8ByteToCharConverter;

public final class XRfcParser {
    private static final int READ_BUFFER_SIZE = 16384;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_READING_TAG = 1;
    private static final int STATE_ENDTAG = 2;
    private static final int STATE_FINISHING_ENDTAG = 3;
    private static final int STATE_READING_TAGNAME = 4;
    private static final int STATE_RESUMABLE_READING_TAGNAME = 5;
    private static final int STATE_FINISHING_BEGIN_OR_EMPTYTAG = 6;
    private static final int STATE_EMPTYTAG = 7;
    private static final int STATE_READING_VALUE = 8;
    private static final int STATE_RESUMABLE_READING_VALUE = 9;
    private static final int STATE_EXPECTING_VALUE_ENDTAG = 10;
    private static final int STATE_FINISHING_VALUE_ENDTAG = 11;
    char[] buffer;
    FastStringBuffer tagBuffer;
    FastStringBuffer valueBuffer;
    FastStringBuffer tokenBuffer;
    int fieldIndex;
    String fieldName;
    String parameterName;
    int currentState;
    int hierarchyLevel;
    int tokenOffset;
    int tagNameEnd;
    int readPosition;
    int maxFilledPosition;
    int[] tableNestLevels;
    int currentTableNestLevelIndex;
    boolean needsUnescaping;
    boolean expectRowTag;
    boolean closedNestedRowTag;
    AbstractRecord rootRecord;
    ObjectList<AbstractRecord> recordStack;
    byte[] conversionBuffer;
    int conversionBufferEnd;
    Utf8ByteToCharConverter byteToCharConverter;

    protected XRfcParser(AbstractRecord rootRecord) {
        this.rootRecord = rootRecord;
        this.rootRecord.clear();
        this.buffer = new char[16384];
        this.tagBuffer = new FastStringBuffer(32);
        this.valueBuffer = new FastStringBuffer();
        this.tokenBuffer = new FastStringBuffer();
        this.currentState = 0;
        this.hierarchyLevel = 0;
        this.tokenOffset = 0;
        this.tagNameEnd = 0;
        this.readPosition = 0;
        this.expectRowTag = false;
        this.closedNestedRowTag = false;
        this.recordStack = new ObjectList(16);
        this.tableNestLevels = new int[16];
        this.currentTableNestLevelIndex = 0;
        this.conversionBufferEnd = 0;
        this.byteToCharConverter = new Utf8ByteToCharConverter();
    }

    void parse() throws XMLParserException {
        block60: while (this.readPosition < this.maxFilledPosition) {
            switch (this.currentState) {
                case 0: {
                    switch (this.buffer[this.readPosition]) {
                        case '<': {
                            this.currentState = 1;
                            this.tagBuffer.reset();
                            this.tokenOffset = ++this.readPosition;
                            continue block60;
                        }
                        case '\t': 
                        case '\n': 
                        case '\u000b': 
                        case '\f': 
                        case '\r': 
                        case '\u001c': 
                        case '\u001d': 
                        case '\u001e': 
                        case '\u001f': 
                        case ' ': {
                            ++this.readPosition;
                            continue block60;
                        }
                    }
                    throw new XMLParserException(new FastStringBuffer().append("Parameter ").append(this.parameterName).append(": Expecting a tag to begin with '<' instead of '").append(this.buffer[this.readPosition]).append("', in \"").append(new String(this.buffer, Math.max(0, this.readPosition - 10), Math.min(10, this.readPosition) + Math.min(this.maxFilledPosition - this.readPosition, 10))).append('\"').toString());
                }
                case 1: {
                    switch (this.buffer[this.readPosition]) {
                        case '/': {
                            this.currentState = 2;
                            ++this.readPosition;
                            continue block60;
                        }
                    }
                    this.currentState = 4;
                    continue block60;
                }
                case 2: {
                    switch (this.buffer[this.readPosition]) {
                        case '>': {
                            throw new XMLParserException(new FastStringBuffer().append("Parameter ").append(this.parameterName).append(": A tag name cannot be empty, found '</>' in \"").append(new String(this.buffer, Math.max(0, this.readPosition - 10), Math.min(10, this.readPosition) + Math.min(this.maxFilledPosition - this.readPosition, 10))).append('\"').toString());
                        }
                    }
                    this.currentState = 3;
                    ++this.readPosition;
                    continue block60;
                }
                case 3: 
                case 11: {
                    switch (this.buffer[this.readPosition]) {
                        case '>': {
                            ++this.readPosition;
                            this.processEndTag();
                            this.currentState = 0;
                            continue block60;
                        }
                    }
                    ++this.readPosition;
                    continue block60;
                }
                case 4: {
                    switch (this.buffer[this.readPosition]) {
                        case '/': {
                            this.currentState = 7;
                            ++this.readPosition;
                            continue block60;
                        }
                        case '_': {
                            if (++this.readPosition < this.maxFilledPosition) {
                                if (this.buffer[this.readPosition] != '-') continue block60;
                                ++this.readPosition;
                                this.needsUnescaping = true;
                                continue block60;
                            }
                            this.needsUnescaping = true;
                            continue block60;
                        }
                        case '>': {
                            if (this.readPosition - this.tokenOffset == 0) {
                                throw new XMLParserException(new FastStringBuffer().append("Parameter ").append(this.parameterName).append(": A tag name cannot be empty, found '<>' in \"").append(new String(this.buffer, Math.max(0, this.readPosition - 10), Math.min(10, this.readPosition) + Math.min(this.maxFilledPosition - this.readPosition, 10))).append('\"').toString());
                            }
                            this.tagNameEnd = this.readPosition++;
                            this.processBeginTag();
                            continue block60;
                        }
                        case '\t': 
                        case '\n': 
                        case '\u000b': 
                        case '\f': 
                        case '\r': 
                        case '\u001c': 
                        case '\u001d': 
                        case '\u001e': 
                        case '\u001f': 
                        case ' ': {
                            if (this.readPosition - this.tokenOffset == 0) {
                                throw new XMLParserException(new FastStringBuffer().append("Parameter ").append(this.parameterName).append(": A tag name cannot start with '").append(this.buffer[this.readPosition]).append("', in \"").append(new String(this.buffer, Math.max(0, this.readPosition - 10), Math.min(10, this.readPosition) + Math.min(this.maxFilledPosition - this.readPosition, 10))).append('\"').toString());
                            }
                            this.tagNameEnd = this.readPosition++;
                            this.currentState = 6;
                            continue block60;
                        }
                        case '\"': 
                        case '&': 
                        case '\'': 
                        case '<': {
                            throw new XMLParserException(new FastStringBuffer().append("Parameter ").append(this.parameterName).append(": A tag name cannot contain '").append(this.buffer[this.readPosition]).append("', in \"").append(new String(this.buffer, Math.max(0, this.readPosition - 10), Math.min(10, this.readPosition) + Math.min(this.maxFilledPosition - this.readPosition, 10))).append('\"').toString());
                        }
                    }
                    ++this.readPosition;
                    continue block60;
                }
                case 5: {
                    switch (this.buffer[this.readPosition]) {
                        case '/': {
                            this.currentState = 7;
                            this.tagBuffer.reset();
                            ++this.readPosition;
                            continue block60;
                        }
                        case '_': {
                            if (++this.readPosition < this.maxFilledPosition) {
                                if (this.buffer[this.readPosition] != '-') continue block60;
                                ++this.readPosition;
                                this.needsUnescaping = true;
                                continue block60;
                            }
                            this.needsUnescaping = true;
                            continue block60;
                        }
                        case '>': {
                            if (this.readPosition - this.tokenOffset == 0 && this.tagBuffer.length() == 0) {
                                throw new XMLParserException(new FastStringBuffer().append("Parameter ").append(this.parameterName).append(": A tag name cannot be empty, found '<>' in \"").append(new String(this.buffer, Math.max(0, this.readPosition - 10), Math.min(10, this.readPosition) + Math.min(this.maxFilledPosition - this.readPosition, 10))).append('\"').toString());
                            }
                            this.tagNameEnd = this.readPosition++;
                            this.processBeginTag();
                            continue block60;
                        }
                        case '\t': 
                        case '\n': 
                        case '\u000b': 
                        case '\f': 
                        case '\r': 
                        case '\u001c': 
                        case '\u001d': 
                        case '\u001e': 
                        case '\u001f': 
                        case ' ': {
                            if (this.readPosition - this.tokenOffset == 0 && this.tagBuffer.length() == 0) {
                                throw new XMLParserException(new FastStringBuffer().append("Parameter ").append(this.parameterName).append(": A tag name cannot start with '").append(this.buffer[this.readPosition]).append("', in \"").append(new String(this.buffer, Math.max(0, this.readPosition - 10), Math.min(10, this.readPosition) + Math.min(this.maxFilledPosition - this.readPosition, 10))).append('\"').toString());
                            }
                            this.tagNameEnd = this.readPosition++;
                            this.currentState = 6;
                            continue block60;
                        }
                        case '\"': 
                        case '&': 
                        case '\'': 
                        case '<': {
                            throw new XMLParserException(new FastStringBuffer().append("Parameter ").append(this.parameterName).append(": A tag name cannot contain '").append(this.buffer[this.readPosition]).append("', in \"").append(new String(this.buffer, Math.max(0, this.readPosition - 10), Math.min(10, this.readPosition) + Math.min(this.maxFilledPosition - this.readPosition, 10))).append('\"').toString());
                        }
                    }
                    ++this.readPosition;
                    continue block60;
                }
                case 6: {
                    switch (this.buffer[this.readPosition]) {
                        case '/': {
                            this.currentState = 7;
                            ++this.readPosition;
                            continue block60;
                        }
                        case '>': {
                            ++this.readPosition;
                            this.processBeginTag();
                            continue block60;
                        }
                    }
                    ++this.readPosition;
                    continue block60;
                }
                case 7: {
                    switch (this.buffer[this.readPosition]) {
                        case '>': {
                            this.currentState = 0;
                            ++this.readPosition;
                            continue block60;
                        }
                    }
                    throw new XMLParserException(new FastStringBuffer().append("Parameter ").append(this.parameterName).append(": Found something between '/' and '>' in empty tag in \"").append(new String(this.buffer, Math.max(0, this.readPosition - 10), Math.min(10, this.readPosition) + Math.min(this.maxFilledPosition - this.readPosition, 10))).append('\"').toString());
                }
                case 8: 
                case 9: {
                    switch (this.buffer[this.readPosition]) {
                        case '<': {
                            this.storeValue();
                            this.currentState = 10;
                            ++this.readPosition;
                            continue block60;
                        }
                        case '&': {
                            if (++this.readPosition < this.maxFilledPosition) {
                                if (this.buffer[this.readPosition] != '#') continue block60;
                                ++this.readPosition;
                                this.needsUnescaping = true;
                                continue block60;
                            }
                            this.needsUnescaping = true;
                            continue block60;
                        }
                    }
                    ++this.readPosition;
                    continue block60;
                }
                case 10: {
                    switch (this.buffer[this.readPosition]) {
                        case '/': {
                            this.currentState = 11;
                            ++this.readPosition;
                            continue block60;
                        }
                    }
                    throw new XMLParserException(new FastStringBuffer().append("Parameter ").append(this.parameterName).append(": After a value an end tag must follow. That did not happen in \"").append(new String(this.buffer, Math.max(0, this.readPosition - 10), Math.min(10, this.readPosition) + Math.min(this.maxFilledPosition - this.readPosition, 10))).append('\"').toString());
                }
            }
            throw new XMLParserException(new FastStringBuffer().append("Parameter ").append(this.parameterName).append(": Invalid state ").append("" + this.currentState).append(" in XRfcParser").toString());
        }
        if (this.hierarchyLevel != 0) {
            switch (this.currentState) {
                case 4: {
                    this.currentState = 5;
                }
                case 5: {
                    this.tagBuffer.append(this.buffer, this.tokenOffset, this.maxFilledPosition - this.tokenOffset);
                    this.tokenOffset = 0;
                    this.tagNameEnd = 0;
                    break;
                }
                case 8: {
                    this.currentState = 9;
                }
                case 9: {
                    this.valueBuffer.append(this.buffer, this.tokenOffset, this.maxFilledPosition - this.tokenOffset);
                    this.tokenOffset = 0;
                    break;
                }
                case 6: {
                    if (this.needsUnescaping) {
                        if (this.tagBuffer.length() > 0) {
                            this.tagBuffer.append(this.buffer, this.tokenOffset, this.tagNameEnd - this.tokenOffset);
                            char[] tempBuffer = new char[this.tagBuffer.length() + this.tagNameEnd - this.tokenOffset];
                            System.arraycopy(this.tagBuffer.getBufferReference(), 0, tempBuffer, 0, this.tagBuffer.length());
                            System.arraycopy(this.buffer, this.tokenOffset, tempBuffer, this.tagBuffer.length(), this.tagNameEnd - this.tokenOffset);
                            this.tagBuffer.reset();
                            this.unescape(tempBuffer, 0, tempBuffer.length);
                        } else {
                            this.unescape(this.buffer, this.tokenOffset, this.tagNameEnd);
                        }
                    } else {
                        this.tagBuffer.append(this.buffer, this.tokenOffset, this.tagNameEnd - this.tokenOffset);
                    }
                    this.tokenOffset = 0;
                    this.tagNameEnd = 0;
                    break;
                }
                default: {
                    this.tokenOffset = 0;
                    this.tagNameEnd = 0;
                }
            }
            if (this.conversionBufferEnd > 16384) {
                this.reduceConversionBufferAndParse();
            }
        }
    }

    private void unescape(char[] escapedTag, int offset, int end) throws XMLParserException {
        int i = offset;
        while (i < end) {
            if (escapedTag[i] == '_') {
                if (escapedTag[++i] == '-') {
                    if (escapedTag[++i] == '-') {
                        try {
                            this.tagBuffer.append((char)Codecs.Hex.decode(escapedTag[i + 1], escapedTag[i + 2]));
                            i += 3;
                            continue;
                        }
                        catch (Exception e) {
                            throw new XMLParserException("Illegal escape sequence _--" + escapedTag[i + 1] + escapedTag[i + 2] + " in parameter " + this.parameterName + " encountered", e);
                        }
                    }
                    this.tagBuffer.append('/');
                    continue;
                }
                this.tagBuffer.append('_');
                continue;
            }
            this.tagBuffer.append(escapedTag[i]);
            ++i;
        }
        this.needsUnescaping = false;
    }

    private void unescapeValue(char[] escapedValue, int offset, int end) {
        int i = offset;
        while (i < end) {
            if (escapedValue[i] == '&') {
                if (escapedValue[++i] == '#') {
                    char c2;
                    char c1 = escapedValue[i + 1];
                    if (c1 >= '0' && c1 <= '9' && (c2 = escapedValue[i + 2]) >= '0' && c2 <= '9' && escapedValue[i + 3] == ';') {
                        this.tokenBuffer.append((char)((c1 - 48) * 10 + (c2 - 48)));
                        i += 4;
                        continue;
                    }
                    this.tokenBuffer.append('&').append('#');
                    ++i;
                    continue;
                }
                this.tokenBuffer.append('&');
                continue;
            }
            this.tokenBuffer.append(escapedValue[i]);
            ++i;
        }
        this.needsUnescaping = false;
    }

    private void storeValue() throws XMLParserException {
        AbstractRecord record = this.recordStack.last();
        if (record == null) {
            throw new XMLParserException("Illegal state: no record found in which to store the parsed value for " + this.fieldName + " while parsing parameter " + this.parameterName);
        }
        if (this.fieldIndex < 0) {
            if (this.valueBuffer.length() > 0) {
                this.valueBuffer.reset();
            }
            this.needsUnescaping = false;
            this.tokenOffset = 0;
        } else if (this.valueBuffer.length() > 0) {
            if (this.readPosition > 0) {
                this.valueBuffer.append(this.buffer, 0, this.readPosition);
            }
            if (this.needsUnescaping) {
                this.unescapeValue(this.valueBuffer.getBufferReference(), 0, this.valueBuffer.length());
                try {
                    record.encodeGENERIC(this.tokenBuffer.getBufferReference(), 0, this.tokenBuffer.length(), this.fieldIndex);
                }
                catch (ConversionException ex) {
                    throw new XMLParserException(ex.toString(), ex);
                }
                this.tokenBuffer.reset();
            } else {
                try {
                    record.encodeGENERIC(this.valueBuffer.getBufferReference(), 0, this.valueBuffer.length(), this.fieldIndex);
                }
                catch (ConversionException ex) {
                    throw new XMLParserException(ex.toString(), ex);
                }
            }
            this.valueBuffer.reset();
        } else {
            int valueLength = this.readPosition - this.tokenOffset;
            if (valueLength > 0) {
                if (this.needsUnescaping) {
                    this.unescapeValue(this.buffer, this.tokenOffset, this.readPosition);
                    try {
                        record.encodeGENERIC(this.tokenBuffer.getBufferReference(), 0, this.tokenBuffer.length(), this.fieldIndex);
                    }
                    catch (ConversionException ex) {
                        throw new XMLParserException(ex.toString(), ex);
                    }
                    this.tokenBuffer.reset();
                } else {
                    try {
                        record.encodeGENERIC(this.buffer, this.tokenOffset, valueLength, this.fieldIndex);
                    }
                    catch (ConversionException ex) {
                        throw new XMLParserException(ex.toString(), ex);
                    }
                }
            }
            this.tokenOffset = 0;
        }
    }

    private void processEndTag() {
        if (this.hierarchyLevel > 0) {
            --this.hierarchyLevel;
            block0 : switch (this.currentState) {
                case 11: {
                    break;
                }
                default: {
                    AbstractRecord currentRecord = this.recordStack.last();
                    if (currentRecord.recType == 4) {
                        switch (this.tableNestLevels[this.currentTableNestLevelIndex]) {
                            case 0: {
                                --this.currentTableNestLevelIndex;
                                this.expectRowTag = false;
                                this.closedNestedRowTag = false;
                                this.recordStack.pop();
                                currentRecord.row = 0;
                                break block0;
                            }
                            case 1: {
                                if (this.closedNestedRowTag || this.expectRowTag) {
                                    this.recordStack.pop();
                                    currentRecord.row = 0;
                                }
                                this.closedNestedRowTag = false;
                                int n = this.currentTableNestLevelIndex;
                                this.tableNestLevels[n] = this.tableNestLevels[n] - 1;
                                this.expectRowTag = true;
                                break block0;
                            }
                        }
                        int n = this.currentTableNestLevelIndex;
                        this.tableNestLevels[n] = this.tableNestLevels[n] - 1;
                        this.expectRowTag = true;
                        if (this.closedNestedRowTag) {
                            this.recordStack.pop();
                            currentRecord.row = 0;
                            break;
                        }
                        this.closedNestedRowTag = true;
                        break;
                    }
                    this.recordStack.pop();
                }
            }
        }
    }

    private void processBeginTag() throws XMLParserException {
        if (this.tagBuffer.length() > 0) {
            if (this.tagNameEnd > 0) {
                this.tagBuffer.append(this.buffer, 0, this.tagNameEnd);
            }
            if (this.needsUnescaping) {
                int bufferLength = this.tagBuffer.length();
                this.tagBuffer.reset();
                this.unescape(this.tagBuffer.getBufferReference(), 0, bufferLength);
            }
            this.fieldName = this.tagBuffer.toString();
            this.tagBuffer.reset();
        } else if (this.needsUnescaping) {
            this.unescape(this.buffer, this.tokenOffset, this.tagNameEnd);
            this.fieldName = this.tagBuffer.toString();
            this.tagBuffer.reset();
        } else {
            this.fieldName = new String(this.buffer, this.tokenOffset, this.tagNameEnd - this.tokenOffset);
        }
        if (this.hierarchyLevel == 0) {
            this.parameterName = this.fieldName;
            this.recordStack.push(this.rootRecord);
            if (this.rootRecord.recType == 4) {
                this.expectRowTag = true;
            }
            this.hierarchyLevel = 1;
            this.currentState = 0;
        } else {
            ++this.hierarchyLevel;
            AbstractRecord currentRecord = this.recordStack.last();
            if (currentRecord.recType == 4 && this.expectRowTag) {
                this.expectRowTag = false;
                this.closedNestedRowTag = false;
                DefaultTable table = (DefaultTable)currentRecord;
                if (this.tableNestLevels[this.currentTableNestLevelIndex] == 0) {
                    table.appendRow();
                    int n = this.currentTableNestLevelIndex;
                    this.tableNestLevels[n] = this.tableNestLevels[n] + 1;
                    if (table.metaData.numFields == 1 && table.metaData.name[0].length() == 0) {
                        switch (table.metaData.type[0]) {
                            case 17: {
                                this.currentState = 0;
                                break;
                            }
                            case 99: {
                                DefaultTable nestedTable = table.getTable(0);
                                this.recordStack.push(nestedTable);
                                currentRecord = nestedTable;
                                this.currentState = 0;
                                this.expectRowTag = true;
                                break;
                            }
                            default: {
                                this.currentState = 8;
                                this.tokenOffset = this.readPosition;
                                this.fieldIndex = 0;
                                int n2 = this.currentTableNestLevelIndex;
                                this.tableNestLevels[n2] = this.tableNestLevels[n2] - 1;
                                this.expectRowTag = true;
                                this.closedNestedRowTag = true;
                                break;
                            }
                        }
                    } else {
                        this.currentState = 0;
                    }
                } else {
                    DefaultTable nestedTable;
                    try {
                        nestedTable = (DefaultTable)currentRecord;
                    }
                    catch (ClassCastException ex) {
                        throw new XMLParserException("XML represents a nested table in record " + this.rootRecord.metaData.getName() + " (parameter " + this.parameterName + "). Not fitting to real structure.", ex);
                    }
                    nestedTable.appendRow();
                    int n = this.currentTableNestLevelIndex;
                    this.tableNestLevels[n] = this.tableNestLevels[n] + 1;
                    if (nestedTable.metaData.numFields == 1 && nestedTable.metaData.name[0].length() == 0) {
                        switch (nestedTable.metaData.type[0]) {
                            case 17: {
                                this.currentState = 0;
                                break;
                            }
                            case 99: {
                                DefaultTable nestedTable2 = nestedTable.getTable(0);
                                this.recordStack.push(nestedTable2);
                                currentRecord = nestedTable2;
                                this.currentState = 0;
                                this.expectRowTag = true;
                                break;
                            }
                            default: {
                                this.currentState = 8;
                                this.tokenOffset = this.readPosition;
                                this.fieldIndex = 0;
                                int n3 = this.currentTableNestLevelIndex;
                                this.tableNestLevels[n3] = this.tableNestLevels[n3] - 1;
                                this.expectRowTag = true;
                                this.closedNestedRowTag = true;
                                break;
                            }
                        }
                    } else {
                        this.currentState = 0;
                    }
                }
            } else {
                this.fieldIndex = currentRecord.metaData.indexOfField(this.fieldName);
                if (this.fieldIndex < 0) {
                    this.currentState = 8;
                    this.tokenOffset = this.readPosition;
                } else {
                    switch (currentRecord.metaData.type[this.fieldIndex]) {
                        case 99: {
                            ++this.currentTableNestLevelIndex;
                            if (this.currentTableNestLevelIndex == this.tableNestLevels.length) {
                                int[] newtableNestLevels = new int[this.tableNestLevels.length + 16];
                                System.arraycopy(this.tableNestLevels, 0, newtableNestLevels, 0, this.tableNestLevels.length);
                                this.tableNestLevels = newtableNestLevels;
                            }
                            this.expectRowTag = true;
                        }
                        case 17: {
                            this.currentState = 0;
                            try {
                                this.recordStack.push((AbstractRecord)currentRecord.getValue(this.fieldIndex));
                                break;
                            }
                            catch (ConversionException ex) {
                                throw new XMLParserException(ex.toString(), ex);
                            }
                        }
                        default: {
                            this.currentState = 8;
                            this.tokenOffset = this.readPosition;
                        }
                    }
                }
            }
        }
    }

    public void setBytes(byte[] xmlBytes) {
        byte[] converterInput = null;
        int sumLength = xmlBytes.length + this.conversionBufferEnd;
        if (this.conversionBufferEnd > 0) {
            if (sumLength > this.conversionBuffer.length) {
                byte[] conversionBufferNew = new byte[sumLength];
                System.arraycopy(this.conversionBuffer, 0, conversionBufferNew, 0, this.conversionBufferEnd);
                this.conversionBuffer = conversionBufferNew;
            }
            System.arraycopy(xmlBytes, 0, this.conversionBuffer, this.conversionBufferEnd, xmlBytes.length);
            converterInput = this.conversionBuffer;
        } else {
            converterInput = xmlBytes;
        }
        this.maxFilledPosition = this.byteToCharConverter.convert(converterInput, 0, sumLength - 1, this.buffer, 0, this.buffer.length - 1);
        this.readPosition = 0;
        this.conversionBufferEnd = this.byteToCharConverter.getRemainingByteCount();
        if (this.conversionBufferEnd > 0) {
            if (this.conversionBuffer == null) {
                this.conversionBuffer = new byte[16384 > this.conversionBufferEnd ? 16384 : this.conversionBufferEnd];
            }
            System.arraycopy(converterInput, sumLength - this.conversionBufferEnd, this.conversionBuffer, 0, this.conversionBufferEnd);
        }
    }

    public void reduceConversionBufferAndParse() {
        int sumLength = this.conversionBufferEnd;
        this.maxFilledPosition = this.byteToCharConverter.convert(this.conversionBuffer, 0, sumLength - 1, this.buffer, 0, this.buffer.length - 1);
        this.readPosition = 0;
        this.conversionBufferEnd = this.byteToCharConverter.getRemainingByteCount();
        if (this.conversionBufferEnd > 0) {
            System.arraycopy(this.conversionBuffer, sumLength - this.conversionBufferEnd, this.conversionBuffer, 0, this.conversionBufferEnd);
        }
        this.parse();
    }

    public void setFinished() throws XMLParserException {
        if (this.conversionBufferEnd > 0) {
            this.reduceConversionBufferAndParse();
        }
        if (this.hierarchyLevel > 0) {
            throw new XMLParserException("XRFC document incomplete for parameter " + this.parameterName + " (" + this.rootRecord.metaData.getName() + "). Check jco_rfc protocol traces.");
        }
    }
}

