/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoAttributes;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.ext.ServerPassportManager;
import com.sap.conn.jco.rt.AbstractConnection;
import com.sap.conn.jco.rt.DefaultServer;
import com.sap.conn.jco.rt.JCoMiddleware;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import com.sap.conn.jco.rt.RuntimeEnvironment;
import com.sap.conn.jco.rt.ServerAuthorizationData;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.jco.util.Dsr;
import com.sap.conn.jco.util.FastStringBuffer;
import com.sap.conn.jco.util.Jarm;
import com.sap.jdsr.writer.DsrFactory;
import com.sap.jdsr.writer.DsrIPassport;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class ServerConnection
extends AbstractConnection {
    static final byte STATE_STARTED = 2;
    static final byte STATE_BUSY = 4;
    static final byte STATE_LISTENING = 8;
    static final byte STATE_BACKGROUND_TASK = 16;
    static final byte STATE_BACKGROUND_UNIT = 32;
    static final byte STATE_TRANSACTION = 48;
    static final byte STATE_SUSPENDED = -128;
    JCoMiddleware.Server middlewareServer;
    DefaultServer serverGroup = null;
    ServerAuthorizationData authData = new ServerAuthorizationData();
    private String connectionId;

    ServerConnection(DefaultServer server) {
        this.serverGroup = server;
        this.middlewareServer = JCoRuntimeFactory.getRuntime().getMiddlewareInstance().getServerInterface();
        if (server != null) {
            this.attributes.partner_host = server.getProperties().getProperty("jco.server.gwhost");
            this.attributes.systnr = server.getProperties().getProperty("jco.server.gwserv");
            this.throughput = server.getThroughput();
        }
    }

    void setMiddleware(JCoMiddleware.Server middlewareServer) {
        this.middlewareServer = middlewareServer;
    }

    void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    String getConnectionId() {
        return this.connectionId;
    }

    protected DefaultServer getServer() {
        return this.serverGroup;
    }

    @Override
    public JCoAttributes getAttributes() throws JCoException {
        this.last_active_timestamp = System.currentTimeMillis();
        if (this.attributes.isInitial()) {
            return null;
        }
        if (!this.isValid()) {
            throw new JCoException(121, "JCO_ERROR_NULL_HANDLE", "Invalid rfc_handle = NULL encountered");
        }
        return this.attributes;
    }

    @Override
    void disconnect() throws JCoException {
        this.setState((byte)(this.state & 0xF0 | this.state & 0xFFFFFFFD));
        this.callCounter = 0;
        if (!this.isValid()) {
            return;
        }
        this.middlewareServer.disconnect(this);
    }

    @Override
    void abort(String message) {
        this.callCounter = 0;
        this.serverGroup.removeConnection(this);
    }

    @Override
    public boolean isAlive() {
        return this.serverGroup.isAlive();
    }

    protected DsrIPassport getDsrPassport() {
        if (this.passport_bytes != null) {
            DsrIPassport passport = DsrFactory.makeDsrPassport();
            if (!passport.setByNetPassport(this.passport_bytes)) {
                int mode = JCoRuntimeFactory.getRuntime().getInternalMode();
                int logLevel = (mode & 0x10) != 0 ? 4 : 16;
                Trace.fireTrace(logLevel, "[JCoAPI] jDSR library cannot parse received passport [" + Codecs.Hex.encode(this.passport_bytes) + "]");
                return null;
            }
            if (Trace.isOn(16)) {
                Trace.fireTrace(16, "[JCoAPI] getDsrPassport for connection with handle " + this.getConnectionHandle() + " passport=[" + Codecs.Hex.encode(this.passport_bytes) + "]");
            }
            return passport;
        }
        if (Trace.isOn(16)) {
            Trace.fireTrace(16, "[JCoAPI] DSR Passport was not sent from client side.");
        }
        return null;
    }

    protected void beginCall() {
        int mode = JCoRuntimeFactory.getRuntime().getInternalMode();
        try {
            block20: {
                ServerPassportManager pm = RuntimeEnvironment.getServerPassportManager();
                if (pm != null) {
                    try {
                        DsrIPassport passport = this.getDsrPassport();
                        ++this.callCounter;
                        if (passport != null) {
                            if (Trace.isOn(16)) {
                                Trace.fireTrace(16, "[JCoAPI] JCoServer.beginCall() for '" + this.rfm_name + "' - Root context ID: " + passport.getRootContextIdHex());
                            }
                            passport.setConnectionCounter(this.callCounter);
                            if (this.rfcHandle.rfc_uuid_set) {
                                if (Trace.isOn(16)) {
                                    Trace.fireTrace(16, "[JCoAPI] JCoServer.beginCall() for '" + this.rfm_name + "' - Received connection ID in passport: " + passport.getConnectionIdHex());
                                }
                                passport.setConnectionIdBytes(this.rfcHandle.rfc_uuid);
                                if (Trace.isOn(16)) {
                                    Trace.fireTrace(32, "[JCoAPI] JCoServer.beginCall() for '" + this.rfm_name + "' - Connection ID set by JCo: " + Codecs.Hex.encode(this.rfcHandle.rfc_uuid));
                                    Trace.fireTrace(16, "[JCoAPI] JCoServer.beginCall() for '" + this.rfm_name + "' - Connection ID in passport: " + passport.getConnectionIdHex());
                                }
                            }
                            pm.requestStarted(System.identityHashCode(this), passport, this.rfm_name);
                        }
                    }
                    catch (Throwable th) {
                        if (Trace.isOn(4)) {
                            String theText = "[JCoAPI] JCoServer.beginCall(): cannot get jDSR passport for call '" + this.rfm_name + "', because of " + th.toString();
                            if (Trace.isOn(16)) {
                                Trace.fireTrace(4, theText);
                            } else {
                                Trace.fireTrace(4, theText, th);
                            }
                        }
                        if ((mode & 0x10) != 0) break block20;
                        if (th instanceof RuntimeException) {
                            throw (RuntimeException)th;
                        }
                        if (th instanceof Error) {
                            throw (Error)th;
                        }
                        throw new RuntimeException(th);
                    }
                }
            }
            if ((mode & 1) != 0) {
                this.jarm_monitor = Jarm.getRequestMonitor(null, "com.sap.conn.jco.JCoServer");
                if (this.jarm_monitor != null) {
                    this.jarm_monitor.startComponent("com.sap.conn.jco.JCoServer");
                }
            }
            if ((mode & 2) != 0) {
                if (this.dsr_monitor == null && this.passport_bytes != null) {
                    this.dsr_monitor = Dsr.createMonitor();
                }
                if (this.dsr_monitor != null && this.passport_bytes != null) {
                    this.dsr_monitor.openDsrRecord(this.getConnectionHandle(), 1, this.passport_bytes, this.start_time);
                }
            }
        }
        catch (RuntimeException ex) {
            PrintWriter pw = null;
            StringWriter sw = new StringWriter();
            pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            Trace.fireTraceCritical(new StringBuffer("[JCoAPI] JCoClient.beginCall() throws exception ").append(Trace.CRLF).append(sw.getBuffer()).toString());
            throw ex;
        }
    }

    protected void endCall() {
        int mode = JCoRuntimeFactory.getRuntime().getInternalMode();
        try {
            block14: {
                block13: {
                    ServerPassportManager pm = RuntimeEnvironment.getServerPassportManager();
                    if (pm != null) {
                        try {
                            pm.requestFinished(System.identityHashCode(this), this.num_sent_bytes, this.num_received_bytes);
                        }
                        catch (Throwable th) {
                            if (Trace.isOn(4)) {
                                Trace.fireTrace(4, new FastStringBuffer().append("[JCoAPI] JCoServer.endCall(): exception within jDSR component '").append(this.rfm_name).append("', because of ").append(th.toString()).toString());
                            }
                            if ((mode & 0x10) != 0) break block13;
                            if (th instanceof RuntimeException) {
                                throw (RuntimeException)th;
                            }
                            if (th instanceof Error) {
                                throw (Error)th;
                            }
                            throw new RuntimeException(th);
                        }
                    }
                }
                if ((mode & 1) != 0 && this.jarm_monitor != null) {
                    try {
                        this.jarm_monitor.setUser(this.attributes.getUser());
                        long sum = this.num_sent_bytes + this.num_received_bytes;
                        this.jarm_monitor.endComponent(sum);
                        this.jarm_monitor.endRequest(sum);
                        this.jarm_monitor = null;
                    }
                    catch (Exception ex) {
                        if (!Trace.isOn(4)) break block14;
                        StringWriter sw = new StringWriter();
                        ex.printStackTrace(new PrintWriter(sw));
                        sw.flush();
                        Trace.fireTrace(4, new FastStringBuffer().append("[JcoAPI] JCoServer.endCall() throws exception ").append(Trace.CRLF).append(sw.getBuffer().toString()).toString());
                    }
                }
            }
            if ((mode & 2) != 0 && this.dsr_monitor != null && this.passport_bytes != null) {
                this.dsr_monitor.closeDsrRecord(this.getConnectionHandle(), 1, this.rfm_name, this.time_total, this.time_middleware, this.time_handle_request, this.num_sent_bytes, this.num_received_bytes);
            }
        }
        catch (RuntimeException ex) {
            if (Trace.isOn(4)) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                sw.flush();
                Trace.fireTrace(4, new FastStringBuffer().append("[JcoAPI] JCO.Client.endCall() throws exception ").append(Trace.CRLF).append(sw.getBuffer().toString()).toString());
            }
            throw ex;
        }
    }

    void setSessionState(boolean stateful, String sesId) {
        if (!this.isValid()) {
            throw new JCoRuntimeException(121, "JCO_ERROR_NULL_HANDLE", "Handle 0 encountered in setSessionId");
        }
        if (stateful) {
            if (this.sessionId == null) {
                this.sessionId = sesId;
            } else if (!this.sessionId.equals(sesId)) {
                throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "Unable to set the session id [" + sesId + "] since the previous session [" + this.sessionId + "] was not end");
            }
        } else {
            this.sessionId = null;
        }
    }

    void accept() throws JCoException {
        this.middlewareServer.accept(this);
        String connId = new StringBuilder(100).append(this.getConnectionHandle()).append("-").append(this.serverGroup.getServerKey()).toString();
        this.setConnectionId(connId);
    }

    @Override
    MonitoredConnectionData getMonitoredData() {
        MonitoredConnectionData md = super.getMonitoredData();
        md.application = this.serverGroup.getProperties().getProperty("jco.server.application");
        if (md.application == null) {
            md.application = "";
        }
        md.connType = "SERVER (conn)";
        md.group = this.getServer().getServerKey();
        return md;
    }
}

