/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.monitor.JCoConnectionData;
import com.sap.conn.jco.monitor.JCoConnectionMonitor;
import com.sap.conn.jco.rt.AbstractConnection;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import com.sap.conn.jco.rt.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConnectionMonitor
extends JCoConnectionMonitor {
    private Object mutex = new Object();
    private boolean collecting = false;
    private Map<String, List<AbstractConnection>> externalGroups = new HashMap<String, List<AbstractConnection>>(3);
    private List<MonitoredConnectionData> monitoredData = new ArrayList<MonitoredConnectionData>();

    ConnectionMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected List<? extends JCoConnectionData> getConnsData() {
        RuntimeException exception;
        block39: {
            ArrayList<MonitoredConnectionData> monitoredDataTmp;
            block38: {
                Object object = this.mutex;
                // MONITORENTER : object
                if (this.collecting) {
                    try {
                        this.mutex.wait();
                    }
                    catch (InterruptedException ex) {
                        throw new RuntimeException("operation was interrupted", ex);
                    }
                    if (Trace.isOn(128, true)) {
                        StringBuilder msg = new StringBuilder("[JCoAPI] ConnectionMonitor ");
                        msg.append("reports ").append(this.monitoredData.size()).append(" connections. Data was collected by an other thread.");
                        Trace.fireTrace(128, msg.toString());
                    }
                    // MONITOREXIT : object
                    return this.monitoredData;
                }
                this.collecting = true;
                // MONITOREXIT : object
                monitoredDataTmp = new ArrayList<MonitoredConnectionData>();
                exception = null;
                ConnectionManager.getConnectionManager().getMonitoredData(monitoredDataTmp);
                JCoRuntimeFactory.getRuntime().getJCoServerFactoryInstance().getMonitoredData(monitoredDataTmp);
                if (this.externalGroups.isEmpty()) break block38;
                ArrayList<String> groupNames = new ArrayList<String>();
                Class<ConnectionMonitor> clazz = ConnectionMonitor.class;
                // MONITORENTER : com.sap.conn.jco.rt.ConnectionMonitor.class
                groupNames.addAll(this.externalGroups.keySet());
                // MONITOREXIT : clazz
                Iterator groupsIt = groupNames.iterator();
                ArrayList<AbstractConnection> groupCopy = new ArrayList<AbstractConnection>();
                while (groupsIt.hasNext()) {
                    groupCopy.clear();
                    Class<ConnectionMonitor> clazz2 = ConnectionMonitor.class;
                    // MONITORENTER : com.sap.conn.jco.rt.ConnectionMonitor.class
                    String groupName = (String)groupsIt.next();
                    List<AbstractConnection> group = this.externalGroups.get(groupName);
                    if (group == null) {
                        // MONITOREXIT : clazz2
                        continue;
                    }
                    groupCopy.addAll(group);
                    // MONITOREXIT : clazz2
                    for (AbstractConnection conn : groupCopy) {
                        MonitoredConnectionData mcd = conn.getMonitoredData();
                        mcd.group = groupName;
                        monitoredDataTmp.add(mcd);
                    }
                }
            }
            try {
                int traceLevel;
                int n = traceLevel = exception == null ? 128 : 4;
                if (Trace.isOn(traceLevel, true)) {
                    StringBuilder msg = new StringBuilder("[JCoAPI] ConnectionMonitor ");
                    if (exception != null) {
                        msg.append("thrown exception ").append(exception.toString());
                    } else {
                        msg.append("reports ").append(monitoredDataTmp.size()).append(" connections.");
                    }
                    Trace.fireTrace(traceLevel, msg.toString(), exception);
                }
            }
            catch (RuntimeException excInFinally) {
                // empty catch block
            }
            Object excInFinally = this.mutex;
            // MONITORENTER : excInFinally
            this.monitoredData = monitoredDataTmp;
            this.collecting = false;
            this.mutex.notifyAll();
            // MONITOREXIT : excInFinally
            break block39;
            catch (RuntimeException exc) {
                try {
                    exception = exc;
                }
                catch (Throwable throwable) {
                    try {
                        int traceLevel;
                        int n = traceLevel = exception == null ? 128 : 4;
                        if (Trace.isOn(traceLevel, true)) {
                            StringBuilder msg = new StringBuilder("[JCoAPI] ConnectionMonitor ");
                            if (exception != null) {
                                msg.append("thrown exception ").append(exception.toString());
                            } else {
                                msg.append("reports ").append(monitoredDataTmp.size()).append(" connections.");
                            }
                            Trace.fireTrace(traceLevel, msg.toString(), exception);
                        }
                    }
                    catch (RuntimeException excInFinally2) {
                        // empty catch block
                    }
                    Object object = this.mutex;
                    // MONITORENTER : object
                    this.monitoredData = monitoredDataTmp;
                    this.collecting = false;
                    this.mutex.notifyAll();
                    // MONITOREXIT : object
                    throw throwable;
                }
                try {
                    int traceLevel;
                    int n = traceLevel = exception == null ? 128 : 4;
                    if (Trace.isOn(traceLevel, true)) {
                        StringBuilder msg = new StringBuilder("[JCoAPI] ConnectionMonitor ");
                        if (exception != null) {
                            msg.append("thrown exception ").append(exception.toString());
                        } else {
                            msg.append("reports ").append(monitoredDataTmp.size()).append(" connections.");
                        }
                        Trace.fireTrace(traceLevel, msg.toString(), exception);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                Object object = this.mutex;
                // MONITORENTER : object
                this.monitoredData = monitoredDataTmp;
                this.collecting = false;
                this.mutex.notifyAll();
                // MONITOREXIT : object
            }
        }
        if (exception == null) return this.monitoredData;
        throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Unable to collect monitoring data, caused by " + exception.toString(), exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalRegisterConnection(String groupName, AbstractConnection conn) {
        Class<ConnectionMonitor> clazz = ConnectionMonitor.class;
        synchronized (ConnectionMonitor.class) {
            List<AbstractConnection> group = this.externalGroups.get(groupName);
            if (group == null) {
                group = new ArrayList<AbstractConnection>();
                this.externalGroups.put(groupName, group);
            }
            group.add(conn);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static void registerConnection(String groupName, AbstractConnection conn) {
        ConnectionMonitor monitor = JCoRuntimeFactory.getRuntime().getConnectionMonitor();
        if (monitor != null) {
            monitor.internalRegisterConnection(groupName, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalUnregisterConnection(String groupName, AbstractConnection conn) {
        boolean removed = false;
        List<AbstractConnection> group = null;
        Class<ConnectionMonitor> clazz = ConnectionMonitor.class;
        synchronized (ConnectionMonitor.class) {
            group = this.externalGroups.get(groupName);
            if (group != null) {
                removed = group.remove(conn);
                if (group.isEmpty()) {
                    this.externalGroups.remove(groupName);
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (!removed & Trace.isOn(4)) {
                StringBuilder sb = new StringBuilder(200);
                sb.append("[JCoAPI] ConnectionMonitor unable to unregister the client ");
                sb.append(System.identityHashCode(conn)).append(" by the group ").append(groupName);
                sb.append(", because the ").append(group == null ? "client" : "group").append(" is not available");
                Trace.fireTrace(4, sb.toString());
            }
            return;
        }
    }

    public static void unregisterConnection(String groupName, AbstractConnection conn) {
        ConnectionMonitor monitor = JCoRuntimeFactory.getRuntime().getConnectionMonitor();
        if (monitor != null) {
            monitor.internalUnregisterConnection(groupName, conn);
        }
    }
}

