/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.rfc.api.IRfcTable;
import com.sap.conn.rfc.engine.RfcGetImp;
import com.sap.conn.rfc.engine.RfcGetInfo;
import com.sap.conn.rfc.engine.RfcImp;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.engine.RfcValInfo;
import com.sap.conn.rfc.exceptions.RfcException;
import com.sap.conn.rfc.exceptions.RfcGetException;
import com.sap.conn.rfc.exceptions.RfcIoException;

public abstract class RfcGet {
    public static int ab_rfcget(RfcIoOpenCntl act_cntl, RfcGetState rfcstate, RfcGetInfo info_p) throws RfcGetException {
        int rfcid = 0;
        int rfcleng = 0;
        boolean leave_run = false;
        boolean brc = false;
        block54: do {
            byte[] header = new byte[2];
            RfcGet.rfcget_gethead(act_cntl, header);
            rfcid = RfcGet.get_RFCPRO_ID(header);
            RfcGet.rfcget_gethead(act_cntl, header);
            rfcleng = RfcGet.get_RFCPRO_LENG(header);
            if (rfcleng == 65535) {
                byte[] leng32 = new byte[4];
                RfcGet.rfcget_gethead(act_cntl, leng32);
                rfcleng = RfcGet.get_RFCPRO_LENG32(leng32);
            }
            switch (rfcid) {
                case 257: {
                    RfcImp.ab_rfchead(act_cntl, rfcleng);
                    break;
                }
                case 259: {
                    RfcGet.rfcget_protocol(act_cntl);
                    break;
                }
                case 1300: {
                    RfcImp.ab_rfccheck_uuid(act_cntl, rfcleng);
                    break;
                }
                case 262: {
                    RfcImp.ab_rfcUnicodeHeader(act_cntl, rfcleng);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 17: 
                case 18: 
                case 19: 
                case 273: 
                case 276: 
                case 277: 
                case 305: 
                case 336: 
                case 337: 
                case 338: {
                    RfcImp.rfcSetRemoteInfo(act_cntl, rfcid, rfcleng);
                    break;
                }
                case 1282: {
                    if (rfcstate != RfcGetState.DATA) break;
                    RfcGet.rfcget_skip(act_cntl, rfcid, rfcleng);
                    throw new RfcGetException(9, "Received a callback from the communication partner");
                }
                case 1280: {
                    RfcGet.rfcget_skip(act_cntl, rfcid, rfcleng);
                    continue block54;
                }
                case 1025: {
                    if (rfcstate != RfcGetState.DATA) {
                        throw new RfcGetException(6, "Invalid container sequence: Received ABAP exception at an unexpected protocol state: " + (Object)((Object)rfcstate));
                    }
                    RfcImp.ab_rfcerror(act_cntl, info_p, 1025, rfcleng);
                    break;
                }
                case 258: {
                    if (rfcstate != RfcGetState.FUNCTIONNAME) {
                        throw new RfcGetException(6, "Invalid container sequence: Received function name at an unexpected protocol state: " + (Object)((Object)rfcstate));
                    }
                    RfcImp.ab_rfcFunctionName(act_cntl, info_p, rfcleng);
                    leave_run = true;
                    break;
                }
                case 1026: {
                    if (rfcstate != RfcGetState.DATA) {
                        throw new RfcGetException(6, "Invalid container sequence: Received error message at an unexpected protocol state: " + (Object)((Object)rfcstate));
                    }
                    RfcImp.ab_rfcerror(act_cntl, info_p, rfcid, rfcleng);
                    leave_run = true;
                    break;
                }
                case 1041: 
                case 1042: 
                case 1043: 
                case 1044: 
                case 1045: 
                case 1046: 
                case 1047: {
                    if (rfcstate != RfcGetState.DATA) {
                        throw new RfcGetException(6, "Invalid container sequence: Received extended exception data at an unexpected protocol state: " + (Object)((Object)rfcstate));
                    }
                    RfcImp.ab_rfcerror(act_cntl, info_p, rfcid, rfcleng);
                    break;
                }
                case 513: {
                    if (rfcstate != RfcGetState.DATA) {
                        throw new RfcGetException(6, "Invalid container sequence: Received parameter name at an unexpected protocol state: " + (Object)((Object)rfcstate));
                    }
                    RfcImp.ab_rfcname(act_cntl, info_p, rfcleng);
                    rfcstate = RfcGetState.FIELDVALUE;
                    break;
                }
                case 515: {
                    if (rfcstate != RfcGetState.FIELDVALUE) {
                        throw new RfcGetException(6, "Invalid container sequence: Received parameter value at an unexpected protocol state: " + (Object)((Object)rfcstate));
                    }
                    RfcGetImp.ab_rfcfvalue(act_cntl, info_p, rfcleng);
                    rfcstate = RfcGetState.DATA;
                    break;
                }
                case 1298: {
                    rfcstate = RfcGetState.DATA;
                    act_cntl.receivedIsSupplied = true;
                    RfcGet.rfcget_skip(act_cntl, rfcid, rfcleng);
                    continue block54;
                }
                case 517: {
                    RfcImp.ab_rfcname(act_cntl, info_p, rfcleng);
                    RfcGetImp.activateParameter(info_p);
                    break;
                }
                case 769: {
                    if (rfcstate != RfcGetState.DATA) {
                        throw new RfcGetException(6, "Invalid container sequence: Received table name at an unexpected protocol state: " + (Object)((Object)rfcstate));
                    }
                    RfcImp.ab_rfcname(act_cntl, info_p, rfcleng);
                    rfcstate = RfcGetState.TABLEINFO;
                    break;
                }
                case 770: {
                    if (rfcstate != RfcGetState.TABLEINFO) {
                        throw new RfcGetException(6, "Invalid container sequence: Received table info at an unexpected protocol state: " + (Object)((Object)rfcstate));
                    }
                    brc = RfcImp.ab_rfctinfo(act_cntl, info_p, rfcleng);
                    if (!brc) {
                        rfcstate = RfcGetState.TABLECONTENT;
                        break;
                    }
                    rfcstate = RfcGetState.DATA;
                    break;
                }
                case 771: {
                    if (rfcstate != RfcGetState.TABLECONTENT) {
                        throw new RfcGetException(6, "Invalid container sequence: Received table content at an unexpected protocol state: " + (Object)((Object)rfcstate));
                    }
                    brc = RfcImp.ab_rfctcontent(act_cntl, info_p, rfcleng);
                    if (!brc) {
                        rfcstate = RfcGetState.TABLECONTENT;
                        break;
                    }
                    rfcstate = RfcGetState.DATA;
                    break;
                }
                case 772: {
                    if (rfcstate != RfcGetState.TABLECONTENT) {
                        throw new RfcGetException(6, "Invalid container sequence: Received space compressed table content at an unexpected protocol state: " + (Object)((Object)rfcstate));
                    }
                    brc = RfcImp.ab_rfctcompr(act_cntl, info_p, rfcleng);
                    if (!brc) {
                        rfcstate = RfcGetState.TABLECONTENT;
                        break;
                    }
                    rfcstate = RfcGetState.DATA;
                    break;
                }
                case 773: {
                    if (rfcstate != RfcGetState.TABLECONTENT) {
                        throw new RfcGetException(6, "Invalid container sequence: Received compressed table content at an unexpected protocol state: " + (Object)((Object)rfcstate));
                    }
                    RfcImp.ab_rfctcontLZ(act_cntl, info_p, rfcleng, false);
                    rfcstate = RfcGetState.TABLECONTENT;
                    break;
                }
                case 774: {
                    if (rfcstate != RfcGetState.TABLECONTENT) {
                        throw new RfcGetException(6, "Invalid container sequence: Received end of compressed table content at an unexpected protocol state: " + (Object)((Object)rfcstate));
                    }
                    RfcImp.ab_rfctcontLZ(act_cntl, info_p, rfcleng, true);
                    rfcstate = RfcGetState.DATA;
                    break;
                }
                case 816: {
                    RfcGet.rfcget_skip(act_cntl, rfcid, rfcleng);
                    continue block54;
                }
                case 817: {
                    IRfcTable tab;
                    int tableId = RfcImp.receiveDeltaId(act_cntl, rfcleng);
                    if (act_cntl.rfc_role != 'C' || (tab = act_cntl.getDmTable(tableId)) == null) break;
                    tab.setDmState(IRfcTable.DeltaState.CONFIRM);
                    break;
                }
                case 818: {
                    RfcImp.receiveDeltaLog(act_cntl, info_p, rfcleng);
                    if (act_cntl.rfc_role != 'C') break;
                    int tableId = info_p.dmLogEntry.objId;
                    IRfcTable tab = act_cntl.getDmTable(tableId);
                    try {
                        info_p.dmLogEntry.playback(tab, null);
                        break;
                    }
                    catch (RfcException e) {
                        throw new RfcGetException(e.getRc(), (Throwable)e);
                    }
                }
                case 819: {
                    RfcImp.receiveDeltaLog(act_cntl, info_p, rfcleng);
                    break;
                }
                case 820: {
                    if (act_cntl.rfc_role == 'C') {
                        byte[] rfcData = new byte[rfcleng];
                        RfcValInfo valinfo = new RfcValInfo();
                        valinfo.RfcSetValInfoScalar(rfcData, rfcleng);
                        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, rfcleng);
                        int tableId = info_p.dmLogEntry.objId;
                        IRfcTable tab = act_cntl.getDmTable(tableId);
                        try {
                            info_p.dmLogEntry.playback(tab, rfcData);
                            break;
                        }
                        catch (RfcException e) {
                            throw new RfcGetException(e.getRc(), (Throwable)e);
                        }
                    }
                    throw new RfcGetException(23, "Delta management is not available in the server role");
                }
                case 821: {
                    RfcImp.receiveDeltaLog(act_cntl, info_p, rfcleng);
                    if (act_cntl.rfc_role != 'C') break;
                    int tableId = info_p.dmLogEntry.objId;
                    IRfcTable tab = act_cntl.getDmTable(tableId);
                    try {
                        info_p.dmLogEntry.playback(tab, null);
                    }
                    catch (RfcException e) {
                        throw new RfcGetException(e.getRc(), (Throwable)e);
                    }
                    info_p.tab_tabh_delta = tab;
                    info_p.name = tab.getName();
                    rfcstate = RfcGetState.TABLEINFO;
                    break;
                }
                case 822: {
                    IRfcTable tab;
                    int tableId = RfcImp.receiveDeltaId(act_cntl, rfcleng);
                    if (act_cntl.rfc_role != 'C' || (tab = act_cntl.getDmTable(tableId)) == null) break;
                    tab.setDmState(IRfcTable.DeltaState.WITHDRAW);
                    break;
                }
                case 15362: {
                    RfcImp.receiveXMLParameter(info_p);
                    RfcGet.rfcget_skip(act_cntl, rfcid, rfcleng);
                    continue block54;
                }
                case 15365: {
                    if (RfcImp.receiveXMLData(act_cntl, info_p, rfcleng)) break;
                    RfcGet.rfcget_skip(act_cntl, rfcid, rfcleng);
                    continue block54;
                }
                case 16384: {
                    rfcstate = RfcImp.receiveBasXMLInit(act_cntl, info_p, rfcleng);
                    break;
                }
                case 16385: {
                    if (rfcstate != RfcGetState.BASXML_DATA) {
                        throw new RfcGetException(6, "Invalid container sequence: Received basXML segment at an unexpected protocol state: " + (Object)((Object)rfcstate));
                    }
                    RfcImp.receiveBasXMLData(act_cntl, info_p, rfcleng);
                    break;
                }
                case 16386: {
                    if (rfcstate != RfcGetState.BASXML_COMPRESSED_DATA) {
                        throw new RfcGetException(6, "Invalid container sequence: Received compressed basXML segment at an unexpected protocol state: " + (Object)((Object)rfcstate));
                    }
                    RfcImp.receiveBasXMLCompressedData(act_cntl, info_p, rfcleng);
                    break;
                }
                case 16387: {
                    break;
                }
                case 16388: {
                    RfcImp.receiveBasXMLFinish(info_p);
                    rfcstate = RfcGetState.DATA;
                    break;
                }
                case 1059: {
                    rfcstate = RfcImp.receiveClassExceptionInit(act_cntl, info_p, rfcleng);
                    break;
                }
                case 1060: {
                    RfcImp.receiveClassExceptionEnd(act_cntl, info_p);
                    break;
                }
                case 1057: {
                    if (rfcleng == 0) {
                        act_cntl.abapClassExceptionMode = AbapClassException.Mode.FULL;
                        break;
                    }
                    RfcValInfo valinfo = new RfcValInfo();
                    byte[] usageInfo = new byte[1];
                    valinfo.RfcSetValInfoScalar(usageInfo, rfcleng);
                    RfcGetImp.ab_rfcvalue(act_cntl, valinfo, rfcleng);
                    act_cntl.abapClassExceptionMode = usageInfo[0] == 2 ? AbapClassException.Mode.EXCEPTION_CHAIN : AbapClassException.Mode.FULL;
                    break;
                }
                case 1648: 
                case 1649: {
                    if (rfcleng <= 0) break;
                    RfcImp.receiveSso2String(act_cntl, rfcleng);
                    break;
                }
                case 1283: {
                    RfcImp.rfc_debug_stop(act_cntl, rfcleng);
                    break;
                }
                case 260: {
                    RfcImp.receiveTermIoData(act_cntl, rfcleng);
                    break;
                }
                case 65535: {
                    RfcGet.rfcget_skip(act_cntl, rfcid, rfcleng);
                    leave_run = true;
                    continue block54;
                }
                case 1048: {
                    RfcImp.receiveCallStack(act_cntl, info_p, rfcleng);
                    break;
                }
                case 1058: {
                    RfcImp.receiveClassExceptionInfo(act_cntl, info_p, rfcleng);
                    break;
                }
                case 1315: {
                    act_cntl.resetStillNeeded = false;
                    act_cntl.dmCounter = 0;
                    act_cntl.dmStartCounter = 1;
                    act_cntl.identified = false;
                    act_cntl.th_client_id = null;
                    break;
                }
                case 294: {
                    RfcImp.receivePasswordState(act_cntl, rfcleng);
                    break;
                }
                default: {
                    RfcGet.rfcget_skip(act_cntl, rfcid, rfcleng);
                    continue block54;
                }
            }
            RfcGet.rfcget_endcheck(act_cntl, rfcid);
        } while (!leave_run);
        return 0;
    }

    private static void rfcget_gethead(RfcIoOpenCntl act_cntl, byte[] head) throws RfcGetException {
        try {
            act_cntl.ab_rfcread(head, head.length, 0);
        }
        catch (RfcIoException ioEx) {
            throw new RfcGetException(ioEx);
        }
    }

    protected static void rfcget_skip(RfcIoOpenCntl act_cntl, int rid, int rleng) throws RfcGetException {
        if (rid == 0) {
            throw new RfcGetException(2, "Tried to skip invalid container");
        }
        RfcGet.rfcget_data(act_cntl, null, rleng);
        RfcGet.rfcget_endcheck(act_cntl, rid);
    }

    private static void rfcget_data(RfcIoOpenCntl act_cntl, byte[] buffer, int length) throws RfcGetException {
        try {
            act_cntl.ab_rfcread(buffer, length, 0);
        }
        catch (RfcIoException ioEx) {
            throw new RfcGetException(ioEx);
        }
    }

    private static void rfcget_endcheck(RfcIoOpenCntl act_cntl, int rfcid) throws RfcGetException {
        byte[] end_buffer = new byte[2];
        int end_rfcid = 0;
        try {
            act_cntl.ab_rfcread(end_buffer, end_buffer.length, 0);
        }
        catch (RfcIoException ioEx) {
            StringBuilder msg = new StringBuilder(100);
            msg.append("EndCheck cannot read end container for: ");
            msg.append(rfcid);
            msg.append(" rc: ");
            msg.append(ioEx.getIoRcAsString());
            throw new RfcGetException(msg.toString(), ioEx);
        }
        end_rfcid = RfcGet.get_RFCPRO_ID(end_buffer);
        if (end_rfcid != rfcid) {
            StringBuilder msg = new StringBuilder(100);
            msg.append("EndCheck container chain broken for container expected: ");
            msg.append(rfcid);
            msg.append(" received: ");
            msg.append(end_rfcid);
            throw new RfcGetException(4, msg.toString());
        }
    }

    private static void rfcget_protocol(RfcIoOpenCntl act_cntl) throws RfcGetException {
        byte[] buffer = new byte[4];
        try {
            act_cntl.ab_rfcread(buffer, buffer.length, 0);
            int max_version = RfcUtilities.ICM15(buffer);
            act_cntl.protocol = act_cntl.ab_rfcproto(1, max_version);
        }
        catch (RfcIoException ioEx) {
            throw new RfcGetException(ioEx);
        }
    }

    private static int get_RFCPRO_LENG(byte[] rid) {
        return RfcUtilities.ICM03(rid);
    }

    private static int get_RFCPRO_LENG32(byte[] rid) {
        return RfcUtilities.ICM15(rid);
    }

    private static int get_RFCPRO_ID(byte[] rid) {
        return RfcUtilities.ICM03(rid);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RfcGetState {
        FUNCTIONNAME,
        DATA,
        FIELDVALUE,
        TABLEINFO,
        TABLECONTENT,
        BASXML_DATA,
        BASXML_COMPRESSED_DATA;

    }
}

