/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoClassMetaData;
import com.sap.conn.jco.JCoExtendedFieldMetaData;
import com.sap.conn.jco.JCoMetaData;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.JCoRuntime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DefaultClassMetaData
extends AbstractMetaData
implements JCoClassMetaData {
    static final long serialVersionUID = 3000220081119L;
    List<String> parentClasses;
    List<String> implementedInterfaces;
    JCoClassMetaData.JCoAttributeKind[] attributeKind = new JCoClassMetaData.JCoAttributeKind[0];
    boolean[] attributeReadOnly = new boolean[0];
    String[] attributeDeclaringClass = JCoRuntime.EMPTY_STR_ARRAY;
    String[] defaults = JCoRuntime.EMPTY_STR_ARRAY;
    private boolean inRecursiveQuery;

    DefaultClassMetaData(String name, String[] parentClasses, String[] implementedInterfaces, int capacity) {
        super(name);
        this.parentClasses = new ArrayList<String>();
        if (parentClasses != null) {
            this.parentClasses.addAll(Arrays.asList(parentClasses));
        }
        this.implementedInterfaces = new ArrayList<String>();
        if (implementedInterfaces != null) {
            this.implementedInterfaces.addAll(Arrays.asList(implementedInterfaces));
        }
        this.inRecursiveQuery = false;
        this.ensureCapacity(capacity);
    }

    DefaultClassMetaData(JCoClassMetaData obj) {
        super(obj.getName());
        this.copy(obj);
        this.inRecursiveQuery = false;
    }

    protected void copy(JCoClassMetaData obj) {
        if (obj == null) {
            return;
        }
        super.copy(obj);
        this.parentClasses = new ArrayList<String>(obj.getParentClasses());
        this.implementedInterfaces = new ArrayList<String>(obj.getImplementedInterfaces());
        if (obj instanceof DefaultClassMetaData) {
            DefaultClassMetaData dcmd = (DefaultClassMetaData)obj;
            this.fastCopy(dcmd);
            System.arraycopy(dcmd.attributeKind, 0, this.attributeKind, 0, this.numFields);
            System.arraycopy(dcmd.attributeReadOnly, 0, this.attributeReadOnly, 0, this.numFields);
            System.arraycopy(dcmd.attributeDeclaringClass, 0, this.attributeDeclaringClass, 0, this.numFields);
            System.arraycopy(dcmd.defaults, 0, this.defaults, 0, this.numFields);
        } else {
            int n = obj.getFieldCount();
            for (int i = 0; i < n; ++i) {
                this.add(obj.getDeclaringClass(i), obj.getName(i), obj.getType(i), obj.getByteLength(i), obj.getDecimals(i), obj.getDescription(i), obj.getRecordTypeName(i), obj.getExtendedFieldMetaData(i), obj.getAttributeKind(i), obj.isReadOnly(i), obj.getDefault(i));
            }
        }
    }

    @Override
    protected void onLock() {
        this.parentClasses = Collections.unmodifiableList(this.parentClasses);
        this.implementedInterfaces = Collections.unmodifiableList(this.implementedInterfaces);
    }

    @Override
    protected String toString(int level) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.recName).append(JCoRuntime.CRLF);
        if (this.parentClasses.size() > 0) {
            this.appendBlanks(sb, level * 10);
            for (i = 0; i < this.parentClasses.size(); ++i) {
                sb.append(this.parentClasses.get(i)).append(i == this.parentClasses.size() - 1 ? "" : ", ");
            }
            sb.append(JCoRuntime.CRLF);
        }
        if (this.implementedInterfaces.size() > 0) {
            this.appendBlanks(sb, level * 10);
            for (i = 0; i < this.implementedInterfaces.size(); ++i) {
                sb.append(this.implementedInterfaces.get(i)).append(i == this.implementedInterfaces.size() - 1 ? "" : ", ");
            }
            sb.append(JCoRuntime.CRLF);
        }
        for (i = 0; i < this.numFields; ++i) {
            this.appendBlanks(sb, level * 10);
            sb.append(this.attributeDeclaringClass[i]);
            this.appendBlanks(sb, 32 - this.attributeDeclaringClass[i].length());
            sb.append(this.name[i]);
            this.appendBlanks(sb, 32 - this.name[i].length());
            sb.append(',');
            if (this.tabMeta[i] instanceof String) {
                sb.append((String)((Object)this.tabMeta[i]));
                this.appendBlanks(sb, 32 - ((String)((Object)this.tabMeta[i])).length());
            } else if (this.tabMeta[i] instanceof JCoMetaData) {
                String recordName = ((JCoMetaData)this.tabMeta[i]).getName();
                sb.append(recordName);
                this.appendBlanks(sb, 32 - recordName.length());
            } else {
                this.appendBlanks(sb, 32);
            }
            sb.append(',');
            sb.append(DefaultClassMetaData.getJCOTypeChar(this.type[i]));
            sb.append(',');
            sb.append(this.blength[i]);
            sb.append(',');
            sb.append(this.boffset[i]);
            sb.append(',');
            sb.append(this.length[0][i]);
            sb.append(',');
            sb.append(this.decimals[i]);
            sb.append(',');
            sb.append(this.getDefault(i) != null ? this.getDefault(i) : " ");
            sb.append(',');
            sb.append(this.getDescription(i) != null ? this.getDescription(i) : " ");
            if (this.tabMeta[i] instanceof AbstractMetaData && !(this.tabMeta[i] instanceof DefaultClassMetaData)) {
                sb.append(JCoRuntime.CRLF);
                sb.append(((AbstractMetaData)this.tabMeta[i]).toString(level + 1));
                continue;
            }
            sb.append(JCoRuntime.CRLF);
        }
        sb.append(JCoRuntime.CRLF);
        return sb.toString();
    }

    @Override
    public List<String> getParentClasses() {
        return this.parentClasses;
    }

    @Override
    public List<String> getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    @Override
    public JCoClassMetaData.JCoAttributeKind getAttributeKind(String attributeName) {
        return this.getAttributeKind(this.indexOf(attributeName));
    }

    @Override
    public JCoClassMetaData.JCoAttributeKind getAttributeKind(int index) {
        this.checkIndex(index);
        return this.attributeKind[index];
    }

    @Override
    public boolean isReadOnly(String attributeName) {
        return this.isReadOnly(this.indexOf(attributeName));
    }

    @Override
    public boolean isReadOnly(int index) {
        this.checkIndex(index);
        return this.attributeReadOnly[index];
    }

    @Override
    public String getDeclaringClass(String attributeName) {
        return this.getDeclaringClass(this.indexOf(attributeName));
    }

    @Override
    public String getDeclaringClass(int index) {
        this.checkIndex(index);
        return this.attributeDeclaringClass[index];
    }

    @Override
    public String getDefault(int index) {
        this.checkIndex(index);
        if (index < this.defaults.length) {
            return this.defaults[index];
        }
        return null;
    }

    @Override
    public String getDefault(String fieldName) {
        return this.getDefault(this.indexOf(fieldName));
    }

    @Override
    public void ensureCapacity(int capacity) {
        if (this.name.length < capacity) {
            super.ensureCapacity(capacity);
            JCoClassMetaData.JCoAttributeKind[] oldAttributeKind = this.attributeKind;
            this.attributeKind = new JCoClassMetaData.JCoAttributeKind[capacity];
            System.arraycopy(oldAttributeKind, 0, this.attributeKind, 0, oldAttributeKind.length);
            boolean[] oldAttributeReadOnly = this.attributeReadOnly;
            this.attributeReadOnly = new boolean[capacity];
            System.arraycopy(oldAttributeReadOnly, 0, this.attributeReadOnly, 0, oldAttributeReadOnly.length);
            String[] oldAttributeDeclaringClass = this.attributeDeclaringClass;
            this.attributeDeclaringClass = new String[capacity];
            System.arraycopy(oldAttributeDeclaringClass, 0, this.attributeDeclaringClass, 0, oldAttributeDeclaringClass.length);
            String[] oldDefaults = this.defaults;
            this.defaults = new String[capacity];
            System.arraycopy(oldDefaults, 0, this.defaults, 0, oldDefaults.length);
        }
    }

    public void add(String declaringClass, String fieldname, int fieldType, int byteLength, JCoClassMetaData.JCoAttributeKind jcoAttributeKind, boolean readOnly) {
        this.add(declaringClass, fieldname, fieldType, byteLength, 0, null, null, null, jcoAttributeKind, readOnly, null);
    }

    public void add(String declaringClass, String fieldname, JCoClassMetaData classMetaData, JCoClassMetaData.JCoAttributeKind jcoAttributeKind, boolean readOnly) {
        this.add(declaringClass, fieldname, 16, 8, 0, null, classMetaData, null, jcoAttributeKind, readOnly, null);
    }

    @Override
    public void add(String declaringClass, String fieldName, int fieldtype, int charLength, int decimals, String description, Object metaData, JCoExtendedFieldMetaData extended, JCoClassMetaData.JCoAttributeKind jcoAttributeKind, boolean readOnly, String defaultValue) {
        super.add(fieldName, fieldtype, charLength, charLength, decimals, description, metaData, extended);
        int index = this.numFields - 1;
        this.attributeKind[index] = jcoAttributeKind;
        this.attributeReadOnly[index] = readOnly;
        this.attributeDeclaringClass[index] = declaringClass;
        this.defaults[index] = defaultValue;
    }

    @Override
    public void addParentClass(String parentClass) {
        if (this.isLocked()) {
            throw new UnsupportedOperationException("The JCoClassMetaData object " + this.getName() + " is already locked. Changing the instance is no longer possible");
        }
        this.parentClasses.add(parentClass);
    }

    @Override
    public void addImplementedInterface(String implementedInterface) {
        if (this.isLocked()) {
            throw new UnsupportedOperationException("The JCoClassMetaData object " + this.getName() + " is already locked. Changing the instance is no longer possible");
        }
        this.implementedInterfaces.add(implementedInterface);
    }

    boolean isInRecursiveQuery() {
        return this.inRecursiveQuery;
    }

    void setInRecursiveQuery(boolean inRecursiveQuery) {
        this.inRecursiveQuery = inRecursiveQuery;
    }
}

