/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.data;

import com.sap.conn.rfc.api.IRfcTable;

public final class LZTable
implements IRfcTable {
    public static final int TABLE_LZ_SIZE = 250;
    IRfcTable.DeltaState state;
    private byte[][] contents;
    private int numRows;
    private int capacity;
    String name;

    public LZTable(String name) {
        this.name = name;
        this.capacity = 64;
        this.contents = new byte[this.capacity][];
        this.numRows = 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public byte[] getBytes(int row) {
        if (row >= this.numRows || row < 0) {
            throw new ArrayIndexOutOfBoundsException("No such row " + row + "; possible: [0-" + (this.numRows - 1) + ']');
        }
        if (this.contents[row] == null) {
            return new byte[0];
        }
        return this.contents[row];
    }

    @Override
    public void setBytes(int row, byte[] rfcBytes) {
        if (row >= this.numRows || row < 0) {
            throw new ArrayIndexOutOfBoundsException("No such row " + row + "; possible: [0-" + (this.numRows - 1) + ']');
        }
        System.arraycopy(rfcBytes, 0, this.contents[row], 0, Math.min(rfcBytes.length, 250));
    }

    @Override
    public void appendRow(byte[] rfcBytes) {
        this.ensureBufferCapacity(this.numRows + 1);
        this.contents[this.numRows] = new byte[250];
        System.arraycopy(rfcBytes, 0, this.contents[this.numRows], 0, Math.min(rfcBytes.length, 250));
        ++this.numRows;
    }

    @Override
    public void appendRows(int rows) {
        int newNumRows = this.numRows + rows;
        this.ensureBufferCapacity(newNumRows);
        for (int i = this.numRows; i < newNumRows; ++i) {
            this.contents[i] = new byte[250];
        }
        this.numRows = newNumRows;
    }

    @Override
    public void clear() {
        this.numRows = 0;
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getRowLength() {
        return 250;
    }

    @Override
    public void ensureBufferCapacity(int rows) {
        if (this.capacity < rows) {
            int newCapacity = 2 * this.capacity;
            byte[][] newContents = new byte[newCapacity][];
            System.arraycopy(this.contents, 0, newContents, 0, this.numRows);
            this.contents = newContents;
            this.capacity = newCapacity;
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void setActive() {
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public boolean deleteRow(int row) {
        if (row < 0 || row >= this.numRows) {
            return false;
        }
        for (int i = row; i < this.numRows - 1; ++i) {
            this.contents[i] = this.contents[i + 1];
        }
        --this.numRows;
        return true;
    }

    @Override
    public boolean insertRow(int row) {
        if (row < 0 || row >= this.numRows) {
            return false;
        }
        ++this.numRows;
        this.ensureBufferCapacity(this.numRows);
        byte[] tmp = this.contents[this.numRows - 1];
        for (int i = this.numRows - 1; i > row; ++i) {
            this.contents[i] = this.contents[i - 1];
        }
        this.contents[row] = tmp;
        return true;
    }

    @Override
    public void setDmState(IRfcTable.DeltaState state) {
        this.state = state;
    }
}

