package com.haomostudio.SpringMVCProjectTemplate.controller;

import com.haomostudio.SpringMVCProjectTemplate.service.ActivitiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;

/**
 * Created by hxgqh on 2016/10/6.
 */
public class ActivitiController {
    @Autowired
    ActivitiService activitiService;

    @Autowired
    HttpServletResponse response;

    @RequestMapping(value = "/activities", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    @ResponseBody
    public Object getActivities(
            @RequestHeader(value = "X-Auth-Token") String token,
            @RequestHeader(value = "page_no") Integer pageNo,
            @RequestHeader(value = "page_size") Integer pageSize,
            @RequestHeader(value = "sort_item") String sortItem,
            @RequestHeader(value = "sort_order") String sortOrder,
            @RequestHeader(value = "filters") String filters
            ) {
        return activitiService.getListWithPagingAndFilter(
                pageNo, pageSize, sortItem, sortOrder, filters);
    }
}
