/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.rfc.api.RfcApi;
import java.net.Inet6Address;
import java.net.InetAddress;

public final class AbSysInfo {
    public static final byte SYSINT_BIG_ENDIAN = 2;
    public static final byte SYSINT_LITTLE_ENDIAN = 1;
    public static final byte SYSFLOAT_IEEE = 1;
    public static final byte SYSFLOAT_370 = 2;
    public static byte intformat = (byte)2;
    public static byte floatformat = 1;
    public static final boolean littleEndianPlatform;
    public static final boolean nonUnicodePlatform;
    public static final String charset;
    public static final String pcs_charset = "1100";
    public static final String SapRelease = "720";
    public static String programName;
    public static final String ipAddress;
    public static final String ipv6Address;
    public static final String host;
    public static final char[] proto;
    public static final char[] rfcinttype;
    public static final char[] rfcflotyp;
    static final String[] intFormats;
    static final String[] floatFormats;
    static final String[] compressionFormats;
    static final String[] conversionErrorBehavior;

    public static String getIPv4Address(Inet6Address ipv6Address) {
        byte[] address = ipv6Address.getAddress();
        return new StringBuilder(15).append(address[12] & 0xFF).append('.').append(address[13] & 0xFF).append('.').append(address[14] & 0xFF).append('.').append(address[15] & 0xFF).toString();
    }

    static {
        programName = "SAPJCo";
        proto = new char[]{'0', '1', '1'};
        rfcinttype = new char[]{'B', 'I', 'G'};
        rfcflotyp = new char[]{'I', 'E', '3'};
        intFormats = new String[]{"???", "LIT", "BIG"};
        floatFormats = new String[]{"????", "IEEE", "\\370"};
        compressionFormats = new String[]{"", "SPACE", "LZ", "(SPACE)", "(LZ)", "SPACE-U2", "SPACE-U4"};
        conversionErrorBehavior = new String[]{"REJECT", "IGNORE"};
        String name = null;
        String ip = null;
        String ipv6 = null;
        try {
            InetAddress ia = InetAddress.getLocalHost();
            if (ia instanceof Inet6Address) {
                Inet6Address iav6 = (Inet6Address)ia;
                if (iav6.isIPv4CompatibleAddress()) {
                    ip = AbSysInfo.getIPv4Address(iav6);
                }
                ipv6 = iav6.getHostAddress();
            } else {
                ip = ia.getHostAddress();
                ipv6 = null;
            }
            name = ia.getHostName();
        }
        catch (Exception ex) {
            ip = "127.0.0.1";
            ipv6 = null;
            name = "localhost";
        }
        ipAddress = ip;
        ipv6Address = ipv6;
        host = name;
        String ownCodepage = null;
        boolean littleEndian = false;
        try {
            ownCodepage = RfcApi.runtime.getOwnCodepage();
            littleEndian = RfcApi.runtime.isLittleEndian();
        }
        catch (Exception e) {
            ownCodepage = "4102";
            littleEndian = false;
        }
        nonUnicodePlatform = ownCodepage != null && !ownCodepage.startsWith("410");
        littleEndianPlatform = littleEndian;
        charset = littleEndian && !nonUnicodePlatform ? "4103" : "4102";
    }
}

