/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.driver;

import com.sap.conn.jco.util.IntHashTable;
import com.sap.conn.rfc.api.GatewayRegInfo;
import com.sap.conn.rfc.api.RfcAcceptInfo;
import com.sap.conn.rfc.api.RfcOptions;
import com.sap.conn.rfc.api.RfcRegisterInfo;
import com.sap.conn.rfc.driver.CpicDriver;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcException;

public final class RfcTypeRegisterCpic
extends CpicDriver {
    protected static final IntHashTable<RfcIoOpenCntl> niHandles = new IntHashTable(89, 5);
    private boolean flushed = false;
    private boolean readConvid = false;
    protected boolean registered;
    protected int niHandle = 0;
    protected boolean tp_accepted;
    private RfcRegisterInfo register_info;

    @Override
    public synchronized int listen(byte[] buffer, int bufsize, int[] bytes_read, int timeout) {
        int d_rc;
        if (this.act_cntl.close_pending) {
            String text = "listen(RfcTypeRegisterCpic) :: Error : (close_pending)";
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc(text);
            }
            Trc.criticalTrace(this.act_cntl, text);
            return 1;
        }
        if (this.broken) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("listen :: Error : 10\n");
            }
            return 10;
        }
        int rc = 0;
        if (!this.readConvid && (rc = this.receiveConversationID(timeout)) != 0) {
            return rc;
        }
        rc = this.cpic_coxread(0, buffer, this.cmData);
        switch (rc) {
            case -1: {
                return rc;
            }
            case 10003: {
                return 17;
            }
        }
        this.cm_data_received = this.cmData[0];
        this.cm_status_received = this.cmData[1];
        int received_leng = this.cmData[2];
        int cm_org_data_received = this.cm_data_received;
        this.all_received = this.cm_status_received == 1;
        this.cm_retcode = rc;
        ++this.cm_data_received;
        ++this.cm_status_received;
        if (rc != 0) {
            this.deallocated = true;
        }
        if (rc != 0 && rc != 18) {
            this.get_cpic_error("CMRCV");
            return 5;
        }
        if (rc == 18 && (d_rc = this.deallocated_normal_ext(cm_org_data_received, buffer, received_leng)) != 0) {
            int ret;
            int n = ret = d_rc == 2 ? 33 : 10;
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("listen :: Error : " + ret + '\n');
            }
            return ret;
        }
        int input_size = Math.min(buffer.length, received_leng);
        int input_ptr = 0;
        if (this.accepted) {
            this.accepted = false;
            if (RfcUtilities.byteArraySequenceEquals(buffer, 0, ebcdic_conncpic, 0, Math.min(ebcdic_conncpic.length, input_size))) {
                if (input_size < 75) {
                    this.broken = true;
                    this.setMessageTRC("CPIC-CALL: 'CMRCV'\nno login data received\n");
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("listen :: Error : 8\n");
                    }
                    return 8;
                }
                if (RfcUtilities.byteArraySequenceEquals(buffer, 45, ebcdic_trace, 0, 5)) {
                    this.act_cntl.trace = true;
                }
                input_size -= 75;
                input_ptr += 75;
            } else if (buffer[input_ptr] == 84 || buffer[input_ptr] == -29) {
                if (!this.act_cntl.trace) {
                    String text = "trace is turned on by the connection from " + this.act_cntl.destination;
                    Trc.generalInfo(this.act_cntl, text);
                    Trc.ab_rfctrc(text);
                }
                this.act_cntl.traceSetByPartner = true;
                this.act_cntl.trace = true;
                ++input_ptr;
            } else if (this.act_cntl.trace && this.act_cntl.traceSetByPartner) {
                Trc.generalInfo(this.act_cntl, "trace is turned off by the connection from " + this.act_cntl.destination);
                this.act_cntl.trace = false;
            }
        }
        bytes_read[0] = --input_size;
        if (input_size <= 0) {
            this.broken = true;
            this.setMessage("CPIC-CALL: 'CMRCV'\n" + this.getMessage() + '\n');
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("listen :: Error : 8\n");
            }
            return 8;
        }
        if (input_ptr > 0) {
            System.arraycopy(buffer, input_ptr, buffer, 0, input_size);
        }
        this.tOfLastIO = System.currentTimeMillis();
        return 0;
    }

    @Override
    public int open(RfcOptions options) {
        return 1;
    }

    public RfcTypeRegisterCpic(RfcIoOpenCntl iocntl) {
        super(iocntl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int accept(RfcAcceptInfo acceptInfo) {
        int rc = this.registerConnection(acceptInfo);
        if (rc != 0) {
            return rc;
        }
        this.accepted = false;
        this.tOfLastIO = System.currentTimeMillis();
        IntHashTable<RfcIoOpenCntl> intHashTable = niHandles;
        synchronized (intHashTable) {
            niHandles.put(this.niHandle, this.act_cntl);
        }
        rc = this.cosaccepttp(-2);
        if (rc != 0) {
            this.close();
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("accept(RfcTypeRegisterCpic) :: Error : " + rc);
            }
            this.get_rg_info("Connect to SAP gateway failed", this.register_info);
            return 5;
        }
        return 0;
    }

    public int check(RfcAcceptInfo acceptInfo) {
        int rc = this.registerConnection(acceptInfo);
        if (rc == 0) {
            this.close();
        }
        return rc;
    }

    private int registerConnection(RfcAcceptInfo acceptInfo) {
        String sapRouter;
        this.register_info = (RfcRegisterInfo)acceptInfo;
        this.accepted = false;
        this.deallocated = true;
        this.registered = true;
        this.tp_accepted = false;
        this.act_cntl.snc = this.register_info.usesSNC();
        String gwhost = this.register_info.getGatewayHost();
        if (gwhost == null) {
            gwhost = "";
        }
        if ((sapRouter = this.register_info.getSAPRouter()) != null && sapRouter.length() > 0) {
            StringBuilder gwhost_buf = new StringBuilder(sapRouter.length() + gwhost.length() + 3);
            gwhost_buf.append(sapRouter);
            if (!sapRouter.endsWith("/H/")) {
                gwhost_buf.append("/H/");
            }
            gwhost_buf.append(gwhost);
            gwhost = gwhost_buf.toString();
        }
        int[] regHandle = new int[]{this.niHandle};
        int rc = this.SAP_CMREGTP3(this.register_info.getProgramID(), gwhost, this.register_info.getGatewayService(), regHandle, this.register_info.getSNCMyName(), this.register_info.getSNCLibrary(), this.register_info.getSNCQuality(), this.register_info.usesSNC());
        this.niHandle = regHandle[0];
        if (rc != 0) {
            this.registered = false;
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("accept(RfcTypeRegisterCpic) :: Error : " + rc);
            }
            this.get_rg_info("Connect to SAP gateway failed", this.register_info);
            return 5;
        }
        return 0;
    }

    @Override
    public synchronized int read(byte[] buffer, int bufsize, int[] bytes_read) {
        if (this.act_cntl.close_pending) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("wflush(RFCTypeRegisterCpic) :: read : (close_pending)");
            }
            return 1;
        }
        return this.coxread(buffer, bufsize, bytes_read, 0);
    }

    @Override
    public synchronized int write(byte[] buffer, int buffersize, boolean last) {
        this.flushed = false;
        return super.write(buffer, buffersize, last);
    }

    @Override
    public synchronized int wflush() {
        if (!this.deallocated && this.server_mode) {
            int rc = 0;
            if (!this.act_cntl.isStateful() && !this.act_cntl.reg_exclusiv && this.act_cntl.unresp_call == 0 || this.act_cntl.close_pending) {
                rc = this.CMDEAL();
                if (rc != 0) {
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("wflush(RFCTypeRegisterCpic) in CMDEAL:: Error : " + rc);
                    }
                    return rc;
                }
                this.deallocated = true;
                this.tp_accepted = false;
                this.accepted = false;
                this.act_cntl.identified = false;
                rc = this.cosaccepttp(-2);
                if (rc != 0) {
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("wflush(RFCTypeRegisterCpic) in cosaccepttp:: Error : " + rc);
                    }
                    return rc;
                }
            } else if (!this.act_cntl.inCallback && !this.flushed) {
                rc = this.SAP_CMLISTEN3();
                if (rc != 0) {
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("wflush(RFCTypeRegisterCpic) in SAP_CMLISTEN3:: Error : " + rc);
                    }
                    return rc;
                }
                this.flushed = true;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int receiveConversationID(int waitTime) {
        int rc = 0;
        int loops = 0;
        do {
            rc = this.SAP_CMACCPTP3(this.niHandle, waitTime);
            if (!this.act_cntl.trace) continue;
            Trc.ab_rfctrc(new StringBuilder(200).append("receiveConversationID: SAP_CMACCPTP3(waitTime=").append(waitTime).append(", conv_id=").append(Trc.convIDToString(this.conv_id)).append(", niHandle=").append(this.niHandle).append(") returns: ").append(String.valueOf(rc)).append("\n").toString());
        } while (rc == 10001 && loops++ < 100);
        if (rc != 0) {
            this.deallocated = true;
            switch (rc) {
                case 18: {
                    this.registered = false;
                    rc = 23;
                    break;
                }
                case 10003: {
                    this.registered = true;
                    rc = 17;
                    break;
                }
                case 20: {
                    this.registered = false;
                    this.get_cpic_error("SAP_CMACCPTP3");
                    rc = 5;
                    break;
                }
                case 6: {
                    this.registered = true;
                    this.get_cpic_error("SAP_CMACCPTP3");
                    rc = 35;
                    break;
                }
                default: {
                    RfcIoOpenCntl cntl;
                    this.registered = true;
                    this.get_cpic_error("SAP_CMACCPTP3");
                    IntHashTable<RfcIoOpenCntl> intHashTable = niHandles;
                    synchronized (intHashTable) {
                        cntl = niHandles.get(this.niHandle);
                    }
                    Trc.criticalTrace(this.act_cntl.hrfc, "ERROR: receiveConversationID: SAP_CMACCPTP3(waitTime=" + waitTime + ", niHandle=" + this.niHandle + ") returns: " + rc + " after " + loops + " attempts: RFC handle is [" + (cntl == null ? "null" : Long.valueOf(cntl.hrfc)) + "]");
                    rc = 3;
                }
            }
            if (!this.registered) {
                IntHashTable<RfcIoOpenCntl> intHashTable = niHandles;
                synchronized (intHashTable) {
                    niHandles.remove(this.niHandle);
                }
            }
        } else {
            this.deallocated = false;
            this.readConvid = true;
            this.act_cntl.updateConvID();
        }
        return rc;
    }

    int cosaccepttp(int wtime) {
        if (wtime == -2 || !this.tp_accepted) {
            this.act_cntl.systnr = null;
            this.act_cntl.sysid = null;
            this.act_cntl.target = null;
            this.act_cntl.kernel_rel = null;
            this.act_cntl.partner_rel = null;
            this.act_cntl.partner_type = '\u0000';
            this.act_cntl.userid = null;
            this.act_cntl.cuserid = null;
            this.act_cntl.lang = null;
            this.act_cntl.mandt = null;
            this.act_cntl.th_client_id = null;
            this.act_cntl.rfc_uuid_set = false;
            this.act_cntl.rfc_uuid = null;
            this.deallocated = true;
            this.readConvid = false;
            int rc = 0;
            do {
                rc = this.SAP_CMACCPTP3(this.niHandle, wtime);
                if (!this.act_cntl.trace) continue;
                Trc.ab_rfctrc("cosaccepttp: SAP_CMACCPTP3(waitTime=" + wtime + ", conv_id=" + Trc.convIDToString(this.conv_id) + ", niHandle=" + this.niHandle + ") returns: " + rc + "\n");
            } while (rc == 10001);
            if (rc != 0) {
                this.registered = false;
                this.get_cpic_error("SAP_CMACCPTP3");
                if (rc == 18) {
                    return 23;
                }
                return 5;
            }
            this.tOfLastIO = System.currentTimeMillis();
            this.server_mode = true;
            this.accepted = true;
            this.tp_accepted = true;
        }
        return 0;
    }

    private String get_rg_info(String text, RfcRegisterInfo register_info) {
        StringBuilder errbuf = new StringBuilder(128);
        String ptr = RfcTypeRegisterCpic.SAP_CMPERR();
        String msg = null;
        this.clearMessage();
        errbuf.append(text).append(register_info.errMsgConnectParams()).append("\n");
        if (ptr != null) {
            errbuf.append(ptr);
        } else {
            errbuf.append("No specific error info available");
        }
        msg = errbuf.toString();
        this.setMessage(msg);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RfcIoOpenCntl getNextListener() {
        int[] regHandle = new int[1];
        int rc = RfcTypeRegisterCpic.SAP_CMGETNEXTHDL(regHandle);
        if (rc == 0) {
            RfcIoOpenCntl cntl = null;
            if (regHandle[0] != -1) {
                IntHashTable<RfcIoOpenCntl> intHashTable = niHandles;
                synchronized (intHashTable) {
                    cntl = niHandles.get(regHandle[0]);
                }
                if (cntl == null) {
                    Trc.criticalTrace(null, "NI handle [" + regHandle[0] + "] cannot be resolved");
                } else if (RfcIoOpenCntl.isGeneralTraceOn()) {
                    Trc.ab_rfctrc(new StringBuilder(70).append("getNextListener: SAP_CMGETNEXTHDL(").append(regHandle[0]).append(") returns: RFC handle [").append(cntl.hrfc).append("]\n\n").toString());
                }
            }
            return cntl;
        }
        Trc.criticalTrace(null, "SAP_CMGETNEXTHDL [" + regHandle[0] + "] returned " + rc);
        return null;
    }

    public static int waitForRequest(long timeout) {
        int rc = RfcTypeRegisterCpic.SAP_CMLISTEN((int)timeout);
        switch (rc) {
            case 10001: {
                return 7;
            }
            case 0: {
                return 4;
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        int rc = 0;
        if (!this.deallocated) {
            rc = this.CMDEAL();
            if (rc != 0) {
                Trc.criticalTrace(this.act_cntl, "CMDEAL returned " + rc);
            }
            this.deallocated = true;
        }
        this.readConvid = false;
        if (this.registered) {
            rc = this.SAP_CMUNREGTP3(this.niHandle);
            if (rc != 0) {
                Trc.criticalTrace(this.act_cntl, "SAP_CMUNREGTP3 returned " + rc);
            }
            this.registered = false;
        }
        IntHashTable<RfcIoOpenCntl> intHashTable = niHandles;
        synchronized (intHashTable) {
            niHandles.remove(this.niHandle);
        }
        this.tOfLastIO = System.currentTimeMillis();
    }

    @Override
    public synchronized void abort() {
        this.close();
    }

    public static int getNumServerConnections(RfcAcceptInfo acceptInfo) throws RfcException {
        RfcRegisterInfo register_info = (RfcRegisterInfo)acceptInfo;
        register_info.checkParameters();
        int[] numberRegTPs = RfcTypeRegisterCpic.execute_SAP_CMNOREGTP(register_info);
        return numberRegTPs[0];
    }

    public static GatewayRegInfo getGatewayRegInfo(RfcIoOpenCntl cntl) throws RfcException {
        GatewayRegInfo gwInfo = null;
        try {
            RfcTypeRegisterCpic rfcRegistered = (RfcTypeRegisterCpic)cntl.getChannel();
            int[] numberRegTPs = RfcTypeRegisterCpic.execute_SAP_CMNOREGTP(rfcRegistered.register_info);
            gwInfo = new GatewayRegInfo(numberRegTPs[0], numberRegTPs[1], numberRegTPs[2], numberRegTPs[3]);
        }
        catch (ClassCastException e) {
            gwInfo = null;
        }
        return gwInfo;
    }

    private static int[] execute_SAP_CMNOREGTP(RfcRegisterInfo regInfo) throws RfcException {
        String sapRouter;
        String gwhost = regInfo.getGatewayHost();
        if (gwhost == null) {
            gwhost = "";
        }
        if ((sapRouter = regInfo.getSAPRouter()) != null && sapRouter.length() > 0) {
            StringBuilder gwhost_buf = new StringBuilder(sapRouter.length() + gwhost.length() + 3);
            gwhost_buf.append(sapRouter);
            if (!sapRouter.endsWith("/H/")) {
                gwhost_buf.append("/H/");
            }
            gwhost_buf.append(gwhost);
            gwhost = gwhost_buf.toString();
        }
        int[] numberRegTPs = new int[4];
        int rc = RfcTypeRegisterCpic.SAP_CMNOREGTP(regInfo.getProgramID(), gwhost, regInfo.getGatewayService(), numberRegTPs);
        if (rc != 0) {
            String message = null;
            int group = 0;
            if (rc == 1) {
                message = "Error in JNI operation. See default error log";
                group = 108;
            } else {
                message = RfcTypeRegisterCpic.SAP_CMPERR();
                group = 102;
            }
            throw new RfcException(1, message, group, 0L, false, null);
        }
        return numberRegTPs;
    }
}

