/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcPut;
import com.sap.conn.rfc.exceptions.RfcIoException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class BasXMLOutputStream
extends OutputStream {
    public static final int BAS_XML_BUFFER_CAPACITY = 8192;
    RfcIoOpenCntl act_cntl;
    byte[] buf = new byte[8192];
    int pos;
    byte[] compressionBuffer;
    int compressionOffset;
    Deflater deflater;
    boolean startCompression;
    boolean sentHeader;
    boolean isStreamForClassException;
    int count;

    public BasXMLOutputStream(RfcIoOpenCntl act_cntl, boolean compressionAllowed) {
        this(act_cntl, compressionAllowed, false);
    }

    public BasXMLOutputStream(RfcIoOpenCntl act_cntl, boolean compressionAllowed, boolean forClassException) {
        this.startCompression = compressionAllowed;
        this.act_cntl = act_cntl;
        this.pos = 0;
        this.count = 0;
        this.deflater = null;
        this.sentHeader = false;
        this.isStreamForClassException = forClassException;
    }

    private void sendHeader() throws RfcIoException {
        byte[] basXMLHeader = new byte[]{1, (byte)(this.deflater != null ? 1 : 0)};
        RfcPut.ab_rfcput(this.act_cntl, this.isStreamForClassException ? 1059 : 16384, basXMLHeader, 2, 0);
    }

    @Override
    public void close() throws RfcIoException {
        if (this.deflater != null) {
            this.deflater.setInput(this.buf, 0, this.pos);
            this.deflater.finish();
            int compressedCount = 0;
            do {
                compressedCount = this.deflater.deflate(this.compressionBuffer, this.compressionOffset, this.compressionBuffer.length - this.compressionOffset);
                this.compressionOffset += compressedCount;
                if (this.compressionOffset != 8192) continue;
                RfcPut.ab_rfcput(this.act_cntl, 16386, this.compressionBuffer, 8192, 0);
                this.compressionOffset = 0;
            } while (compressedCount != 0);
            this.deflater.end();
            if (this.compressionOffset > 0) {
                RfcPut.ab_rfcput(this.act_cntl, 16386, this.compressionBuffer, this.compressionOffset, 0);
                this.compressionOffset = 0;
            }
        } else {
            this.flush(false);
        }
        RfcPut.ab_rfcput(this.act_cntl, this.isStreamForClassException ? 1060 : 16388);
    }

    private void writeToDeflater(byte[] toCompress, int offset, int length) throws RfcIoException {
        this.deflater.setInput(toCompress, offset, length);
        int compressedCount = 0;
        do {
            compressedCount = this.deflater.deflate(this.compressionBuffer, this.compressionOffset, this.compressionBuffer.length - this.compressionOffset);
            this.compressionOffset += compressedCount;
            if (this.compressionOffset != 8192) continue;
            RfcPut.ab_rfcput(this.act_cntl, 16386, this.compressionBuffer, 8192, 0);
            this.compressionOffset = 0;
        } while (!this.deflater.needsInput());
    }

    @Override
    public void flush() throws RfcIoException {
        this.flush(true);
    }

    public void flush(boolean initializeCompression) throws RfcIoException {
        if (initializeCompression && this.deflater == null) {
            this.compressionBuffer = new byte[8192];
            this.deflater = new Deflater(-1, true);
            this.sendHeader();
            this.sentHeader = true;
        }
        if (this.pos > 0) {
            if (this.deflater != null) {
                this.writeToDeflater(this.buf, 0, this.pos);
            } else {
                this.startCompression = false;
                if (!this.sentHeader) {
                    this.sendHeader();
                    this.sentHeader = true;
                }
                RfcPut.ab_rfcput(this.act_cntl, 16385, this.buf, this.pos, 0);
            }
            this.pos = 0;
        }
    }

    public void write(byte value) throws RfcIoException {
        if (this.pos >= 8192) {
            this.flush(this.startCompression && this.deflater == null);
        }
        this.buf[this.pos++] = value;
        ++this.count;
    }

    @Override
    public void write(byte[] value) throws RfcIoException {
        if (value != null) {
            this.write(value, 0, value.length);
        }
    }

    @Override
    public void write(byte[] value, int offset, int len) throws RfcIoException {
        this.count += len;
        if (len > 8192) {
            this.flush(this.startCompression && this.deflater == null);
            if (this.deflater != null) {
                this.writeToDeflater(value, offset, len);
            } else {
                RfcPut.ab_rfcput(this.act_cntl, 16385, value, len, offset);
            }
        } else {
            if (this.pos + len > 8192) {
                this.flush(this.startCompression && this.deflater == null);
            }
            System.arraycopy(value, offset, this.buf, this.pos, len);
            this.pos += len;
        }
    }

    @Override
    public void write(int dataLength) throws RfcIoException {
        if (dataLength < 128) {
            this.write((byte)dataLength);
        } else if (dataLength < 2048) {
            if (this.pos + 2 > 8192) {
                this.flush(this.startCompression && this.deflater == null);
            }
            this.buf[this.pos++] = (byte)(dataLength >> 6 | 0xC0);
            this.buf[this.pos++] = (byte)(dataLength & 0x3F | 0x80);
            this.count += 2;
        } else if (dataLength < 65536) {
            if (this.pos + 3 > 8192) {
                this.flush(this.startCompression && this.deflater == null);
            }
            this.buf[this.pos++] = (byte)(dataLength >> 12 | 0xE0);
            this.buf[this.pos++] = (byte)(dataLength >> 6 & 0x3F | 0x80);
            this.buf[this.pos++] = (byte)(dataLength & 0x3F | 0x80);
            this.count += 3;
        } else if (dataLength < 0x200000) {
            if (this.pos + 4 > 8192) {
                this.flush(this.startCompression && this.deflater == null);
            }
            this.buf[this.pos++] = (byte)(dataLength >> 18 | 0xF0);
            this.buf[this.pos++] = (byte)(dataLength >> 12 & 0x3F | 0x80);
            this.buf[this.pos++] = (byte)(dataLength >> 6 & 0x3F | 0x80);
            this.buf[this.pos++] = (byte)(dataLength & 0x3F | 0x80);
            this.count += 4;
        } else if (dataLength < 0x4000000) {
            if (this.pos + 5 > 8192) {
                this.flush(this.startCompression && this.deflater == null);
            }
            this.buf[this.pos++] = (byte)(dataLength >> 24 | 0xF8);
            this.buf[this.pos++] = (byte)(dataLength >> 18 & 0x3F | 0x80);
            this.buf[this.pos++] = (byte)(dataLength >> 12 & 0x3F | 0x80);
            this.buf[this.pos++] = (byte)(dataLength >> 6 & 0x3F | 0x80);
            this.buf[this.pos++] = (byte)(dataLength & 0x3F | 0x80);
            this.count += 5;
        } else {
            if (this.pos + 6 > 8192) {
                this.flush(this.startCompression && this.deflater == null);
            }
            this.buf[this.pos++] = (byte)(dataLength >> 30 | 0xFC);
            this.buf[this.pos++] = (byte)(dataLength >> 24 & 0x3F | 0x80);
            this.buf[this.pos++] = (byte)(dataLength >> 18 & 0x3F | 0x80);
            this.buf[this.pos++] = (byte)(dataLength >> 12 & 0x3F | 0x80);
            this.buf[this.pos++] = (byte)(dataLength >> 6 & 0x3F | 0x80);
            this.buf[this.pos++] = (byte)(dataLength & 0x3F | 0x80);
            this.count += 6;
        }
    }

    public int getNumBytes() {
        return this.count;
    }
}

