/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoAbapObject;
import com.sap.conn.jco.JCoBackgroundUnitAttributes;
import com.sap.conn.jco.JCoClassMetaData;
import com.sap.conn.jco.JCoCustomRepository;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoFunctionUnit;
import com.sap.conn.jco.JCoInterface;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRepositoryQueryResult;
import com.sap.conn.jco.JCoRequestUnit;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.JCoThroughput;
import com.sap.conn.jco.JCoTraceListener;
import com.sap.conn.jco.JCoUnitIdentifier;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.ext.JCoSessionReference;
import com.sap.conn.jco.ext.ServerDataProvider;
import com.sap.conn.jco.ext.SessionReferenceProvider;
import com.sap.conn.jco.monitor.JCoDestinationMonitor;
import com.sap.conn.jco.rt.AbapBackgroundUnitAttributes;
import com.sap.conn.jco.rt.AbapExceptionModel;
import com.sap.conn.jco.rt.AbapFunctionTemplate;
import com.sap.conn.jco.rt.AbapFunctionUnit;
import com.sap.conn.jco.rt.AbapRepository;
import com.sap.conn.jco.rt.AbapRequestUnit;
import com.sap.conn.jco.rt.AbstractServerManager;
import com.sap.conn.jco.rt.AutoJobRunner;
import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.ConnectionMonitor;
import com.sap.conn.jco.rt.Context;
import com.sap.conn.jco.rt.CustomRepository;
import com.sap.conn.jco.rt.DefaultAbapObject;
import com.sap.conn.jco.rt.DefaultClassMetaData;
import com.sap.conn.jco.rt.DefaultDestinationManager;
import com.sap.conn.jco.rt.DefaultListMetaData;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.jco.rt.DefaultThroughput;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoMiddleware;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.MetaDataStorage;
import com.sap.conn.jco.rt.RepositoryManager;
import com.sap.conn.jco.rt.SessionTimeoutChecker;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.jco.util.Dsr;
import com.sap.conn.jco.util.Jarm;
import com.sap.conn.jco.util.SharedStorage;
import com.sap.conn.rfc.api.RfcRuntime;
import com.sap.conn.rfc.engine.AbSysInfo;
import com.sap.i18n.decfloat.DecFloat;
import com.sap.i18n.decfloat.DecFloatType;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class JCoRuntime
extends JCoInterface {
    private static final String JCO_TRACE_LEVEL = "jco.trace_level";
    private static final String JCO_TRACE_PATH = "jco.trace_path";
    public static final String JCO_JARM = "jco.jarm";
    public static final String JCO_JDSR = "jco.jdsr";
    static final String JCO_JDSR_COMP_NAME = "jco.jdsr.comp_name";
    static final String JCO_SESSION_TIMEOUT = "jco.session_timeout";
    static final String JCO_SESSION_TIMEOUT_CHECK_INTERVAL = "jco.session_timeout.check_interval";
    static final String JCO_JDSR_PROVIDER = "jco.jdsr_provider";
    static final String JCO_IGNORE_JDSR_PROVIDER_ERROR = "jco.ignore_jdsr_error";
    static final String JCO_AUTHORIZATION_TRACING = "jco.authorization_tracing";
    static final String JCO_CPIC_MAX_CONV = "jco.cpic_maxconv";
    static final String JCO_CPIC_KEEP_ALIVE_PERIOD = "jco.cpic_keep_alive_period";
    static final String JCO_CPIC_KEEP_ALIVE_TIMEOUT = "jco.cpic_keep_alive_timeout";
    static final String JRFC_TRACE = "jrfc.trace";
    static final String CPIC_TRACE = "cpic.trace";
    static final String JCO_ALLOW_NON_ABAP_PARTNER = "jco.allow_non_abap_partner";
    static final String JCO_DELTA_MANAGEMENT = "jco.delta_management";
    static final String JCO_PROGRAM_NAME = "jco.program_name";
    static final String JCO_USE_REPOSITORY_ROUNDTRIP_OPTIMIZATION = "jco.use_repository_roundtrip_optimization";
    private int jcoMode = 0;
    static final int MONITOR_JARM = 1;
    static final int MONITOR_JDSR = 2;
    static final int MONITOR_JDSR_PROVIDER = 4;
    static final int MONITOR_ON = 7;
    static final int JCO_IGNORE_JDSR_ERROR = 16;
    protected static Properties properties = new Properties();
    public static final String CRLF = System.getProperty("line.separator");
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final String[] EMPTY_STR_ARRAY = new String[0];
    public static final Serializable[] EMPTY_SER_ARRAY = new Serializable[0];
    public static final String EMPTY_STRING = "";
    public static final byte[] DECF16_ZERO = JCoRuntime.createZeroDecFloat(DecFloatType.DECFLOAT16_BE);
    public static final byte[] DECF34_ZERO = JCoRuntime.createZeroDecFloat(DecFloatType.DECFLOAT34_BE);
    static final String VERSION = "3.0.11 (2014-04-15)";
    private static boolean isNonAbapPartnerAllowed = false;
    static boolean authorizationTracingEnabled = true;
    static boolean nativeLibraryLoadFailure = false;
    static String nativeLibraryPath;
    static String nativeLibraryVersionInfo;
    static ThreadGroup jcoThreadGroup;
    SessionReferenceProvider sessionRefProvider = null;
    JCoMiddleware middlewareInstance = null;
    RepositoryManager repositoryManager = new RepositoryManager();

    JCoRuntime() {
    }

    public static boolean isNonAbapPartnerAllowed() {
        return isNonAbapPartnerAllowed;
    }

    protected abstract void initialize();

    @Override
    protected abstract DefaultDestinationManager getDestinationManager();

    protected JCoMiddleware getMiddlewareInstance() {
        return this.middlewareInstance;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    static String getRuntimeVersion() {
        return VERSION;
    }

    protected void readSystemProperties() {
        block2: {
            try {
                this.setSystemProperty(JCO_TRACE_PATH, null);
                this.setSystemProperty(JCO_TRACE_LEVEL, null);
                this.setSystemProperty(JCO_JARM, "0");
                this.setSystemProperty(JCO_JDSR, "0");
                this.setSystemProperty(JCO_JDSR_PROVIDER, "0");
                this.setSystemProperty(JCO_IGNORE_JDSR_PROVIDER_ERROR, "1");
                this.setSystemProperty(CPIC_TRACE, null);
                this.setSystemProperty(JRFC_TRACE, null);
                this.setSystemProperty(JCO_CPIC_KEEP_ALIVE_TIMEOUT, "10");
                this.setSystemProperty(JCO_CPIC_KEEP_ALIVE_PERIOD, "300");
                this.setSystemProperty(JCO_SESSION_TIMEOUT, null);
                this.setSystemProperty(JCO_SESSION_TIMEOUT_CHECK_INTERVAL, null);
                this.setSystemProperty(JCO_DELTA_MANAGEMENT, "1");
                this.setSystemProperty(JCO_USE_REPOSITORY_ROUNDTRIP_OPTIMIZATION, "0");
            }
            catch (RuntimeException ex) {
                if (nativeLibraryLoadFailure) break block2;
                Trace.fireTraceCritical("[JCoAPI] Exception while reading system properties:", ex);
            }
        }
    }

    void setSystemProperty(String key, String defValue) {
        block5: {
            String propertyValue = null;
            try {
                propertyValue = System.getProperty(key, defValue);
                if (propertyValue != null) {
                    if (!this.processInternalProperty(key, propertyValue) && !this.processPublicProperty(key, propertyValue)) {
                        Trace.fireTraceCritical("[JCoAPI] Encountered unknown system property: " + key + "=" + propertyValue);
                    }
                    properties.setProperty(key, propertyValue);
                }
            }
            catch (Throwable t) {
                if (!Trace.isOn(2, true)) {
                    this.setRuntimeTrace(1, ".");
                }
                if (nativeLibraryLoadFailure) break block5;
                Trace.fireTraceCritical("[JCoAPI] Exception while setting system property to JCo property: " + key + "=" + propertyValue, t);
            }
        }
    }

    private boolean processInternalProperty(String key, String value) {
        boolean isInternalProperty = true;
        if (JCO_ALLOW_NON_ABAP_PARTNER.equals(key)) {
            int valueInt = 0;
            try {
                valueInt = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.allow_non_abap_partner is not an integer", ex);
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.allow_non_abap_partner causes " + ex.getMessage(), ex);
            }
            if (valueInt != 0 && valueInt != 1) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Allowed values for property jco.allow_non_abap_partner are 0 or 1 only");
            }
            isNonAbapPartnerAllowed = valueInt == 1;
        } else if (JCO_PROGRAM_NAME.equals(key)) {
            if (value == null || value.length() == 0) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.program_name is null or an empty string");
            }
            AbSysInfo.programName = value;
        } else {
            isInternalProperty = false;
        }
        return isInternalProperty;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processPublicProperty(String key, String value) {
        boolean isPropertyDefined = true;
        if (JCO_TRACE_LEVEL.equals(key)) {
            try {
                String path = properties.getProperty(JCO_TRACE_PATH);
                this.setRuntimeTrace(Integer.parseInt(value), path);
                return isPropertyDefined;
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.trace_level is not an integer", ex);
            }
        }
        if (JCO_TRACE_PATH.equals(key)) {
            try {
                String traceLevel = properties.getProperty(JCO_TRACE_LEVEL);
                if (traceLevel == null) return isPropertyDefined;
                int traceLevelInt = Integer.parseInt(traceLevel);
                this.setRuntimeTrace(traceLevelInt, value);
                return isPropertyDefined;
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.trace_path is not a valid path", ex);
            }
        }
        if (JCO_JARM.equals(key)) {
            if (!"0".equals(value)) {
                if (!"1".equals(value)) throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Allowed values for property " + JCO_JARM + " are 0 or 1 only");
            }
            if (properties.getProperty(JCO_JARM, "0").equals(value)) return isPropertyDefined;
            Jarm.setState(value);
            this.setMiddlewarePropertyValue("jco.middleware.monitoring", value);
            this.jcoMode = "0".equals(value) ? (this.jcoMode &= 0xFFFFFFFE) : (this.jcoMode |= 1);
            return isPropertyDefined;
        }
        if (JCO_JDSR.equals(key)) {
            if (!"0".equals(value)) {
                if (!"1".equals(value)) throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Allowed values for property " + JCO_JDSR + " are 0 or 1 only");
            }
            if (properties.getProperty(JCO_JDSR, "0").equals(value)) return isPropertyDefined;
            Dsr.setState(value);
            this.setMiddlewarePropertyValue("jco.middleware.monitoring", value);
            this.jcoMode = "0".equals(value) ? (this.jcoMode &= 0xFFFFFFFD) : (this.jcoMode |= 2);
            return isPropertyDefined;
        }
        if (JCO_JDSR_COMP_NAME.equals(key)) {
            Dsr.setDsrComponentName(value);
            return isPropertyDefined;
        }
        if (JCO_JDSR_PROVIDER.equals(key)) {
            if (value == null || value.equals("0")) {
                if (!properties.getProperty(JCO_JDSR_PROVIDER, "0").equals("1")) return isPropertyDefined;
                this.jcoMode &= 0xFFFFFFFB;
                this.setMiddlewarePropertyValue("jco.middleware.monitoring", "0");
                return isPropertyDefined;
            } else {
                if (!value.equals("1")) return isPropertyDefined;
                if (!properties.getProperty(JCO_JDSR_PROVIDER, "0").equals("0")) return isPropertyDefined;
                this.jcoMode |= 4;
                this.setMiddlewarePropertyValue("jco.middleware.monitoring", "1");
            }
            return isPropertyDefined;
        }
        if (JCO_IGNORE_JDSR_PROVIDER_ERROR.equals(key)) {
            if (value == null || value.equals("0")) {
                if (!properties.getProperty(JCO_IGNORE_JDSR_PROVIDER_ERROR, "0").equals("1")) return isPropertyDefined;
                this.jcoMode &= 0xFFFFFFEF;
                return isPropertyDefined;
            } else {
                if (!value.equals("1")) return isPropertyDefined;
                if (!properties.getProperty(JCO_JDSR_PROVIDER, "0").equals("0")) return isPropertyDefined;
                this.jcoMode |= 0x10;
            }
            return isPropertyDefined;
        }
        if (JCO_SESSION_TIMEOUT.equals(key)) {
            try {
                long valueLong = this.parseTimeValue(value, 60000);
                if (valueLong < 0L) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "A value less than zero for property jco.session_timeout is not allowed");
                }
                SessionTimeoutChecker.setTimeout(valueLong);
                return isPropertyDefined;
            }
            catch (JCoRuntimeException jre) {
                throw jre;
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.session_timeout is not a valid value", ex);
            }
        }
        if (JCO_SESSION_TIMEOUT_CHECK_INTERVAL.equals(key)) {
            try {
                long valueLong = this.parseTimeValue(value, 60000);
                if (valueLong <= 0L) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "A value less than or equal to zero for property jco.session_timeout.check_interval is not allowed");
                }
                SessionTimeoutChecker.setTimeoutCheckInterval(valueLong);
                return isPropertyDefined;
            }
            catch (JCoRuntimeException jre) {
                throw jre;
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.session_timeout is not a valid value", ex);
            }
        }
        if (CPIC_TRACE.equals(key)) {
            try {
                int cpicTraceInt = Integer.parseInt(value);
                if (cpicTraceInt < 0) return isPropertyDefined;
                SimpleDateFormat fName = new SimpleDateFormat("'CPIC'yyMMdd'_'HHmmssSSS'.trc'");
                JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().setCpicTrace(cpicTraceInt, fName.format(new Date()));
                return isPropertyDefined;
            }
            catch (NumberFormatException ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property cpic.trace is not an integer", ex);
            }
        }
        if (JCO_CPIC_MAX_CONV.equals(key)) {
            try {
                int valueInt = Integer.parseInt(value);
                if (valueInt <= 0) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "A value less than or equal to zero for property  jco.cpic_maxconv is not allowed");
                }
                JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().setCpicMaxConv(valueInt);
                return isPropertyDefined;
            }
            catch (JCoRuntimeException jre) {
                throw jre;
            }
            catch (NumberFormatException ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.cpic_maxconv is not an integer", ex);
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.cpic_maxconv causes " + ex.getMessage(), ex);
            }
        }
        if (JCO_CPIC_KEEP_ALIVE_PERIOD.equals(key)) {
            try {
                int valueInt = Integer.parseInt(value);
                if (valueInt < 0) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.cpic_keep_alive_period less 0 is not allowed");
                }
                int keepAliveTimeout = 0;
                try {
                    keepAliveTimeout = Integer.parseInt(properties.getProperty(JCO_CPIC_KEEP_ALIVE_TIMEOUT));
                }
                catch (Exception e) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.cpic_keep_alive_timeout causes " + e.getMessage(), e);
                }
                JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().setupRegKeepAlive(valueInt > 0, false, valueInt, keepAliveTimeout);
                return isPropertyDefined;
            }
            catch (JCoRuntimeException jre) {
                throw jre;
            }
            catch (NumberFormatException ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.cpic_keep_alive_period is not an integer", ex);
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.cpic_keep_alive_period causes " + ex.getMessage(), ex);
            }
        }
        if (JCO_CPIC_KEEP_ALIVE_TIMEOUT.equals(key)) {
            try {
                int valueInt = Integer.parseInt(value);
                if (valueInt <= 0) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "A value less than or equal to zero for property jco.cpic_keep_alive_timeout is not allowed");
                }
                String keepAlivePeriod = properties.getProperty(JCO_CPIC_KEEP_ALIVE_PERIOD);
                if (keepAlivePeriod == null) return isPropertyDefined;
                int keepAlivePeriodInt = Integer.parseInt(keepAlivePeriod);
                JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().setupRegKeepAlive(keepAlivePeriodInt > 0, true, keepAlivePeriodInt, valueInt);
                return isPropertyDefined;
            }
            catch (JCoRuntimeException jre) {
                throw jre;
            }
            catch (NumberFormatException ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.cpic_keep_alive_timeout is not an integer", ex);
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.cpic_keep_alive_timeout causes " + ex.getMessage(), ex);
            }
        }
        if (JRFC_TRACE.equals(key)) {
            try {
                int jrfcTraceInt = Integer.parseInt(value);
                if (jrfcTraceInt < 0) return isPropertyDefined;
                JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().setRfcTrace(jrfcTraceInt > 0);
                return isPropertyDefined;
            }
            catch (NumberFormatException ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jrfc.trace not an integer", ex);
            }
        }
        if (JCO_DELTA_MANAGEMENT.equals(key)) {
            this.setMiddlewarePropertyValue(key, value);
            return isPropertyDefined;
        }
        if (!JCO_USE_REPOSITORY_ROUNDTRIP_OPTIMIZATION.equals(key)) return false;
        int iv = 0;
        try {
            iv = Integer.parseInt(value);
        }
        catch (Exception ex) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.use_repository_roundtrip_optimization is not an integer", ex);
        }
        if (iv == 0) return isPropertyDefined;
        if (iv == 1) return isPropertyDefined;
        throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Allowed value for property jco.use_repository_roundtrip_optimization are 0 or 1 only");
    }

    @Override
    protected void setPropertyValue(String key, String value) {
        this.processPublicProperty(key, value);
        properties.setProperty(key, value);
    }

    SessionReferenceProvider getSessionReferenceProvider() {
        return this.sessionRefProvider;
    }

    private static byte[] createZeroDecFloat(DecFloatType type) {
        int len = 0;
        if (type == DecFloatType.DECFLOAT16_BE || type == DecFloatType.DECFLOAT16_LE) {
            len = 8;
        } else if (type == DecFloatType.DECFLOAT34_BE || type == DecFloatType.DECFLOAT34_LE) {
            len = 16;
        }
        byte[] result = new byte[len];
        DecFloat.fromString(type, "0.0", result, 0, result.length);
        return result;
    }

    protected abstract Context getRuntimeContext(String var1);

    protected abstract Context getRuntimeContext(String var1, boolean var2);

    protected abstract void releaseRuntimeContext(Context var1);

    @Override
    protected void beginSequence(JCoDestination destination) {
        InternalDestination internalDestination;
        String scopeType;
        if (destination != null) {
            char destType;
            if (!(destination instanceof InternalDestination)) {
                throw new IllegalArgumentException(destination.getClass().getName() + " is not allowed. Use the JCoDestinationManager to obtain a destination instance");
            }
            if (!(Environment.inDW() || (destType = destination.getType()) != 'R' && destType != 'E')) {
                throw new JCoRuntimeException(136, "Stateful communication to external destinations is not supported");
            }
        }
        String string = scopeType = (internalDestination = (InternalDestination)destination) == null ? null : internalDestination.getScopeType();
        if (Trace.isOn(64)) {
            JCoSessionReference sessionReference = this.sessionRefProvider.getCurrentSessionReference(scopeType);
            Trace.fireTrace(64, new StringBuilder(150).append("[JCoAPI] JCoContext.begin(").append(internalDestination != null ? internalDestination.getDestinationID() : EMPTY_STRING).append(scopeType != null ? ") for scope " + scopeType : ")").append(sessionReference != null ? " in session ID " + sessionReference.getID() : " in invalid session").toString());
        }
        this.getRuntimeContext(scopeType).beginSequence(internalDestination);
    }

    @Override
    protected void endSequence(JCoDestination destination) throws JCoException {
        String scopeType;
        InternalDestination internalDestination;
        if (destination == null || destination instanceof InternalDestination) {
            internalDestination = (InternalDestination)destination;
            String string = scopeType = internalDestination == null ? null : internalDestination.getScopeType();
            if (Trace.isOn(64)) {
                JCoSessionReference sessionReference = this.sessionRefProvider.getCurrentSessionReference(scopeType);
                Trace.fireTrace(64, new StringBuilder(150).append("[JCoAPI] JCoContext.end(").append(internalDestination != null ? internalDestination.getDestinationID() : EMPTY_STRING).append(scopeType != null ? ") for scope " + scopeType : ")").append(sessionReference != null ? " in session ID " + sessionReference.getID() : " in invalid session").toString());
            }
        } else {
            throw new IllegalArgumentException(destination.getClass().getName() + " is not allowed. Use the JCoDestinationManager to obtain a destination instance.");
        }
        this.getRuntimeContext(scopeType).endSequence(internalDestination);
    }

    @Override
    protected boolean isStateful(JCoDestination destination) {
        if (destination == null || destination instanceof InternalDestination) {
            InternalDestination internalDestination = (InternalDestination)destination;
            String scopeType = internalDestination == null ? null : internalDestination.getScopeType();
            boolean isStateful = this.getRuntimeContext(scopeType).isInTx(internalDestination);
            if (Trace.isOn(64)) {
                JCoSessionReference sessionReference = this.sessionRefProvider.getCurrentSessionReference(scopeType);
                Trace.fireTrace(64, new StringBuilder(170).append("[JCoAPI] JCoContext.isStateful(").append(internalDestination != null ? internalDestination.getDestinationID() : EMPTY_STRING).append(scopeType != null ? ") for scope " + scopeType : ")").append(sessionReference != null ? " in session ID " + sessionReference.getID() : " in invalid session").append(" returns ").append(isStateful).toString());
            }
            return isStateful;
        }
        throw new IllegalArgumentException(destination.getClass().getName() + " is not allowed. Use the JCoDestinationManager to obtain a destination instance.");
    }

    int getInternalMode() {
        return this.jcoMode;
    }

    protected abstract <V extends Serializable> SharedStorage<String, V> createSharedStorage(String var1);

    protected abstract <V extends Serializable> boolean removeSharedStorage(SharedStorage<String, V> var1);

    protected MetaDataStorage createMetaDataStorage(BasicRepository repository, String name, boolean localCache) {
        return new MetaDataStorage(repository, name, localCache);
    }

    abstract boolean startAutoJob(AutoJobRunner.AutoJob var1);

    protected abstract ConnectionManager createConnectionManager();

    protected abstract void updateDestinationDataProvider(DestinationDataProvider var1);

    protected abstract void updateServerDataProvider(ServerDataProvider var1);

    abstract void updateSessionRefProvider(SessionReferenceProvider var1);

    public abstract void startTask(String var1);

    public abstract void endTask();

    public boolean isTaskMonitorOn() {
        return false;
    }

    @Override
    protected void addTraceListener(JCoTraceListener listener) {
        Trace.addTracelistener(listener);
    }

    @Override
    protected void removeTraceListener(JCoTraceListener listener) {
        Trace.removeTraceListener(listener);
    }

    @Override
    protected void setRuntimeTrace(int level, String path) {
        Trace.setJCoTrace(level);
        properties.setProperty(JCO_TRACE_LEVEL, String.valueOf(level));
        if (level == 0) {
            path = null;
        }
        if (path != null) {
            properties.setProperty(JCO_TRACE_PATH, path);
        } else {
            properties.remove(JCO_TRACE_PATH);
        }
    }

    @Override
    protected int getTraceLevel() {
        return Trace.toExternalTraceLevel(Trace.internalLogLevel);
    }

    @Override
    protected String getTracePath() {
        return properties.getProperty(JCO_TRACE_PATH);
    }

    public static String findProperty(String key, Properties props) {
        String value = null;
        Object objValue = props.get(key);
        if (objValue == null && (objValue = props.get(key = key.substring(key.lastIndexOf(46) + 1))) == null) {
            key = key.toUpperCase(Locale.ENGLISH);
            objValue = props.get(key);
        }
        if (objValue != null) {
            value = objValue.toString().trim();
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
                value = "1";
            } else if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no")) {
                value = "0";
            }
        }
        return value != null && value.length() > 0 ? value : null;
    }

    public static void removeProperty(String key, Properties props) {
        if (props.containsKey(key)) {
            props.remove(key);
        } else if (props.containsKey(key = key.substring(key.lastIndexOf(46) + 1))) {
            props.remove(key);
        } else if (props.containsKey(key = key.toUpperCase(Locale.ENGLISH))) {
            props.remove(key);
        }
    }

    public static boolean toBoolean(String arg) {
        if (arg == null) {
            return false;
        }
        return (arg = arg.trim().toLowerCase(Locale.ENGLISH)).equals("1") || arg.equals("true") || arg.equals("yes");
    }

    @Override
    protected JCoCustomRepository createCustomRepository(String name) {
        return new CustomRepository(name);
    }

    @Override
    protected JCoStructure createStructure(JCoRecordMetaData metaData) {
        return new DefaultStructure(metaData);
    }

    @Override
    protected JCoStructure createStructure(JCoTable table, int row) {
        int pos = table.getRow();
        DefaultStructure s = new DefaultStructure(table.getRecordMetaData());
        table.setRow(row);
        s.copyFrom(table);
        table.setRow(pos);
        return s;
    }

    @Override
    protected JCoTable createTable(JCoRecordMetaData metaData) {
        return new DefaultTable(metaData);
    }

    @Override
    protected JCoAbapObject constructAbapObject(JCoClassMetaData classMetaData, Map<String, Object> initialValues) {
        DefaultAbapObject newInstance = new DefaultAbapObject(classMetaData);
        for (String attributeName : initialValues.keySet()) {
            if (!classMetaData.hasField(attributeName)) continue;
            newInstance.setValue(attributeName, initialValues.get(attributeName));
        }
        newInstance.setInitialized();
        return newInstance;
    }

    @Override
    protected JCoListMetaData createListMetaData(JCoListMetaData metaData) {
        return new DefaultListMetaData(metaData);
    }

    @Override
    protected JCoListMetaData createListMetaData(String name, int capacity) {
        return new DefaultListMetaData(name, capacity);
    }

    @Override
    protected JCoListMetaData createListMetaData(String name) {
        return new DefaultListMetaData(name);
    }

    @Override
    protected JCoRecordMetaData createRecordMetaData(JCoRecordMetaData metaData) {
        return new DefaultRecordMetaData(metaData);
    }

    @Override
    protected JCoRecordMetaData createRecordMetaData(String name) {
        return new DefaultRecordMetaData(name);
    }

    @Override
    protected JCoRecordMetaData createRecordMetaData(String name, int capacity) {
        return new DefaultRecordMetaData(name, capacity);
    }

    @Override
    protected DefaultClassMetaData createClassMetaData(JCoClassMetaData metaData) {
        return new DefaultClassMetaData(metaData);
    }

    @Override
    protected DefaultClassMetaData createClassMetaData(String name, String[] parentClasses, String[] implementedInterfaces, int capacity) {
        return new DefaultClassMetaData(name, parentClasses, implementedInterfaces, capacity);
    }

    protected JCoFunctionTemplate createFunctionTemplate(String name, JCoListMetaData imports, JCoListMetaData exports, JCoListMetaData changing, JCoListMetaData tables, AbapExceptionModel[] exceptions, boolean supportsASXML) {
        boolean isLocked;
        boolean bl = isLocked = !(imports != null && !imports.isLocked() || changing != null && !changing.isLocked() || exports != null && !exports.isLocked() || tables != null && !tables.isLocked());
        if (isLocked) {
            return new AbapFunctionTemplate(name, imports, exports, changing, tables, exceptions, supportsASXML);
        }
        throw new IllegalArgumentException("The metaData for the parameter list(s) is not locked. Only locked instances are allowed. Use the JCoMetaData.lock() API.");
    }

    @Override
    protected JCoFunctionTemplate createFunctionTemplate(String name, JCoListMetaData imports, JCoListMetaData exports, JCoListMetaData changing, JCoListMetaData tables, AbapException[] exceptions, boolean supportsASXML) {
        boolean isLocked;
        AbapExceptionModel[] exceptionList = null;
        if (exceptions != null) {
            exceptionList = new AbapExceptionModel[exceptions.length];
            for (int i = 0; i < exceptions.length; ++i) {
                exceptionList[i] = new AbapExceptionModel(exceptions[i].getKey(), exceptions[i].getMessage());
            }
        }
        boolean bl = isLocked = !(imports != null && !imports.isLocked() || changing != null && !changing.isLocked() || exports != null && !exports.isLocked() || tables != null && !tables.isLocked());
        if (isLocked) {
            return new AbapFunctionTemplate(name, imports, exports, changing, tables, exceptionList, supportsASXML);
        }
        throw new IllegalArgumentException("The metaData for the parameter list(s) is not locked. Only locked instances are allowed. Use the JCoMetaData.lock() API.");
    }

    @Override
    protected JCoFunctionUnit createFunctionUnit(String unitID, JCoBackgroundUnitAttributes unitAttributes) {
        AbapFunctionUnit unit = new AbapFunctionUnit(unitAttributes);
        unit.setID(Codecs.Hex.decode(unitID));
        return unit;
    }

    @Override
    protected JCoFunctionUnit createFunctionUnit(JCoBackgroundUnitAttributes unitAttributes) {
        AbapFunctionUnit unit = new AbapFunctionUnit(unitAttributes);
        byte[] bID = this.getRfcRuntimeInstance().createUUID();
        unit.setID(bID);
        return unit;
    }

    @Override
    protected JCoRequestUnit createRequestUnit(String unitID, JCoBackgroundUnitAttributes unitAttributes) {
        AbapRequestUnit unit = new AbapRequestUnit(unitAttributes);
        unit.setID(Codecs.Hex.decode(unitID));
        return unit;
    }

    @Override
    protected JCoRequestUnit createRequestUnit(JCoBackgroundUnitAttributes unitAttributes) {
        AbapRequestUnit unit = new AbapRequestUnit(unitAttributes);
        byte[] bID = this.getRfcRuntimeInstance().createUUID();
        unit.setID(bID);
        return unit;
    }

    @Override
    protected JCoBackgroundUnitAttributes createBackgroundUnitAttributes() {
        return new AbapBackgroundUnitAttributes();
    }

    @Override
    protected JCoUnitIdentifier createUnitIdentifier(String unitID, JCoUnitIdentifier.Type unitType) {
        if (unitType == null) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Unit type equal to null is not allowed in createUnitIdentifier");
        }
        byte[] unitIdBytes = Codecs.Hex.decode(unitID);
        if (unitIdBytes.length != 16) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Unit ID is not allowed. Only unit IDs with 16 bytes are supported. [" + unitID + "]");
        }
        AbapFunctionUnit.UnitIdentifier unitIdentifier = new AbapFunctionUnit.UnitIdentifier();
        unitIdentifier.update(unitIdBytes, unitType);
        return unitIdentifier;
    }

    @Override
    protected JCoThroughput createThroughput() {
        return new DefaultThroughput();
    }

    @Override
    protected String getMiddlewarePropertyValue(String key) {
        return this.getMiddlewareInstance().getProperty(key);
    }

    @Override
    protected void setMiddlewarePropertyValue(String key, String value) {
        this.getMiddlewareInstance().setProperty(key, value);
    }

    @Override
    protected String getPropertyValue(String key) {
        return properties.getProperty(key);
    }

    protected long parseTimeValue(String timeValue, int defaultMillisFactor) throws NumberFormatException {
        int tokenIndex;
        if (timeValue != null && (tokenIndex = timeValue.length() - 1) >= 0 && !Character.isDigit(timeValue.charAt(tokenIndex))) {
            String unit;
            while (--tokenIndex >= 0 && !Character.isDigit(timeValue.charAt(tokenIndex))) {
            }
            if (tokenIndex >= 0 && (unit = timeValue.substring(++tokenIndex).trim()).length() > 0) {
                int millisFactor = 0;
                switch (unit.charAt(0)) {
                    case 's': {
                        if (unit.length() != 1 && !unit.equals("sec") && !unit.equals("seconds") && !unit.equals("second")) break;
                        millisFactor = 1000;
                        break;
                    }
                    case 'm': {
                        if (unit.length() == 1) {
                            millisFactor = 60000;
                            break;
                        }
                        if (unit.equals("ms") || unit.equals("msec") || unit.equals("milliseconds") || unit.equals("millisecond")) {
                            millisFactor = 1;
                            break;
                        }
                        if (!unit.equals("min") && !unit.equals("minutes") && !unit.equals("minute")) break;
                        millisFactor = 60000;
                        break;
                    }
                    case 'h': {
                        if (unit.length() != 1 && !unit.equals("hr") && !unit.equals("hrs") && !unit.equals("hours") && !unit.equals("hour")) break;
                        millisFactor = 3600000;
                        break;
                    }
                }
                if (millisFactor > 0) {
                    timeValue = timeValue.substring(0, tokenIndex);
                    return Long.parseLong(timeValue) * (long)millisFactor;
                }
            }
        }
        return Long.parseLong(timeValue) * (long)defaultMillisFactor;
    }

    protected abstract String getRuntimeParameter(String var1);

    public static String getProfileParameter(String parameter) {
        return JCoRuntimeFactory.getRuntime().getRuntimeParameter(parameter);
    }

    protected abstract boolean registerNativeMethods(Class<?> var1);

    public static boolean registerNatives(Class<?> clazz) {
        return JCoRuntimeFactory.getRuntime().registerNativeMethods(clazz);
    }

    public abstract RfcRuntime getRfcRuntimeInstance();

    protected abstract AbstractServerManager getJCoServerFactoryInstance();

    public static AbstractServerManager getJCoServerManager() {
        return JCoRuntimeFactory.getRuntime().getJCoServerFactoryInstance();
    }

    protected static boolean checkAccess(Set<String> friendlyClasses, String className) {
        boolean isAllowed = false;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (int i = 0; i < stack.length - 1; ++i) {
            if (!stack[i].getClassName().equals(className) || !friendlyClasses.contains(stack[i + 1].getClassName())) continue;
            isAllowed = true;
            break;
        }
        if (!isAllowed) {
            String junitInternalRunner = "org.junit.internal.runners.TestClassRunner";
            String junitRunner = "org.junit.runner.JUnitCore";
            for (int i = 0; i < stack.length; ++i) {
                if (!stack[i].getClassName().equals(junitRunner) && !stack[i].getClassName().equals(junitInternalRunner)) continue;
                isAllowed = true;
                break;
            }
        }
        return isAllowed;
    }

    static void setRuntimeInterface(JCoInterface runtimeInterface) {
        JCoInterface.setRuntime(runtimeInterface);
    }

    @Override
    protected List<String> getDestinationIDs() {
        return this.getDestinationManager().getDestinationIDs();
    }

    @Override
    protected List<String> getCustomDestinationIDs(String destinationID) {
        return this.getDestinationManager().getCustomDestinationIDs(destinationID);
    }

    @Override
    protected String getRepositoryDestinationID(String destinationID) {
        return this.getDestinationManager().getRepositoryDestinationID(destinationID);
    }

    @Override
    protected JCoDestinationMonitor getDestinationMonitor(String destinationID) {
        return this.getDestinationManager().getDestinationMonitor(destinationID);
    }

    @Override
    protected JCoDestinationMonitor getRepositoryDestinationMonitor(String destinationID) {
        return this.getDestinationManager().getRepositoryDestinationMonitor(destinationID);
    }

    @Override
    protected JCoRepository getRepository(String repositoryID) {
        return this.repositoryManager.getRepository(repositoryID);
    }

    @Override
    protected List<String> getRepositoryIDs() {
        return this.repositoryManager.getRepositoryIDs();
    }

    @Override
    protected abstract ConnectionMonitor getConnectionMonitor();

    protected RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    @Override
    protected JCoRepositoryQueryResult queryMetaDataSet(JCoRepository repository, List<String> functions, List<String> types, List<String> classes) throws JCoException {
        if (repository instanceof AbapRepository) {
            return ((AbapRepository)repository).lookupMetadata(functions, types, classes);
        }
        throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only Repositories created by JCo runtime are allowed in lookupMetadata. Encountered instance is " + repository.getClass().getName());
    }

    static {
        jcoThreadGroup = new ThreadGroup("JCoThreads");
    }
}

