/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoRecordFieldIterator;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.DefaultRecordFieldIterator;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.rt.JCoRuntime;
import java.util.Arrays;

public class DefaultTable
extends AbstractRecord
implements JCoTable {
    static final long serialVersionUID = 3000120080918L;
    protected static final byte OP_NOOP = 0;
    protected static final byte OP_APPEND = 1;
    protected static final byte OP_INSERT = 2;
    protected static final byte OP_DELETE = 3;
    protected static final byte OP_UPDATE = 4;
    protected static final byte OP_CLEAR = 5;
    protected static final int OP_SHIFT = 29;
    protected static final int OP_OPCODE_MASK = -536870912;
    protected static final int OP_VALUE_MASK = 0x1FFFFFFF;
    private int row_capacity_increment = 0;
    private int row_capacity = 0;
    private int num_init_rows = 0;
    private char[] template_data = null;
    private Object[] template_odata = null;

    protected DefaultTable(JCoRecordMetaData metaData) {
        super(4, metaData);
    }

    protected DefaultTable(DefaultStructure value) {
        this(value.getRecordMetaData());
        this.appendRow();
        this.copyRaw(value);
    }

    @Override
    public DefaultRecordMetaData getRecordMetaData() {
        return (DefaultRecordMetaData)this.metaData;
    }

    protected void copyContent(DefaultTable src) {
        this.row_capacity_increment = src.row_capacity_increment;
        super.copyContent(src);
        this.row_capacity = src.row_capacity;
        this.num_init_rows = src.numRows;
        if (src.template_data != null) {
            char[] cArray = this.template_data = src.rowLength > 0 ? (char[])src.template_data.clone() : JCoRuntime.EMPTY_CHAR_ARRAY;
        }
        if (src.template_odata != null) {
            this.template_odata = src.metaData.numOdata > 0 ? (Object[])src.template_odata.clone() : JCoRuntime.EMPTY_OBJ_ARRAY;
        }
    }

    protected static void copyRaw(DefaultStructure src, DefaultTable dest) {
        dest.copyRaw(src);
    }

    protected static void copyRaw(DefaultTable src, int srcrow, DefaultTable dest, int destrow) {
        if (srcrow < 0 || srcrow > src.numRows || destrow < 0 || destrow > dest.numRows) {
            throw new IllegalArgumentException("Illegal row number in source or destination table.");
        }
        int save_destrow = dest.row;
        dest.row = destrow;
        dest.copyRaw(src, srcrow);
        dest.row = save_destrow;
    }

    protected void copyRaw(DefaultStructure src) {
        this.copyRaw(src, 0);
    }

    private void copyRaw(AbstractRecord src, int srcrow) {
        int ioffset = this.metaData.boffset[0];
        int src_ioffset = src.metaData.boffset[0];
        if (src.rowLength > 0) {
            System.arraycopy(src.recType == 4 ? src.tableDataRows[srcrow] : src.data, src_ioffset, this.recType == 4 ? this.tableDataRows[this.row] : this.data, ioffset, this.rowLength);
        }
        if (src.metaData.numOdata > 0) {
            int src_offset = src.row * src.metaData.numOdata;
            for (int i = 0; i < src.metaData.numOdata; ++i) {
                Object o = src.odata[i + src_offset];
                if (o != null) {
                    if (o instanceof JCoRecord) {
                        o = ((AbstractRecord)o).clone();
                    } else if (o instanceof byte[]) {
                        o = ((byte[])o).clone();
                    }
                }
                this.odata[this.row * this.metaData.numOdata + i] = o;
            }
        }
        this.setModified(this.row);
    }

    @Override
    public void ensureBufferCapacity(int required_rows) {
        if (required_rows <= 0) {
            return;
        }
        if (this.num_init_rows >= required_rows) {
            return;
        }
        int old_row_capacity = this.row_capacity;
        if (this.row_capacity < required_rows) {
            if (this.row_capacity == 0) {
                this.row_capacity = Math.max(required_rows, 2);
            } else {
                this.row_capacity = this.row_capacity_increment <= 0 ? (int)((double)this.row_capacity * 1.2 + 10.0) : this.row_capacity_increment + this.row_capacity + 1;
                this.row_capacity = Math.max(required_rows, this.row_capacity);
            }
            Object[] old_odata = this.odata;
            char[][] old_tableDataRows = this.tableDataRows;
            byte[] old_opcode = this.opcode;
            if (this.metaData.numFields > 0) {
                this.rowLength = this.metaData.boffset[this.metaData.numFields - 1] + this.metaData.blength[this.metaData.numFields - 1];
            }
            try {
                int capacity = this.row_capacity * this.metaData.numOdata;
                if (this.odata == null || this.odata.length < capacity) {
                    this.odata = new Object[capacity];
                    if (old_odata != null && old_odata.length > 0) {
                        System.arraycopy(old_odata, 0, this.odata, 0, old_odata.length);
                    }
                }
                if (this.rowLength > 0 && (this.tableDataRows == null || this.tableDataRows.length < this.row_capacity)) {
                    this.tableDataRows = new char[this.row_capacity][];
                    if (old_tableDataRows != null && old_tableDataRows.length > 0) {
                        System.arraycopy(old_tableDataRows, 0, this.tableDataRows, 0, old_tableDataRows.length);
                    }
                }
                if (this.opcode == null || this.opcode.length < this.row_capacity) {
                    this.opcode = new byte[this.row_capacity];
                    if (old_opcode != null) {
                        System.arraycopy(old_opcode, 0, this.opcode, 0, old_opcode.length);
                    }
                }
            }
            catch (Error error) {
                if (old_odata != null) {
                    this.odata = old_odata;
                }
                if (old_tableDataRows != null) {
                    this.tableDataRows = old_tableDataRows;
                }
                if (this.opcode == null) {
                    this.opcode = old_opcode;
                }
                this.row_capacity = old_row_capacity;
                throw error;
            }
        }
        for (int irow = this.num_init_rows; irow < required_rows; ++irow) {
            this.initializeRow(irow);
        }
        this.num_init_rows = required_rows;
    }

    @Override
    protected void ensureBufferCapacity() {
        this.ensureBufferCapacity(this.numRows);
        if (this.flags.length < this.metaData.numFields) {
            byte[] newFlags = new byte[this.metaData.numFields];
            if (this.flags.length > 0) {
                System.arraycopy(this.flags, 0, newFlags, 0, this.flags.length);
            }
            this.flags = newFlags;
        }
    }

    @Override
    protected void initializeRow(int irow) {
        block10: {
            block9: {
                if (this.template_data != null) break block9;
                if (this.rowLength > 0) {
                    this.tableDataRows[irow] = new char[this.rowLength];
                }
                super.initializeRow(irow, null);
                char[] cArray = this.template_data = this.rowLength > 0 ? (char[])this.tableDataRows[irow].clone() : JCoRuntime.EMPTY_CHAR_ARRAY;
                if (this.metaData.numOdata <= 0) break block10;
                this.template_odata = new Object[this.metaData.numOdata];
                for (int ifield = 0; ifield < this.metaData.numFields; ++ifield) {
                    Object template;
                    byte itype = this.metaData.type[ifield];
                    int idx = this.metaData.oindex[ifield];
                    if (idx <= -1 || (template = this.odata[irow * this.metaData.numOdata + this.metaData.oindex[ifield]]) == null) continue;
                    if ((itype == 17 || itype == 99) && template instanceof JCoRecord) {
                        this.template_odata[this.metaData.oindex[ifield]] = ((AbstractRecord)template).clone();
                        continue;
                    }
                    if (itype == 30 && template instanceof byte[]) {
                        this.template_odata[this.metaData.oindex[ifield]] = ((byte[])template).clone();
                        continue;
                    }
                    if (itype != 29) continue;
                    this.template_odata[this.metaData.oindex[ifield]] = template;
                }
                break block10;
            }
            if (this.rowLength > 0) {
                this.tableDataRows[irow] = (char[])this.template_data.clone();
            }
            if (this.metaData.numOdata > 0) {
                for (int ifield = 0; ifield < this.metaData.numFields; ++ifield) {
                    Object template;
                    byte itype = this.metaData.type[ifield];
                    int idx = this.metaData.oindex[ifield];
                    if (idx <= -1 || (template = this.template_odata[this.metaData.oindex[ifield]]) == null) continue;
                    if ((itype == 17 || itype == 99) && template instanceof JCoRecord) {
                        this.odata[irow * this.metaData.numOdata + this.metaData.oindex[ifield]] = ((AbstractRecord)template).clone();
                        continue;
                    }
                    if (itype == 30 && template instanceof byte[]) {
                        this.odata[irow * this.metaData.numOdata + this.metaData.oindex[ifield]] = ((byte[])template).clone();
                        continue;
                    }
                    if (itype != 29) continue;
                    this.odata[irow * this.metaData.numOdata + this.metaData.oindex[ifield]] = template;
                }
            }
        }
    }

    @Override
    public void trimToRows() {
        char[][] old_tableDataRows = null;
        Object[] old_odata = null;
        byte[] old_opcode = null;
        int capacity = this.numRows * this.metaData.numOdata;
        if (this.tableDataRows != null && this.tableDataRows.length > this.numRows) {
            old_tableDataRows = this.tableDataRows;
        }
        if (this.odata != null && this.odata.length > capacity) {
            old_odata = this.odata;
        }
        if (this.opcode != null && this.opcode.length > this.numRows) {
            old_opcode = this.opcode;
        }
        try {
            if (old_tableDataRows != null) {
                this.tableDataRows = new char[this.numRows][];
                System.arraycopy(old_tableDataRows, 0, this.tableDataRows, 0, this.numRows);
            }
            if (old_odata != null) {
                this.odata = new Object[capacity];
                System.arraycopy(old_odata, 0, this.odata, 0, capacity);
            }
            if (old_opcode != null) {
                this.opcode = new byte[this.numRows];
                System.arraycopy(old_opcode, 0, this.opcode, 0, this.numRows);
            }
            this.row_capacity = this.numRows;
        }
        catch (Error error) {
            if (old_tableDataRows != null) {
                this.tableDataRows = old_tableDataRows;
            }
            if (old_odata != null) {
                this.odata = old_odata;
            }
            if (old_opcode != null) {
                this.opcode = old_opcode;
            }
            throw error;
        }
    }

    @Override
    protected void setModified(int row) {
        super.setModified(row);
        if (this.opcode[row] == 0) {
            this.opcode[row] = 4;
        }
    }

    protected void appendDelta(byte dmOperation, int opvalue) {
        int old_code;
        byte old_opcode;
        super.setModified(0);
        if (dmOperation == 1 && this.delta != null && this.delta.length > 0 && (old_opcode = (byte)(((old_code = this.delta[this.delta.length - 1]) & 0xE0000000) >> 29)) == 1) {
            this.delta[this.delta.length - 1] = dmOperation << 29 | (opvalue += old_code & 0x1FFFFFFF) & 0x1FFFFFFF;
            return;
        }
        int[] old_delta = this.delta;
        this.delta = new int[(old_delta != null ? old_delta.length : 0) + 1];
        if (old_delta != null) {
            System.arraycopy(old_delta, 0, this.delta, 0, old_delta.length);
        }
        this.delta[this.delta.length - 1] = dmOperation << 29 | opvalue & 0x1FFFFFFF;
    }

    public int copyFrom(AbstractRecord source) {
        int old_numRows = this.numRows;
        int n = super.copyFrom(source);
        this.appendDelta((byte)1, source.numRows);
        for (int i = old_numRows; i < this.numRows; ++i) {
            this.opcode[i] = 1;
        }
        return n;
    }

    @Override
    public final boolean isEmpty() {
        return this.numRows == 0;
    }

    @Override
    public final boolean isFirstRow() {
        return this.numRows > 0 && this.row == 0;
    }

    @Override
    public final boolean isLastRow() {
        return this.numRows > 0 && this.row == this.numRows - 1;
    }

    @Override
    public final int getNumRows() {
        return this.numRows;
    }

    @Override
    public final int getNumColumns() {
        return this.metaData.numFields;
    }

    @Override
    public void clear() {
        if (this.numRows == 0) {
            return;
        }
        if (this.tableDataRows != null) {
            Arrays.fill((Object[])this.tableDataRows, null);
        }
        Arrays.fill(this.odata, null);
        Arrays.fill(this.opcode, (byte)0);
        this.num_init_rows = 0;
        this.numRows = 0;
        this.row = 0;
        this.appendDelta((byte)5, this.numRows);
    }

    @Override
    public void deleteAllRows() {
        this.clear();
    }

    @Override
    public final void firstRow() {
        this.row = 0;
    }

    @Override
    public final void lastRow() {
        this.row = this.numRows <= 0 ? 0 : this.numRows - 1;
    }

    @Override
    public final boolean nextRow() {
        boolean eor;
        boolean bl = eor = ++this.row < this.numRows;
        if (this.row >= this.numRows) {
            this.row = this.numRows - 1;
        }
        return eor;
    }

    @Override
    public final boolean previousRow() {
        boolean bor;
        boolean bl = bor = --this.row >= 0;
        if (this.row < 0) {
            this.row = 0;
        }
        return bor;
    }

    @Override
    public final int getRow() {
        return this.row;
    }

    @Override
    public void setRow(int pos) {
        this.row = pos;
        if (this.row < 0) {
            this.row = 0;
        } else if (this.row >= this.numRows) {
            this.row = this.numRows > 0 ? this.numRows - 1 : 0;
        }
    }

    @Override
    public void appendRow() {
        this.appendRows(1);
    }

    @Override
    public void appendRows(int rowCount) {
        if (rowCount < 1) {
            return;
        }
        int old_numRows = this.numRows;
        this.row = this.numRows;
        this.ensureBufferCapacity(this.numRows + rowCount);
        this.numRows += rowCount;
        for (int irow = this.numRows; irow >= old_numRows; --irow) {
            if (irow >= this.numRows) continue;
            this.opcode[irow] = 1;
        }
        this.appendDelta((byte)1, rowCount);
    }

    @Override
    public void insertRow(int pos) {
        int mode = pos >= this.numRows ? 1 : 2;
        pos = Math.min(Math.max(pos, 0), this.numRows);
        this.ensureBufferCapacity(this.numRows + 1);
        this.row = pos;
        if (pos < this.numRows) {
            char[] initial_row_data = null;
            Object[] initial_row_odata = null;
            if (this.rowLength > 0) {
                initial_row_data = this.tableDataRows[this.numRows];
            }
            if (this.metaData.numOdata > 0) {
                initial_row_odata = new Object[this.metaData.numOdata];
                System.arraycopy(this.odata, this.numRows * this.metaData.numOdata, initial_row_odata, 0, this.metaData.numOdata);
            }
            for (int irow = this.numRows; irow > pos; --irow) {
                if (this.rowLength > 0) {
                    this.tableDataRows[irow] = this.tableDataRows[irow - 1];
                }
                if (this.metaData.numOdata > 0) {
                    System.arraycopy(this.odata, (irow - 1) * this.metaData.numOdata, this.odata, irow * this.metaData.numOdata, this.metaData.numOdata);
                }
                if (irow >= this.numRows) continue;
                this.opcode[irow] = this.opcode[irow - 1];
            }
            if (this.rowLength > 0) {
                this.tableDataRows[pos] = initial_row_data;
            }
            if (this.metaData.numOdata > 0) {
                System.arraycopy(initial_row_odata, 0, this.odata, pos * this.metaData.numOdata, this.metaData.numOdata);
            }
        }
        ++this.numRows;
        if (mode == 1) {
            this.opcode[pos] = 1;
            this.appendDelta((byte)1, 1);
        } else {
            this.opcode[pos] = 2;
            this.appendDelta((byte)2, pos);
        }
    }

    @Override
    public void deleteRow() {
        this.deleteRow(this.row);
    }

    @Override
    public void deleteRow(int pos) {
        int i;
        if (pos < 0 && pos >= this.numRows) {
            return;
        }
        for (i = pos + 1; i < this.num_init_rows; ++i) {
            if (this.rowLength > 0) {
                this.tableDataRows[i - 1] = this.tableDataRows[i];
            }
            if (this.metaData.numOdata > 0) {
                System.arraycopy(this.odata, i * this.metaData.numOdata, this.odata, (i - 1) * this.metaData.numOdata, this.metaData.numOdata);
            }
            this.opcode[i - 1] = this.opcode[i];
        }
        this.appendDelta((byte)3, pos);
        --this.num_init_rows;
        --this.numRows;
        this.row = Math.min(Math.max(this.row, 0), this.numRows - 1);
        if (this.rowLength > 0) {
            this.tableDataRows[this.num_init_rows] = null;
        }
        if (this.metaData.numOdata > 0) {
            for (i = 0; i < this.metaData.numOdata; ++i) {
                this.odata[i + this.num_init_rows * this.metaData.numOdata] = null;
            }
        }
    }

    @Override
    public JCoRecordFieldIterator getRecordFieldIterator() {
        return new DefaultRecordFieldIterator(this);
    }

    @Override
    public boolean isInitialized(int index) {
        return this.modified;
    }
}

