/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoAbapObject;
import com.sap.conn.jco.JCoClassMetaData;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRemoteContext;
import java.util.GregorianCalendar;
import java.util.HashMap;

public class AbapClassException
extends JCoException {
    static final long serialVersionUID = 2008101001L;
    private String className;
    private JCoAbapObject abapObject;
    private JCoRemoteContext remoteContext;
    private String timeStamp;
    private static JCoClassMetaData CX_REMOTE_APPL_ERROR_MD;

    public AbapClassException(String message, String className, JCoAbapObject abapObject, JCoRemoteContext remoteContext) {
        super(111, "ABAP_CLASS_EXCEPTION", message);
        this.className = className;
        this.abapObject = abapObject;
        this.remoteContext = remoteContext;
        this.timeStamp = this.createTimeStamp();
    }

    public AbapClassException(String message, JCoAbapObject abapObject) {
        this(message, abapObject.getMetaData().getName(), abapObject, null);
    }

    public AbapClassException(Exception javaException) {
        super(111, "ABAP_CLASS_EXCEPTION", javaException.getMessage(), javaException);
        this.className = "CX_REMOTE_APPL_ERROR";
        HashMap<String, Object> initialValues = new HashMap<String, Object>();
        initialValues.put("MESSAGE_TEXT", javaException.toString());
        String javaExceptionMessage = javaException.getMessage();
        initialValues.put("ABAP_RUNTIME_ERROR_TEXT", javaExceptionMessage == null ? "null" : javaExceptionMessage);
        this.abapObject = JCo.createAbapObject(CX_REMOTE_APPL_ERROR_MD, initialValues);
        this.timeStamp = this.createTimeStamp();
    }

    public String getClassName() {
        return this.className;
    }

    public JCoAbapObject toAbapObject() {
        return this.abapObject;
    }

    public JCoRemoteContext getRemoteContext() {
        return this.remoteContext;
    }

    public String createCallStack() {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTrace = this.getStackTrace();
        if (stackTrace.length > 0) {
            StackTraceElement ste0 = stackTrace[0];
            sb.append(";W=");
            sb.append(ste0.getClassName());
            sb.append('.');
            sb.append(ste0.getMethodName());
            sb.append(",H=");
            sb.append(stackTrace.length);
            if (!ste0.isNativeMethod()) {
                sb.append(",E=");
                sb.append(ste0.getLineNumber());
            }
            for (StackTraceElement ste : stackTrace) {
                sb.append(";M=");
                sb.append(ste.getClassName());
                sb.append('.');
                sb.append(ste.getMethodName());
                sb.append(",P=");
                sb.append(ste.getFileName());
                if (ste.isNativeMethod()) continue;
                sb.append(':');
                sb.append(ste.getLineNumber());
            }
        } else {
            sb.append(";W=unknown,H=0");
        }
        return sb.toString();
    }

    public String createExceptionInfo() {
        return "TIME_STAMP=" + this.timeStamp + ";";
    }

    private String createTimeStamp() {
        StringBuilder sb = new StringBuilder();
        GregorianCalendar gregCal = new GregorianCalendar();
        sb.append(gregCal.get(1));
        this.ensureDigitCount(sb, gregCal.get(2) + 1, 2);
        this.ensureDigitCount(sb, gregCal.get(5), 2);
        this.ensureDigitCount(sb, gregCal.get(11), 2);
        this.ensureDigitCount(sb, gregCal.get(12), 2);
        this.ensureDigitCount(sb, gregCal.get(13), 2);
        return sb.toString();
    }

    private void ensureDigitCount(StringBuilder buf, int value, int count) {
        int digits = (int)Math.floor(Math.log10(value)) + 1;
        int appendCount = count - digits;
        for (int i = 0; i < appendCount; ++i) {
            buf.append('0');
        }
        buf.append(value);
    }

    static {
        JCoRecordMetaData SCX_T100KEY_MD = JCo.createRecordMetaData("SCX_T100KEY", 6);
        SCX_T100KEY_MD.add("MSGID", 0, 20, 0, 40, 0, 0, "Message Class", null, null);
        SCX_T100KEY_MD.add("MSGNO", 6, 3, 20, 6, 40, 0, "Message Number", null, null);
        SCX_T100KEY_MD.add("ATTR1", 29, 8, 24, 8, 48, 0, "Attribute Name", null, null);
        SCX_T100KEY_MD.add("ATTR2", 29, 8, 32, 8, 56, 0, "Attribute Name", null, null);
        SCX_T100KEY_MD.add("ATTR3", 29, 8, 40, 8, 64, 0, "Attribute Name", null, null);
        SCX_T100KEY_MD.add("ATTR4", 29, 8, 48, 8, 72, 0, "Attribute Name", null, null);
        SCX_T100KEY_MD.setRecordLength(56, 80);
        SCX_T100KEY_MD.lock();
        CX_REMOTE_APPL_ERROR_MD = JCo.createClassMetaData("CX_REMOTE_APPL_ERROR");
        CX_REMOTE_APPL_ERROR_MD.addParentClass("CX_ROOT");
        CX_REMOTE_APPL_ERROR_MD.addParentClass("CX_DYNAMIC_CHECK");
        CX_REMOTE_APPL_ERROR_MD.addParentClass("CX_REMOTE_EXCEPTION");
        CX_REMOTE_APPL_ERROR_MD.addImplementedInterface("IF_MESSAGE");
        CX_REMOTE_APPL_ERROR_MD.addImplementedInterface("IF_SERIALIZABLE_OBJECT");
        CX_REMOTE_APPL_ERROR_MD.addImplementedInterface("IF_T100_MESSAGE");
        CX_REMOTE_APPL_ERROR_MD.add("IF_T100_MESSAGE", "T100KEY", 17, 8, 0, "T100 Key with Parameters Mapped to Attribute Names", SCX_T100KEY_MD, null, JCoClassMetaData.JCoAttributeKind.INSTANCE, false, null);
        CX_REMOTE_APPL_ERROR_MD.add("CX_ROOT", "REMOTE_CONTEXT", 16, 8, 0, "Key for Access to Message Text", null, null, JCoClassMetaData.JCoAttributeKind.INSTANCE, false, null);
        CX_REMOTE_APPL_ERROR_MD.add("CX_ROOT", "TEXTID", 0, 32, 0, "Key for Access to Message Text", null, null, JCoClassMetaData.JCoAttributeKind.INSTANCE, false, null);
        CX_REMOTE_APPL_ERROR_MD.add("CX_ROOT", "PREVIOUS", 16, 8, 0, "Exception Mapped to the Current Exception", "CX_ROOT", null, JCoClassMetaData.JCoAttributeKind.INSTANCE, false, null);
        CX_REMOTE_APPL_ERROR_MD.add("CX_ROOT", "KERNEL_ERRID", 0, 30, 0, "Internal Name of Exception, if Triggered from Kernel", null, null, JCoClassMetaData.JCoAttributeKind.INSTANCE, false, null);
        CX_REMOTE_APPL_ERROR_MD.add("CX_ROOT", "IS_RESUMABLE", 0, 1, 0, "Flag, Whether RESUME Can Be Used in the Exception Handler", null, null, JCoClassMetaData.JCoAttributeKind.INSTANCE, false, null);
        CX_REMOTE_APPL_ERROR_MD.add("CX_REMOTE_EXCEPTION", "DESTINATION", 29, 8, 0, "Name of Destination", null, null, JCoClassMetaData.JCoAttributeKind.INSTANCE, false, null);
        CX_REMOTE_APPL_ERROR_MD.add("CX_REMOTE_APPL_ERROR", "MESSAGE_TEXT", 29, 8, 0, "Error Message in Remote System (in Logon Language)", null, null, JCoClassMetaData.JCoAttributeKind.INSTANCE, false, null);
        CX_REMOTE_APPL_ERROR_MD.add("CX_REMOTE_APPL_ERROR", "MESSAGE_TYPE", 0, 1, 0, "Message Type", null, null, JCoClassMetaData.JCoAttributeKind.INSTANCE, false, null);
        CX_REMOTE_APPL_ERROR_MD.add("CX_REMOTE_APPL_ERROR", "MESSAGE_V1", 0, 50, 0, "Message Variable MSGV1", null, null, JCoClassMetaData.JCoAttributeKind.INSTANCE, false, null);
        CX_REMOTE_APPL_ERROR_MD.add("CX_REMOTE_APPL_ERROR", "MESSAGE_V2", 0, 50, 0, "Message Variable MSGV2", null, null, JCoClassMetaData.JCoAttributeKind.INSTANCE, false, null);
        CX_REMOTE_APPL_ERROR_MD.add("CX_REMOTE_APPL_ERROR", "MESSAGE_V3", 0, 50, 0, "Message Variable MSGV3", null, null, JCoClassMetaData.JCoAttributeKind.INSTANCE, false, null);
        CX_REMOTE_APPL_ERROR_MD.add("CX_REMOTE_APPL_ERROR", "MESSAGE_V4", 0, 50, 0, "Message Variable MSGV4", null, null, JCoClassMetaData.JCoAttributeKind.INSTANCE, false, null);
        CX_REMOTE_APPL_ERROR_MD.add("CX_REMOTE_APPL_ERROR", "ABAP_RUNTIME_ERROR_ID", 29, 8, 0, "ABAP Runtime Error ID", null, null, JCoClassMetaData.JCoAttributeKind.INSTANCE, false, null);
        CX_REMOTE_APPL_ERROR_MD.add("CX_REMOTE_APPL_ERROR", "ABAP_RUNTIME_ERROR_TEXT", 29, 8, 0, "ABAP Runtime Error Text", null, null, JCoClassMetaData.JCoAttributeKind.INSTANCE, false, null);
        CX_REMOTE_APPL_ERROR_MD.lock();
    }

    public static enum Mode {
        OFF,
        FULL,
        EXCEPTION_CHAIN;

    }
}

