/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.ConversionException;
import com.sap.conn.jco.JCoMetaData;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.AbstractRequestResponse;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.FastStringBuffer;
import com.sap.conn.jco.util.XMLWriterBase;
import com.sap.i18n.decfloat.DecFloat;
import com.sap.i18n.decfloat.DecFloatType;
import java.io.IOException;
import java.io.Writer;

public class XMLWriter
extends XMLWriterBase {
    public static final String DEFAULT_NAMESPACE = "rfc";
    protected String m_namespace_urn;
    protected String[] m_tags = null;

    public static String createXMLDocument(JCoRecord record, String root_tag) {
        return XMLWriter.createXMLDocument(record, root_tag, null, null);
    }

    public static String createXMLDocument(JCoRecord record, String root_tag, String namespace, String namespace_urn) {
        String document = null;
        try {
            XMLWriter w = new XMLWriter();
            w.encode(record, root_tag, namespace, namespace_urn);
            document = w.toString();
        }
        catch (IOException ex) {
            Trace.fireTraceCritical(new FastStringBuffer().append("[JCoAPI] XMLWriter.createXMLDocument(").append(record.getMetaData().getName()).append(") throws ").append(ex.toString()).toString());
        }
        return document;
    }

    public static void writeXMLDocument(AbstractRecord record, String root_tag, Writer writer) throws IOException {
        XMLWriter w = new XMLWriter(writer);
        w.encode(record, root_tag, null, null).flush();
    }

    public XMLWriter() {
    }

    public XMLWriter(Writer writer) {
        this(null, writer);
    }

    public XMLWriter(XMLWriter parent, Writer writer) {
        super(parent, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLWriter encode(JCoRecord record, String root_tag, String namespace, String namespace_urn) throws IOException {
        this.m_namespace_urn = namespace_urn;
        if (record == null) {
            return this;
        }
        JCoMetaData md = record.getMetaData();
        int numFields = md.getFieldCount();
        if (numFields == 1 && record.getMetaData().getName().length() == 0) {
            this.m_tags = null;
        } else {
            this.m_tags = new String[numFields];
            for (int i = 0; i < numFields; ++i) {
                this.m_tags[i] = this.escape(record.getMetaData().getName(i));
            }
        }
        if (root_tag != null) {
            root_tag = this.escape(root_tag);
        }
        String root_stag = root_tag;
        String root_etag = root_tag;
        String row_tag = "ITEM";
        if (root_tag != null && namespace != null) {
            StringBuffer sb = new StringBuffer(root_stag.length() + namespace.length());
            sb.append(namespace);
            sb.append(':');
            sb.append(root_stag);
            root_etag = sb.toString();
            if (namespace_urn != null) {
                sb.append(" xmlns:");
                sb.append(namespace);
                sb.append("=\"");
                sb.append(namespace_urn);
                sb.append('\"');
            }
            root_stag = sb.toString();
        }
        if (this.m_namespace_urn != null && this.m_namespace_urn.equals("urn:sap-com:document:sap:soap:functions:uc-style")) {
            String typeName = null;
            if (record.getMetaData() instanceof DefaultRecordMetaData) {
                typeName = ((DefaultRecordMetaData)record.getMetaData()).getLineType();
            }
            row_tag = typeName != null ? typeName : "ITEM";
        } else {
            row_tag = "item";
        }
        boolean processTable = record instanceof JCoTable;
        int row_save = processTable ? ((JCoTable)record).getRow() : 0;
        int num_rows = processTable ? ((JCoTable)record).getNumRows() : 1;
        try {
            if (root_stag != null) {
                this.stag(root_stag);
            }
            for (int currRow = 0; currRow < num_rows; ++currRow) {
                if (processTable) {
                    ((JCoTable)record).setRow(currRow);
                    this.stag(row_tag);
                }
                for (int i = 0; i < numFields; ++i) {
                    this.element(record, i);
                }
                if (!processTable) continue;
                this.etag(row_tag);
            }
            if (root_etag != null) {
                this.etag(root_etag);
            }
            Object var16_17 = null;
            if (processTable) {
                ((JCoTable)record).setRow(row_save);
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            if (processTable) {
                ((JCoTable)record).setRow(row_save);
            }
            throw throwable;
        }
        return this;
    }

    public XMLWriter element(JCoRecord record, int index) throws IOException {
        int itype = record.getMetaData().getType(index);
        String tag = this.m_tags != null ? this.m_tags[index] : null;
        this.stag(tag);
        switch (itype) {
            case 0: 
            case 6: {
                AbstractRecord r = null;
                int real_idx = 0;
                if (record instanceof AbstractRequestResponse) {
                    r = (AbstractRecord)((Object)((AbstractRequestResponse)record).getMappedList(index));
                    real_idx = ((AbstractRequestResponse)record).getMappedIndex(index);
                } else {
                    r = (AbstractRecord)record;
                    real_idx = index;
                }
                char[] temp_data = r.recType == 4 ? r.tableDataRows[r.row] : r.data;
                int ioffset = r.metaData.boffset[real_idx];
                int ilength = r.metaData.blength[real_idx];
                this.content(temp_data, ioffset, ilength);
                break;
            }
            case 4: 
            case 30: {
                try {
                    this.content(record.getByteArray(index));
                }
                catch (ConversionException ex) {}
                break;
            }
            case 17: 
            case 99: {
                XMLWriter w = new XMLWriter(this, null);
                try {
                    w.encode((JCoRecord)record.getValue(index), null, null, this.m_namespace_urn);
                }
                catch (ConversionException ex) {
                    // empty catch block
                }
                w.close();
                break;
            }
            case 1: 
            case 3: {
                if (this.m_escape_mode == 2 || this.m_escape_mode == 3) {
                    AbstractRecord r = null;
                    int real_idx = 0;
                    if (record instanceof AbstractRequestResponse) {
                        r = (AbstractRecord)((Object)((AbstractRequestResponse)record).getMappedList(index));
                        real_idx = ((AbstractRequestResponse)record).getMappedIndex(index);
                    } else {
                        r = (AbstractRecord)record;
                        real_idx = index;
                    }
                    char[] temp_data = r.recType == 4 ? r.tableDataRows[r.row] : r.data;
                    int ioffset = r.metaData.boffset[real_idx];
                    int ilength = r.metaData.blength[real_idx];
                    this.content(temp_data, ioffset, ilength);
                    break;
                }
                try {
                    this.content(record.getString(index));
                }
                catch (ConversionException ex) {}
                break;
            }
            case 23: {
                byte[] bytes = record.getByteArray(index);
                this.content(DecFloat.toString(DecFloatType.DECFLOAT16_BE, bytes, 0, bytes.length));
                break;
            }
            case 24: {
                byte[] bytes = record.getByteArray(index);
                this.content(DecFloat.toString(DecFloatType.DECFLOAT34_BE, bytes, 0, bytes.length));
                break;
            }
            default: {
                try {
                    this.content(record.getString(index));
                    break;
                }
                catch (ConversionException ex) {
                    // empty catch block
                }
            }
        }
        this.etag(tag);
        return this;
    }
}

