/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoCustomDestination;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.RfcCustomizedDestination;
import com.sap.conn.jco.rt.RfcDestination;
import java.util.Properties;

public final class RfcCustomDestination
extends RfcCustomizedDestination
implements JCoCustomDestination.SncConfigurationData,
JCoCustomDestination.UserData,
JCoCustomDestination {
    protected RfcCustomDestination(String name, Properties properties, RfcDestination parent) {
        super(name, properties, "custom destination", parent);
    }

    protected RfcCustomDestination(String name, Properties properties, RfcDestination parent, String scope) {
        super(name, properties, "custom destination", parent);
        this.scopeType = scope;
    }

    public JCoCustomDestination.SncConfigurationData getSNCConfiguration() {
        return this;
    }

    public JCoCustomDestination.UserData getUserLogonData() {
        return this;
    }

    private void checkState() {
        if (this.isInitialized) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", new StringBuilder(190).append("Destination instance is already connected, hence changes in the destination parameters are not allowed. ").append("If you need to change a setting create a new instance with createCustomDestination().").toString());
        }
    }

    public void setCodepage(String codepage) {
        this.checkState();
        if (codepage != null) {
            this.properties.put("jco.client.codepage", codepage);
        } else {
            this.properties.remove("jco.client.codepage");
        }
    }

    public void setTrace(boolean trace) {
        this.checkState();
        this.properties.put("jco.client.trace", trace ? "1" : "0");
    }

    public void setUseSapGui(boolean useSapGui) {
        this.checkState();
        this.properties.put("jco.client.use_sapgui", useSapGui ? "2" : "0");
    }

    public void setRepositoryDestination(JCoDestination destination) throws JCoException {
        if (destination == null) {
            this.properties.remove("jco.destination.repository_destination");
            this.repositoryDestination = null;
            this.repository = null;
            return;
        }
        if (!(destination instanceof InternalDestination)) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only destination instances that have been created by the JCo runtime are allowed. Passed destination " + destination.getDestinationName() + " is an instance of class " + destination.getClass().getName());
        }
        InternalDestination repoDest = ((InternalDestination)destination).getRepositoryDestination();
        if (repoDest == null) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only destination instances whose repository destination refer to an SAP AS ABAP system are allowed. Passed destination " + destination.getDestinationName() + " is an instance of class " + destination.getClass().getName() + " and returned null for its repository destination");
        }
        String repoDestName = repoDest.getDestinationName();
        if (repoDestName.equals(this.getDestinationName())) {
            this.properties.remove("jco.destination.repository_destination");
        } else {
            this.properties.put("jco.destination.repository_destination", repoDestName);
        }
        if (repoDest != this.repositoryDestination) {
            this.repositoryDestination = repoDest;
            this.repository = null;
        }
    }

    public void setSncLibrary(String sncLibrary) {
        this.checkState();
        if (sncLibrary != null) {
            this.properties.put("jco.client.snc_lib", sncLibrary);
        } else {
            this.properties.remove("jco.client.snc_lib");
        }
    }

    public void setSncMode(String sncMode) {
        this.checkState();
        if ("1".equals(sncMode) || "0".equals(sncMode)) {
            this.properties.put("jco.client.snc_mode", sncMode);
        } else if (sncMode == null) {
            this.properties.remove("jco.client.snc_mode");
        } else {
            throw new IllegalArgumentException("sncMode must be 1 or 0");
        }
        this.evaluateUserId();
    }

    public void setSncMyName(String sncMyName) {
        this.checkState();
        if (sncMyName != null) {
            this.properties.put("jco.client.snc_myname", sncMyName);
        } else {
            this.properties.remove("jco.client.snc_myname");
        }
    }

    public void setSncPartnerName(String sncPartnerName) {
        this.checkState();
        if (sncPartnerName != null) {
            this.properties.put("jco.client.snc_partnername", sncPartnerName);
        } else {
            this.properties.remove("jco.client.snc_partnername");
        }
    }

    public void setSncQOP(String sncQOP) {
        this.checkState();
        if (sncQOP == null) {
            this.properties.remove("jco.client.snc_qop");
        } else if (sncQOP.length() == 1 && Character.isDigit(sncQOP.charAt(0))) {
            this.properties.put("jco.client.snc_qop", sncQOP);
        } else {
            throw new IllegalArgumentException("sncQOP must be in range [0..9]");
        }
    }

    public void setSncWithSSO(boolean useSingleSignOn) {
        this.checkState();
        this.properties.put("jco.client.snc_sso", useSingleSignOn ? "1" : "0");
        this.evaluateUserId();
    }

    public void setAliasUser(String aliasUser) {
        this.checkState();
        if (aliasUser != null) {
            this.properties.put("jco.client.alias_user", aliasUser);
        } else {
            this.properties.remove("jco.client.alias_user");
        }
        this.evaluateUserId();
    }

    public void setClient(String client) {
        this.checkState();
        if (client != null) {
            this.properties.put("jco.client.client", client);
        } else {
            this.properties.remove("jco.client.client");
        }
    }

    public void setLanguage(String lang) {
        this.checkState();
        if (lang != null) {
            this.properties.put("jco.client.lang", lang);
        } else {
            this.properties.remove("jco.client.lang");
        }
    }

    public void setPassword(String passwd) {
        this.checkState();
        if (passwd != null) {
            this.properties.put("jco.client.passwd", passwd);
        } else {
            this.properties.remove("jco.client.passwd");
        }
    }

    public void setUser(String user) {
        this.checkState();
        if (user != null) {
            this.properties.put("jco.client.user", user);
        } else {
            this.properties.remove("jco.client.user");
        }
        this.evaluateUserId();
    }

    public void setSSOTicket(String base64CodedSSOTicket) {
        this.checkState();
        if (base64CodedSSOTicket != null) {
            this.properties.put("jco.client.mysapsso2", base64CodedSSOTicket);
        } else {
            this.properties.remove("jco.client.mysapsso2");
        }
        this.updateSSOTicket = true;
        this.evaluateUserId();
    }

    public void setX509Certificate(String base64CodedCertificate) {
        this.checkState();
        if (base64CodedCertificate != null) {
            this.properties.put("jco.client.x509cert", base64CodedCertificate);
        } else {
            this.properties.remove("jco.client.x509cert");
        }
        this.updateX509Certificate = true;
        this.evaluateUserId();
    }

    public void setExternalIDData(String extIDData) {
        this.checkState();
        if (extIDData != null) {
            this.properties.put("jco.client.extid_data", extIDData);
        } else {
            this.properties.remove("jco.client.extid_data");
        }
        this.evaluateUserId();
    }

    public void setExternalIDType(String extIDType) {
        this.checkState();
        if (extIDType != null) {
            this.properties.put("jco.client.extid_type", extIDType);
        } else {
            this.properties.remove("jco.client.extid_type");
        }
        this.evaluateUserId();
    }

    public void setLogonCheck(int lcheck) {
        this.checkState();
        if (lcheck == 0) {
            this.properties.put("jco.client.lcheck", "0");
        } else {
            this.properties.remove("jco.client.lcheck");
        }
    }

    public void requestSSOTicket(boolean request) {
        this.checkState();
        this.properties.put("jco.client.getsso2", request ? "1" : "0");
    }
}

