/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogInfoData;
import com.sap.tc.logging.TraceFormatter;
import com.sap.tc.logging.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public final class FileLogInfoData
extends LogInfoData {
    private static Location classLoc = Location.getLocation(FileLogInfoData.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
    private static final String HEAD_LINE_START = "<!--";
    private static final String HEAD_LINE_END = "/-->";
    private static final String HEAD_DEL_LEFT = "[";
    private static final String HEAD_DEL_RIGHT = "]";
    private static HashMap<String, Integer> headerElements = new HashMap();
    private static final int MIN = 0;
    public static final int LOG_HEAD = 1;
    private static final String STR_LOG_HEAD = "LOGHEADER";
    public static final int LOG_HEAD_HELP = 2;
    private static final String STR_LOG_HEAD_HELP = "HELP";
    public static final int LOGGING_VERSION = 3;
    private static final String STR_LOGGING_VERSION = "LOGGINGVERSION";
    public static final int LOG_NAME = 4;
    private static final String STR_LOG_NAME = "NAME";
    public static final int LOG_DESCRIPT = 5;
    private static final String STR_LOG_DESCRIPT = "DESCRIPTION";
    public static final int LOG_F_NAME_PATTERN = 6;
    private static final String STR_LOG_F_NAME_PATTERN = "PATTERN";
    public static final int LOG_OWNER = 7;
    private static final String STR_LOG_OWNER = "OWNER";
    public static final int LOG_FORMATTER = 8;
    private static final String STR_LOG_FORMATTER = "FORMATTER";
    public static final int LOG_ENCODING = 9;
    private static final String STR_LOG_ENCODING = "ENCODING";
    public static final int LOG_FILESET = 10;
    private static final String STR_LOG_FILESET = "FILESET";
    public static final int LOG_PREV_FILE = 11;
    private static final String STR_LOG_PREV_FILE = "PREVIOUSFILE";
    public static final int LOG_NEXT_FILE = 12;
    private static final String STR_LOG_NEXT_FILE = "NEXTFILE";
    public static final int ENGINE_VERSION = 13;
    private static final String STR_ENGINE_VERSION = "ENGINEVERSION";
    private static final int MAX = 14;
    public static final int MAX_NUMBER_OF_HEADER_LINES = 15;
    private String logPattern;
    private String logFileName;
    private String logEncoding;
    private String logOwners;
    private String logFileSet;
    private int logFileSetIndex;
    private int logFileSetSize;
    private int logFileSetLimit;
    private int logFileHeaderSize;
    private String logFileNext;
    private String logFilePrev;
    private String logFormatterPattern;
    public static int MAX_FILE_SIZE_MB;
    public static int MAX_FILE_SIZE_K;
    public static int MAX_FILE_SIZE;

    public FileLogInfoData(FileLog fileLog) {
        String fileName = fileLog.expandPattern(true);
        this.init(fileName);
    }

    public FileLogInfoData(String fileName) {
        this.init(fileName);
    }

    public static String buildHeader(FileLog fileLog) {
        return FileLogInfoData.format(fileLog);
    }

    public String getPattern() {
        if (this.logPattern != null) {
            return this.logPattern;
        }
        return "";
    }

    public String getEncoding() {
        if (this.logEncoding != null) {
            return this.logEncoding;
        }
        return "";
    }

    public String getOwners() {
        if (this.logOwners != null) {
            return this.logOwners;
        }
        return "";
    }

    public String getFileSet() {
        if (this.logFileSetSize > 0) {
            this.logFileSet = "" + this.logFileSetIndex + ", " + this.logFileSetSize + ", " + this.logFileSetLimit;
        }
        if (this.logFileSet != null) {
            return this.logFileSet;
        }
        return "";
    }

    public int getFileSetIndex() {
        return this.logFileSetIndex;
    }

    public int getFileSetSize() {
        return this.logFileSetSize;
    }

    public int getFileSetLimit() {
        return this.logFileSetLimit;
    }

    public int getFileHeaderSize() {
        return this.logFileHeaderSize;
    }

    public String getFileName() {
        if (this.logFileName != null) {
            return this.logFileName;
        }
        return "";
    }

    public String getFormatterPattern() {
        if (this.logFormatterPattern != null) {
            return this.logFormatterPattern;
        }
        return "";
    }

    public String getFileNext() {
        return this.logFileNext;
    }

    public String getFilePrev() {
        return this.logFilePrev;
    }

    protected void setPattern(String value) {
        this.logPattern = value;
        this.headerIsChanged();
    }

    protected void setFileName(String value) {
        this.logFileName = value;
        this.headerIsChanged();
    }

    protected void setEncoding(String value) {
        this.logEncoding = value;
        this.headerIsChanged();
    }

    protected void setOwners(List value) {
        this.headerIsChanged();
    }

    protected void setFileSetIndex(int value) {
        this.logFileSetIndex = value;
        this.headerIsChanged();
    }

    protected void setFileSet(int size, int limit) {
        this.logFileSetSize = size;
        this.logFileSetLimit = limit;
        this.headerIsChanged();
    }

    protected void setFileNext(String value) {
        this.logFileNext = value;
    }

    protected void setFilePrev(String value) {
        this.logFilePrev = value;
    }

    private void init(String fileName) {
        this.setFileName(fileName);
        this.loadFileLogHeader(fileName);
        this.resetIsChanged();
    }

    private String buildHeaderInt() {
        if (this.isChanged()) {
            this.setHeader(this.format());
            this.resetIsChanged();
        }
        return this.getHeader();
    }

    private static String formatFormatter(Formatter formatter) {
        String formatterName = formatter.getClass().getName();
        if (formatter instanceof TraceFormatter) {
            formatterName = formatterName + "(" + ((TraceFormatter)formatter).getPattern() + ")";
        }
        return formatterName;
    }

    private void parseFormatter(String value) {
        String strFormatter = null;
        this.logFormatterPattern = null;
        int startPos = value.indexOf("(");
        if (startPos > 0) {
            strFormatter = value.substring(0, startPos);
            this.logFormatterPattern = value.substring(startPos + 1, value.length() - 1);
        } else {
            strFormatter = value;
        }
        this.setFormatter(FileLogInfoData.createFormatter(strFormatter));
        if (this.logFormatterPattern != null && this.logFormatterPattern.length() > 0) {
            ((TraceFormatter)this.getFormatter()).setPattern(this.logFormatterPattern);
        }
    }

    private void setFileSet(String value) {
        String[] strFromPat = FileLogInfoData.getRotatingSetValues(value);
        if (strFromPat.length == 3) {
            this.setFileSet(new Integer(strFromPat[1].trim()), new Integer(strFromPat[2].trim()));
            this.setFileSetIndex(new Integer(strFromPat[0].trim()));
        }
        this.headerIsChanged();
    }

    private void loadFileLogHeader(String fileName) {
        String[] headLines = this.getFileHeaderLines(fileName);
        if (headLines != null) {
            if (this.parse(this.parseHeader(headLines))) {
                this.buildHeaderInt();
            } else {
                this.setHeader(null);
            }
        }
    }

    private String[] getFileHeaderLines(String fileName) {
        return this.getFileHeaderLines(fileName, 15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getFileHeaderLines(String fileName, int cntHeadLines) {
        String[] headerLines = new String[cntHeadLines];
        int headerLineCount = 0;
        int lenghtBOL = 0;
        BufferedReader file = null;
        File sourceFile = new File(fileName);
        if (sourceFile.length() > (long)MAX_FILE_SIZE) {
            String filePath = null;
            try {
                filePath = sourceFile.getCanonicalPath();
            }
            catch (IOException e) {
                filePath = sourceFile.getAbsolutePath();
            }
            String message = "Will not read possible log file : " + filePath + " since its size : " + sourceFile.length() / (long)MAX_FILE_SIZE_K + " mb  exceeds the max log file size : " + MAX_FILE_SIZE_MB + " mb";
            classLoc.warningT(message);
            if (classLoc.beDebug()) {
                classLoc.traceThrowableT(100, message, new Exception());
            }
            return null;
        }
        try {
            String lineValue;
            lenghtBOL = this.getEOLLength(fileName);
            file = new BufferedReader(new FileReader(fileName));
            int linesRead = 0;
            int lenLeftLineMark = HEAD_LINE_START.length();
            int lenRightLineMark = HEAD_LINE_START.length();
            while ((lineValue = file.readLine()) != null && headerLineCount < cntHeadLines && linesRead++ < 15) {
                if (lineValue.length() < lenLeftLineMark) continue;
                if (lineValue.substring(0, lenLeftLineMark).equals(HEAD_LINE_START)) {
                    headerLines[headerLineCount] = lineValue.substring(lenLeftLineMark, lineValue.length() - lenRightLineMark);
                    this.logFileHeaderSize += lineValue.length();
                    ++headerLineCount;
                }
                if (!lineValue.startsWith(ListFormatter.DELIMITER_STR)) continue;
                String verNumb = lineValue.substring(1, 4);
                Version.setVersionOfFirstRecord(verNumb);
                break;
            }
            if (headerLineCount > 0) {
                this.logFileHeaderSize += headerLineCount * lenghtBOL;
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            APILogger.logIntByAPI(400, classLoc, "[getFileHeader(String fileName, int cntHeadLines)]", "ASJ.log_api.000003", "Unexcepted error occured on {0}!", new String[]{"FileHeader parsing"});
            APILogger.catchingIntByAPI(ex);
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e) {}
                file = null;
            }
        }
        if (headerLineCount > 0) {
            String[] finalHeaderLines = new String[headerLineCount];
            System.arraycopy(headerLines, 0, finalHeaderLines, 0, headerLineCount);
            return finalHeaderLines;
        }
        return null;
    }

    private int getEOLLength(String fileName) throws Exception {
        BufferedReader file = null;
        int length = 0;
        try {
            if (!new File(fileName).exists()) {
                int n = length;
                return n;
            }
            file = new BufferedReader(new FileReader(fileName));
            char[] lineByte = new char[8000];
            file.read(lineByte);
            for (int pos = 0; pos < 8000; ++pos) {
                if (lineByte[pos] != '\n') continue;
                length = pos > 0 && lineByte[pos - 1] == '\r' ? 2 : 1;
                break;
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e) {}
                file = null;
            }
        }
        return length;
    }

    private Map parseHeader(String[] headerLines) {
        String lineKeyName = null;
        String lineValue = null;
        HashMap<String, String> headLines = new HashMap<String, String>();
        for (int i = 0; i < headerLines.length; ++i) {
            lineKeyName = FileLogInfoData.getKey(headerLines[i]);
            lineValue = FileLogInfoData.getValue(headerLines[i]);
            if (lineKeyName == null || lineValue == null || lineKeyName.length() <= 0) continue;
            headLines.put(lineKeyName, lineValue);
        }
        return headLines;
    }

    private static String getKey(String value) {
        String lineKey = null;
        int pos = 0;
        if (value == null) {
            return "";
        }
        pos = value.indexOf(HEAD_DEL_LEFT);
        if (pos > 0) {
            lineKey = value.substring(0, pos);
        }
        return lineKey;
    }

    private static String getValue(String value) {
        String lineValue = null;
        int pos = 0;
        if (value == null) {
            return "";
        }
        pos = value.indexOf(HEAD_DEL_LEFT);
        if (pos > 0 && pos + 1 < value.length()) {
            lineValue = value.substring(pos + 1, value.length() - 1);
        }
        return lineValue;
    }

    private boolean parse(Map headerLines) {
        int conKey = 0;
        String conValue = null;
        Map.Entry entry2 = null;
        block14: for (Map.Entry entry2 : headerLines.entrySet()) {
            conKey = FileLogInfoData.parseKeyByName((String)entry2.getKey());
            conValue = (String)entry2.getValue();
            switch (conKey) {
                case 3: {
                    this.setVerInUse(conValue);
                    continue block14;
                }
                case 13: {
                    this.setEngineVersion(conValue);
                    continue block14;
                }
                case 7: {
                    continue block14;
                }
                case 4: {
                    this.setName(conValue);
                    continue block14;
                }
                case 5: {
                    this.setDescription(conValue);
                    continue block14;
                }
                case 6: {
                    this.setPattern(conValue);
                    continue block14;
                }
                case 8: {
                    this.parseFormatter(conValue);
                    continue block14;
                }
                case 9: {
                    this.setEncoding(conValue);
                    continue block14;
                }
                case 10: {
                    this.setFileSet(conValue);
                    continue block14;
                }
                case 11: {
                    this.setFilePrev(conValue);
                    continue block14;
                }
                case 12: {
                    this.setFileNext(conValue);
                    continue block14;
                }
                case 1: 
                case 2: {
                    continue block14;
                }
            }
            APILogger.logIntByAPI(400, classLoc, "[parse()]", "ASJ.log_api.000052", "File header does not exists or has a wrong format on Log ({0}).", new String[]{this.getPattern()});
            return false;
        }
        return true;
    }

    private static int parseKeyByName(String keyName) {
        if (keyName != null && headerElements.containsKey(keyName.toUpperCase(Locale.ENGLISH))) {
            return headerElements.get(keyName.toUpperCase(Locale.ENGLISH));
        }
        return -1;
    }

    private static String format(FileLog fileLog) {
        String engVer;
        String pattern = "";
        String[] headerFields = new String[15];
        headerFields[0] = FileLogInfoData.formatHeaderLine(STR_LOG_HEAD, "START");
        headerFields[2] = FileLogInfoData.formatHeaderLine(STR_LOG_HEAD_HELP, "Manual modification of the header may cause parsing problem!");
        headerFields[3] = FileLogInfoData.formatHeaderLine(STR_LOGGING_VERSION, Version.getFullVersion());
        if (fileLog.getName() != null) {
            headerFields[4] = FileLogInfoData.formatHeaderLine(STR_LOG_NAME, fileLog.getName());
        }
        if (fileLog.getDescription() != null) {
            headerFields[5] = FileLogInfoData.formatHeaderLine(STR_LOG_DESCRIPT, fileLog.getDescription());
        }
        pattern = fileLog.getFileNamePattern();
        headerFields[6] = FileLogInfoData.formatHeaderLine(STR_LOG_F_NAME_PATTERN, pattern);
        headerFields[8] = FileLogInfoData.formatHeaderLine(STR_LOG_FORMATTER, FileLogInfoData.formatFormatter(fileLog.getFormatter()));
        headerFields[9] = FileLogInfoData.formatHeaderLine(STR_LOG_ENCODING, fileLog.getEncoding());
        if (fileLog.getCnt() > 0) {
            headerFields[10] = FileLogInfoData.formatHeaderLine(STR_LOG_FILESET, "" + fileLog.getIndex() + ", " + fileLog.getCnt() + ", " + fileLog.getLimit());
            headerFields[11] = FileLogInfoData.formatHeaderLine(STR_LOG_PREV_FILE, "" + new FileLog().expandPattern(pattern, fileLog.getIndex() - 1 < 0 ? fileLog.getCnt() - 1 : fileLog.getIndex() - 1, true, true));
            headerFields[12] = FileLogInfoData.formatHeaderLine(STR_LOG_NEXT_FILE, "" + new FileLog().expandPattern(pattern, fileLog.getIndex() + 1 > fileLog.getCnt() - 1 ? 0 : fileLog.getIndex() + 1, true, true));
        }
        if ((engVer = System.getProperties().getProperty("SAP_J2EE_Engine_Version")) != null) {
            headerFields[13] = FileLogInfoData.formatHeaderLine(STR_ENGINE_VERSION, engVer);
        }
        headerFields[14] = FileLogInfoData.formatHeaderLine(STR_LOG_HEAD, "END");
        return FileLogInfoData.formatHeader(headerFields);
    }

    private String format() {
        String engVer;
        String pattern = "";
        String[] headerFields = new String[15];
        headerFields[0] = FileLogInfoData.formatHeaderLine(STR_LOG_HEAD, "START");
        headerFields[2] = FileLogInfoData.formatHeaderLine(STR_LOG_HEAD_HELP, "Manual modification of the header may cause parsing problem!");
        headerFields[3] = FileLogInfoData.formatHeaderLine(STR_LOGGING_VERSION, this.getVerInUse());
        if (this.getName() != null) {
            headerFields[4] = FileLogInfoData.formatHeaderLine(STR_LOG_NAME, this.getName());
        }
        if (this.getDescription() != null) {
            headerFields[5] = FileLogInfoData.formatHeaderLine(STR_LOG_DESCRIPT, this.getDescription());
        }
        pattern = this.getPattern();
        headerFields[6] = FileLogInfoData.formatHeaderLine(STR_LOG_F_NAME_PATTERN, pattern);
        headerFields[8] = this.getFormatterPattern().length() > 0 ? FileLogInfoData.formatHeaderLine(STR_LOG_FORMATTER, FileLogInfoData.formatFormatter(this.getFormatter())) : FileLogInfoData.formatHeaderLine(STR_LOG_FORMATTER, this.getFormatter().getClass().getName());
        if (this.getEncoding() != null && this.getEncoding().length() > 0) {
            headerFields[9] = FileLogInfoData.formatHeaderLine(STR_LOG_ENCODING, this.getEncoding());
        }
        if (this.getFileSet().length() > 0) {
            headerFields[10] = FileLogInfoData.formatHeaderLine(STR_LOG_FILESET, this.getFileSet());
            headerFields[11] = FileLogInfoData.formatHeaderLine(STR_LOG_PREV_FILE, "" + this.getFilePrev());
            headerFields[12] = FileLogInfoData.formatHeaderLine(STR_LOG_NEXT_FILE, "" + this.getFileNext());
        }
        if ((engVer = System.getProperties().getProperty("SAP_J2EE_Engine_Version")) != null) {
            headerFields[13] = FileLogInfoData.formatHeaderLine(STR_ENGINE_VERSION, engVer);
        }
        headerFields[14] = FileLogInfoData.formatHeaderLine(STR_LOG_HEAD, "END");
        return FileLogInfoData.formatHeader(headerFields);
    }

    private static String formatHeaderLine(String headerKey, String headerValue) {
        StringBuffer header = new StringBuffer();
        if (headerKey != null && headerValue != null) {
            header.append(headerKey);
            header.append(HEAD_DEL_LEFT);
            header.append(headerValue);
            header.append(HEAD_DEL_RIGHT);
        }
        return header.toString();
    }

    private static String formatHeader(String[] headerLines) {
        StringBuffer header = new StringBuffer();
        if (headerLines != null && headerLines.length > 0) {
            for (int i = 0; i < headerLines.length; ++i) {
                if (headerLines[i] == null) continue;
                header.append(HEAD_LINE_START);
                header.append(headerLines[i]);
                header.append(HEAD_LINE_END + Formatter.EOL);
            }
        }
        return header.toString();
    }

    private static Formatter createFormatter(String fType) {
        if (fType == null) {
            return null;
        }
        try {
            return (Formatter)Class.forName(fType).newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String[] getRotatingSetValues(String value) {
        if (value == null || value.length() == 0) {
            return new String[0];
        }
        StringTokenizer tmpTokens = new StringTokenizer(value, ",", false);
        String[] tmpValue = new String[3];
        if (tmpTokens.countTokens() != 3) {
            return new String[0];
        }
        for (int i = 0; i < 3; ++i) {
            tmpValue[i] = tmpTokens.nextToken().trim();
        }
        return tmpValue;
    }

    static {
        headerElements.put(STR_LOG_HEAD, new Integer(1));
        headerElements.put(STR_LOG_HEAD_HELP, new Integer(2));
        headerElements.put(STR_LOGGING_VERSION, new Integer(3));
        headerElements.put(STR_LOG_NAME, new Integer(4));
        headerElements.put(STR_LOG_DESCRIPT, new Integer(5));
        headerElements.put(STR_LOG_F_NAME_PATTERN, new Integer(6));
        headerElements.put(STR_LOG_OWNER, new Integer(7));
        headerElements.put(STR_LOG_FORMATTER, new Integer(8));
        headerElements.put(STR_LOG_ENCODING, new Integer(9));
        headerElements.put(STR_LOG_FILESET, new Integer(10));
        headerElements.put(STR_LOG_PREV_FILE, new Integer(11));
        headerElements.put(STR_LOG_NEXT_FILE, new Integer(12));
        headerElements.put(STR_ENGINE_VERSION, new Integer(13));
        MAX_FILE_SIZE_MB = 250;
        MAX_FILE_SIZE_K = 0x100000;
        MAX_FILE_SIZE = MAX_FILE_SIZE_MB * MAX_FILE_SIZE_K;
    }
}

