/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoBackgroundUnitAttributes;
import com.sap.conn.jco.JCoRuntimeException;

public class AbapBackgroundUnitAttributes
implements JCoBackgroundUnitAttributes {
    private String client;
    private String userID;
    private String programName;
    private boolean commitCheckOn;
    private boolean kernelTraceOn;
    private boolean unitHistoryOn;
    private boolean lockOn;
    private boolean readOnly = false;

    void lock() {
        this.readOnly = true;
    }

    private void checkWriteAccess() {
        if (this.readOnly) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "The function unit attributes have been set by the ABAP client and cannot be modified");
        }
    }

    @Override
    public String getClient() {
        return this.client;
    }

    @Override
    public String getProgramName() {
        return this.programName;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public boolean isCommitCheckOn() {
        return this.commitCheckOn;
    }

    @Override
    public boolean isKernelTraceOn() {
        return this.kernelTraceOn;
    }

    @Override
    public boolean isUnitHistoryOn() {
        return this.unitHistoryOn;
    }

    @Override
    public boolean isUnitLocked() {
        return this.lockOn;
    }

    @Override
    public void setClient(String client) {
        this.checkWriteAccess();
        this.client = client;
    }

    @Override
    public void setCommitCheckOn(boolean checkOn) {
        this.checkWriteAccess();
        this.commitCheckOn = checkOn;
    }

    @Override
    public void setKernelTrace(boolean traceOn) {
        this.checkWriteAccess();
        this.kernelTraceOn = traceOn;
    }

    @Override
    public void setLock(boolean lock) {
        this.checkWriteAccess();
        this.lockOn = lock;
    }

    @Override
    public void setProgramName(String programName) {
        this.checkWriteAccess();
        this.programName = programName;
    }

    @Override
    public void setUnitHistory(boolean historyOn) {
        this.checkWriteAccess();
        this.unitHistoryOn = historyOn;
    }

    @Override
    public void setUser(String userID) {
        this.checkWriteAccess();
        this.userID = userID;
    }
}

