/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.util.ConnectionInfo;
import com.sap.conn.rfc.api.RfcAcceptInfo;
import com.sap.conn.rfc.api.RfcConnectionState;
import com.sap.conn.rfc.api.RfcOptions;
import com.sap.conn.rfc.engine.AbSysInfo;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcException;
import java.util.ArrayList;

public abstract class RfcIoControl {
    private static final int MAX_HANDLE = 10000;
    private static RfcIoOpenCntl[] rfc_gl_open_phkey = new RfcIoOpenCntl[10000];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RfcIoOpenCntl ab_rfcaccept(RfcAcceptInfo acceptInfo, Object connection) throws RfcException {
        RfcIoOpenCntl act_cntl = null;
        try {
            act_cntl = RfcIoControl.open_new();
            act_cntl.name = "<accepted>";
            act_cntl.type = acceptInfo.getConnectionType();
            act_cntl.accepted = true;
            act_cntl.input = true;
            act_cntl.inCallback = false;
            act_cntl.rfc_role = (char)83;
            boolean bl = act_cntl.trace = acceptInfo.isTraceOn() || RfcIoOpenCntl.isGeneralTraceOn();
            if (act_cntl.open_channel() != 0) {
                RfcIoControl.error_end(act_cntl);
            }
            act_cntl.connRef = connection;
            int rc = act_cntl.channel.accept(acceptInfo);
            act_cntl.updateConvID();
            Trc.rfctrace(act_cntl, "ACCEPT", null, 0);
            if (rc != 0) {
                RfcIoControl.error_end(act_cntl);
            }
            Object var5_4 = null;
            if (act_cntl == null) return act_cntl;
            if (!act_cntl.closed) return act_cntl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (act_cntl == null) throw throwable;
            if (!act_cntl.closed) throw throwable;
            RfcIoControl.release(act_cntl);
            act_cntl.connRef = null;
            act_cntl = null;
            throw throwable;
        }
        RfcIoControl.release(act_cntl);
        act_cntl.connRef = null;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RfcIoOpenCntl ab_rfcopen(String key, String destination, int type, RfcOptions options) throws RfcException {
        RfcIoOpenCntl act_cntl = null;
        try {
            act_cntl = RfcIoControl.open_new();
            act_cntl.opened = false;
            act_cntl.inCallback = false;
            if (destination != null) {
                act_cntl.destination = destination;
            }
            if (key != null) {
                act_cntl.name = key;
            }
            act_cntl.type = type;
            if (options != null) {
                act_cntl.rfcio_setopt(options);
            }
            if (act_cntl.open_channel() != 0) {
                RfcIoControl.error_end(act_cntl);
            }
            Trc.rfctrace(act_cntl, "OPEN", null, 0);
            int rc = act_cntl.channel.open(options);
            if (rc != 0) {
                RfcIoControl.error_end(act_cntl);
            }
            act_cntl.opened = true;
            act_cntl.rfc_role = (char)67;
            Object var7_6 = null;
            if (act_cntl == null) return act_cntl;
            if (!act_cntl.closed) return act_cntl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (act_cntl == null) throw throwable;
            if (!act_cntl.closed) throw throwable;
            RfcIoControl.release(act_cntl);
            act_cntl = null;
            throw throwable;
        }
        RfcIoControl.release(act_cntl);
        return null;
    }

    public static RfcIoOpenCntl restoreConnection(RfcConnectionState state, Object connRef) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcIoControl.open_new();
        act_cntl.restoreState(state);
        act_cntl.connRef = connRef;
        if (act_cntl.trace) {
            Trc.rfctrace(act_cntl, "RESTORE", null, 0);
        }
        return act_cntl;
    }

    public static RfcIoOpenCntl ab_rfccntl(long handle) {
        RfcIoOpenCntl act_cntl = RfcIoControl.rfc_gl_cntl(handle);
        if (act_cntl == null || !act_cntl.used) {
            return null;
        }
        return act_cntl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RfcIoOpenCntl open_new() throws RfcException {
        RfcIoOpenCntl act_cntl = null;
        RfcIoOpenCntl[] rfcIoOpenCntlArray = rfc_gl_open_phkey;
        synchronized (rfc_gl_open_phkey) {
            for (int actslot = 1; actslot < 10000; ++actslot) {
                if (rfc_gl_open_phkey[actslot] == null) {
                    act_cntl = new RfcIoOpenCntl();
                    act_cntl.hrfc = actslot;
                    RfcIoControl.rfc_gl_open_phkey[actslot] = act_cntl;
                    break;
                }
                if (RfcIoControl.rfc_gl_open_phkey[actslot].used) continue;
                act_cntl = rfc_gl_open_phkey[actslot];
                act_cntl.reset();
                act_cntl.hrfc = actslot;
                break;
            }
            if (act_cntl == null) {
                throw new RfcException(1, "Maximum number of RFC connections reached [10000]", 106, 0L, true);
            }
            act_cntl.used = true;
            act_cntl.pcs = (byte)2;
            act_cntl.ignoreConvErr = 1;
            act_cntl.setCodepage(AbSysInfo.charset);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return act_cntl;
        }
    }

    public static void release(RfcIoOpenCntl cntl) {
        assert (cntl != null) : "Connection control object is null when trying to release it";
        if (cntl.trace) {
            Trc.rfctrace(cntl, "FREE", null, 0);
            Trc.closeTrace();
        }
        cntl.channel = null;
        cntl.used = false;
    }

    private static RfcIoOpenCntl rfc_gl_cntl(long slot) {
        if (slot == 0L || slot >= 10000L) {
            return null;
        }
        return rfc_gl_open_phkey[(int)slot];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionInfo[] getConnectionsInfo() {
        ArrayList<ConnectionInfo> connectionsInfoList = new ArrayList<ConnectionInfo>();
        RfcIoOpenCntl[] rfcIoOpenCntlArray = rfc_gl_open_phkey;
        synchronized (rfc_gl_open_phkey) {
            for (int i = 1; i < 10000 && rfc_gl_open_phkey[i] != null; ++i) {
                byte role;
                if (!RfcIoControl.rfc_gl_open_phkey[i].used) continue;
                byte by = role = RfcIoControl.rfc_gl_open_phkey[i].rfc_role == 'C' ? (byte)2 : 1;
                byte state = RfcIoControl.rfc_gl_open_phkey[i].closed ? (byte)4 : (RfcIoControl.rfc_gl_open_phkey[i].close_pending ? (byte)3 : 1);
                connectionsInfoList.add(new ConnectionInfo(role, RfcIoControl.rfc_gl_open_phkey[i].allocationType, state, RfcIoControl.rfc_gl_open_phkey[i].userid, RfcIoControl.rfc_gl_open_phkey[i].sysid));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ConnectionInfo[] connectionsInfo = new ConnectionInfo[connectionsInfoList.size()];
            connectionsInfoList.toArray(connectionsInfo);
            return connectionsInfo;
        }
    }

    private static void error_end(RfcIoOpenCntl act_cntl) throws RfcException {
        String msg;
        if (act_cntl != null) {
            msg = act_cntl.channel.getMessage();
            act_cntl.ab_rfcclose();
        } else {
            msg = "no message";
        }
        throw new RfcException(1, msg, 102, 0L, true);
    }
}

