/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.util.SyncDateFormat;
import com.sap.conn.rfc.api.IRfcParameter;
import com.sap.conn.rfc.api.IRfcTable;
import com.sap.conn.rfc.api.RfcApi;
import com.sap.conn.rfc.api.RfcOptions;
import com.sap.conn.rfc.engine.RfcIoControl;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcTraceWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;

public class Trc {
    private static RfcTraceWriter m_trc = RfcApi.runtime.getRfcTraceWriter();
    private static final String m_timeStampFormat = "EEE MMM dd HH:mm:ss,SSS";
    private static final SyncDateFormat m_syncDateFormat = new SyncDateFormat("EEE MMM dd HH:mm:ss,SSS");
    private static final String m_timeStampFormatShort = "HH:mm:ss,SSS";
    private static final SyncDateFormat m_syncDateFormatShort = new SyncDateFormat("HH:mm:ss,SSS");
    private static String SP = "    ";
    private static final String[] type_string = new String[]{"EXT", "TST", "SNA", "INT", "R/3", "TCP", "QUE", "XAB", "GUI", "DIA", "PBK", "ASY", "REG", "GUI", "BCK", "ADO", "SHM", "GUI", "VMC"};
    public static final String[] HEX = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    private static final String getTypeString(int type) {
        switch (type) {
            case 0: {
                return "CHAR";
            }
            case 8: {
                return "INT";
            }
            case 6: {
                return "NUM";
            }
            case 2: {
                return "BCD";
            }
            case 1: {
                return "DATE";
            }
            case 3: {
                return "TIME";
            }
            case 7: {
                return "FLOAT";
            }
            case 4: {
                return "BYTE";
            }
            case 29: {
                return "STRING";
            }
            case 30: {
                return "XSTRING";
            }
            case 9: {
                return "INT2";
            }
            case 10: {
                return "INT1";
            }
            case 17: {
                return "STRUCTURE";
            }
            case 99: {
                return "TABLE";
            }
            case 42: {
                return "XMLDATA";
            }
        }
        return "CHAR";
    }

    public static String rfctype(int type) {
        if (type >= type_string.length) {
            return "???";
        }
        return type_string[type];
    }

    public static void rfc_hexdump(byte[] buffer, int blen) {
        byte[] localbuffer = new byte[16];
        int count = 0;
        int ptr = 0;
        if (buffer == null || blen == 0) {
            return;
        }
        while (blen != 0) {
            int i = 0;
            if (blen < 16) {
                System.arraycopy(buffer, ptr, localbuffer, 0, blen);
                Arrays.fill(localbuffer, blen, localbuffer.length, (byte)0);
                buffer = localbuffer;
                blen = 16;
            } else {
                System.arraycopy(buffer, ptr, localbuffer, 0, 16);
            }
            StringBuilder str = new StringBuilder(Integer.toHexString(count));
            for (i = str.length(); i < 6; ++i) {
                str.insert(0, '0');
            }
            str.append(" |");
            for (i = 0; i < 16; ++i) {
                if (i % 4 == 0) {
                    str.append(' ');
                }
                str.append(HEX[(byte)(localbuffer[i] >> 4 & 0xF)]);
                str.append(HEX[(byte)(localbuffer[i] & 0xF)]);
            }
            str.append(" |");
            for (i = 0; i < 16; ++i) {
                byte c = localbuffer[i];
                if (c > 31 && c < 127) {
                    str.append((char)c);
                    continue;
                }
                str.append('.');
            }
            str.append("\n");
            m_trc.debugTrace(str.toString());
            ptr += 16;
            blen -= 16;
            count += 16;
        }
    }

    public static void ab_rfctrc(String text) {
        m_trc.infoTrace(text);
    }

    public static void ab_rfctrc(String text, Throwable th) {
        if (th != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            th.printStackTrace(pw);
            pw.flush();
            StringBuilder buf = new StringBuilder(text).append("\n   ").append(sw.getBuffer().toString());
            text = buf.toString();
        }
        m_trc.infoTrace(text);
    }

    private static void print_handle(long handle) {
        Trc.ab_rfctrc(SP + "handle = " + handle + "\n");
    }

    public static void TRfcCall(long handle, String function, IRfcParameter[] exporting, IRfcParameter[] changing, IRfcTable[] tables) {
        if (function == null) {
            Trc.ab_rfctrc("*> RfcCall\n   FUNCTION <null> \n");
        } else {
            Trc.ab_rfctrc("*> RfcCall\n   FUNCTION " + function + "\n");
        }
        Trc.print_handle(handle);
        Trc.print_parameters(exporting);
        Trc.print_parameters(changing);
        Trc.print_tables(tables);
    }

    public static void TRfcReceive(long handle, IRfcParameter[] importing, IRfcParameter[] changing, IRfcTable[] tables) {
        Trc.ab_rfctrc("*> RfcReceive ... \n");
        Trc.print_handle(handle);
        Trc.print_parameters(importing);
        Trc.print_parameters(changing);
        Trc.print_tables(tables);
    }

    public static void TRfcAbort(long rfc_handle, String text) {
        Trc.ab_rfctrc("\n>>>> RfcAbort called by external program ...\n");
        Trc.print_handle(rfc_handle);
        if (text == null) {
            text = "<null text>";
        }
        Trc.ab_rfctrc(SP + "text = " + text + "\n\n");
    }

    private static void print_parameters(IRfcParameter[] par) {
        if (par == null) {
            Trc.ab_rfctrc(SP + "parameter   = <null> \n\n");
        } else {
            for (int i = 0; i < par.length; ++i) {
                Trc.ab_rfctrc(SP + "parameter[" + i + "].name = " + par[i].getName() + "\n");
                Trc.ab_rfctrc(SP + "parameter[" + i + "].type = " + Trc.getTypeString(par[i].getType()) + "\n");
                Trc.ab_rfctrc(SP + "parameter[" + i + "].length = " + par[i].getNumBytes() + "\n\n");
            }
        }
    }

    private static void print_tables(IRfcTable[] tables) {
        int i = 0;
        if (tables == null) {
            Trc.ab_rfctrc(SP + "tables = <null> \n\n");
        } else {
            for (i = 0; i < tables.length; ++i) {
                Trc.ab_rfctrc(SP + "table[" + i + "].name = " + tables[i].getName() + "\n");
                int numRows = tables[i].getNumRows();
                if (numRows > 0) {
                    Trc.ab_rfctrc(SP + "table[" + i + "].rows = " + numRows + "\n");
                }
                Trc.ab_rfctrc(SP + "table[" + i + "].length = " + tables[i].getRowLength() + "\n\n");
            }
        }
    }

    public static void TRfcGetName(long handle, String name) {
        Trc.ab_rfctrc("\n\n*> RfcGetName\n");
        Trc.print_handle(handle);
        if (name == null) {
            Trc.ab_rfctrc(SP + "functionname  = <null>\n");
        } else {
            Trc.ab_rfctrc(SP + "functionname  = " + name + "\n");
        }
    }

    public static void TRfcGetData(long handle, IRfcParameter[] importing, IRfcParameter[] changing, IRfcTable[] tables) {
        Trc.ab_rfctrc("\n*> RfcGetData\n");
        Trc.print_handle(handle);
        Trc.print_parameters(importing);
        Trc.print_parameters(changing);
        Trc.print_tables(tables);
    }

    public static void TRfcSendData(long handle, IRfcParameter[] exporting, IRfcParameter[] changing, IRfcTable[] tables) {
        Trc.ab_rfctrc("\n*> RfcSendData\n");
        Trc.print_handle(handle);
        Trc.print_parameters(exporting);
        Trc.print_parameters(changing);
        Trc.print_tables(tables);
    }

    static void TRfcRaise(long handle, String exception) {
        Trc.ab_rfctrc("*> RfcRaise\n");
        Trc.print_handle(handle);
        if (exception == null) {
            Trc.ab_rfctrc(SP + "exception   = <null>\n");
        } else {
            Trc.ab_rfctrc(SP + "exception   = " + exception + "\n");
        }
    }

    static void TRfcRaiseErrorMessage(long handle, String exception, String messageClass, char messageType, String messageNumber, String[] messageParameters) {
        Trc.ab_rfctrc("*> RfcRaiseErrorMessage\n");
        Trc.print_handle(handle);
        Trc.ab_rfctrc(SP + "exception     = " + exception + "\n");
        Trc.ab_rfctrc(SP + "messageClass  = " + messageClass + "\n");
        Trc.ab_rfctrc(SP + "messageType   = " + messageType + "\n");
        Trc.ab_rfctrc(SP + "messageNumber = " + messageNumber + "\n");
        if (messageParameters != null) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < 3; ++i) {
                buf.append('\'').append(messageParameters[i]).append("', ");
            }
            buf.append('\'').append(messageParameters[3]).append('\'');
            Trc.ab_rfctrc(SP + "messageParameters = " + buf.toString() + "\n");
        }
    }

    static void TRfcRaiseAbapClassException(long handle, AbapClassException ace) {
        Trc.ab_rfctrc("*> RaiseAbapClassException\n");
        Trc.print_handle(handle);
        Trc.ab_rfctrc(SP + "class exception = " + ace.getClassName() + "\n");
        Trc.ab_rfctrc(SP + "message = " + ace.getMessage() + "\n");
    }

    public static void TRfcOpen(RfcOptions options) {
        Trc.TRfcApiStart("\n\n*> RfcOpen\n    " + options.toString());
    }

    public static void TRfcApiStart(String what) {
        Trc.ab_rfctrc("\n\n<* " + what + " >" + Trc.getTimeStamp() + "<");
        Trc.ab_rfctrc("\n\n");
    }

    public static void TRfcApiEnd(String what, boolean happyEnd) {
        Trc.ab_rfctrc("\n\n<* " + what + " >" + Trc.getTimeStamp() + "<");
        if (happyEnd) {
            Trc.ab_rfctrc("    successful *>");
        } else {
            Trc.ab_rfctrc("    failed *>");
        }
        Trc.ab_rfctrc("\n\n");
    }

    public static void tConString(boolean trace, String what) {
        if (trace) {
            m_trc.infoTrace(what);
        }
    }

    public static void tConStringHandle(boolean trace, String what, long handle) {
        if (trace) {
            StringBuilder text = new StringBuilder(64);
            text.append(what);
            text.append(" [");
            text.append(handle);
            text.append("]");
            m_trc.infoTrace(text.toString());
        }
    }

    public static void tConNativeBegin(boolean trace, String what, long handle) {
        if (trace) {
            Trc.tNativeBegin(what, handle);
        }
    }

    public static void tConNativeEnd(boolean trace, String what, long handle) {
        if (trace) {
            Trc.tNativeEnd(what, handle);
        }
    }

    private static void tNativeBegin(String what, long handle) {
        Trc.tTraceHandle("    >> native call " + what, handle, null, null);
    }

    private static void tNativeEnd(String what, long handle) {
        Trc.tTraceHandle("    << native call " + what, handle, null, null);
    }

    public static void TCpicNativeBegin(String what, long handle, String convid) {
        Trc.ab_rfctrc("    >> CPIC native call ");
        Trc.tTraceHandle(what, handle, convid, null);
    }

    public static void TCpicNativeBegin(String what, long handle, byte[] convid) {
        Trc.ab_rfctrc("    >> CPIC native call ");
        Trc.tTraceHandle(what, handle, Trc.convIDToString(convid), null);
    }

    public static void TCpicNativeEnd(String what, long handle, byte[] convid, String info) {
        Trc.ab_rfctrc("    << CPIC native call ");
        Trc.tTraceHandle(what, handle, Trc.convIDToString(convid), info);
    }

    public static void TCpicNativeEnd(String what, long handle, String convid, String info) {
        Trc.ab_rfctrc("    << CPIC native call ");
        Trc.tTraceHandle(what, handle, convid, info);
    }

    public static void TCpicNativeEnd(String what, long handle, byte[] convid, int rc) {
        Trc.TCpicNativeEnd(what, handle, convid, "rc: " + rc);
    }

    public static void TCpicNativeEnd(String what, long handle, String convid, int rc) {
        Trc.TCpicNativeEnd(what, handle, convid, "rc: " + rc);
    }

    public static void nativeBegin(String method) {
        Trc.ab_rfctrc(new StringBuilder(64).append(">> Begin native call ").append(method).append('\n').toString());
    }

    public static void nativeEnd(String method) {
        Trc.ab_rfctrc(new StringBuilder(64).append(">> End native call ").append(method).append('\n').toString());
    }

    private static void tTraceHandle(String what, long handle, String convid, String info) {
        StringBuilder text = new StringBuilder(100);
        text.append(what);
        text.append(" [");
        text.append(handle);
        text.append("] convid: ");
        text.append(convid);
        if (info != null) {
            text.append(' ');
            text.append(info);
        }
        text.append("  ");
        text.append(Trc.getTimeStampShort());
        text.append('\n');
        Trc.ab_rfctrc(text.toString());
    }

    public static void criticalTrace(long handle, String text) {
        Trc.criticalTrace(RfcIoControl.ab_rfccntl(handle), text);
    }

    public static synchronized void criticalTrace(String description, Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        pw.close();
        StringBuilder text = new StringBuilder(256);
        text.append("Exception thrown [").append(Trc.getTimeStamp());
        text.append("]:").append(description).append("\n");
        text.append(sw.toString()).append("\n");
        m_trc.criticalTrace(text.toString());
    }

    public static synchronized void criticalTrace(String description, Error er) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        er.printStackTrace(pw);
        pw.flush();
        pw.close();
        StringBuilder text = new StringBuilder(256);
        text.append("Error thrown [").append(Trc.getTimeStamp());
        text.append("]:").append(description).append("\n");
        text.append(sw.toString()).append("\n");
        m_trc.criticalTrace(text.toString());
    }

    private static synchronized void writeGeneralTrace(String traceType, RfcIoOpenCntl act_cntl, String txt) {
        StringBuilder text = new StringBuilder(128);
        text.append(traceType);
        text.append(": ");
        if (act_cntl != null) {
            text.append("[");
            text.append(act_cntl.hrfc);
            text.append("]");
        }
        text.append(" >");
        text.append(Trc.getTimeStamp());
        text.append("<    ");
        text.append(txt);
        text.append("\n");
        m_trc.criticalTrace(text.toString());
    }

    public static synchronized void generalInfo(RfcIoOpenCntl act_cntl, String txt) {
        Trc.writeGeneralTrace("Info", act_cntl, txt);
    }

    public static synchronized void criticalTrace(RfcIoOpenCntl act_cntl, String txt) {
        Trc.writeGeneralTrace("Error", act_cntl, txt);
    }

    public static synchronized void closeTrace() {
        m_trc.closeTrace();
    }

    public static String getTimeStamp() {
        return m_syncDateFormat.format(new Date());
    }

    public static String getTimeStampShort() {
        return m_syncDateFormatShort.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rfctrace(RfcIoOpenCntl act_cntl, String text, byte[] buffer, int blen) {
        String access_counter;
        if (act_cntl == null || !act_cntl.trace) {
            return;
        }
        StringBuilder tmp = new StringBuilder(256);
        Object object = act_cntl.access_counter_mutex;
        synchronized (object) {
            ++act_cntl.access_counter;
            access_counter = String.valueOf(act_cntl.access_counter);
        }
        tmp.append(">>>> [");
        tmp.append(act_cntl.hrfc);
        tmp.append("] ");
        tmp.append(act_cntl.name);
        tmp.append(' ');
        tmp.append(Trc.rfctype(act_cntl.type));
        tmp.append(" <ac: ");
        tmp.append(access_counter);
        tmp.append("> >>> ");
        tmp.append(text);
        tmp.append(" (");
        tmp.append(act_cntl.getCPICConversationID());
        tmp.append(")\n");
        Trc.ab_rfctrc(tmp.toString());
        Trc.rfc_hexdump(buffer, blen);
    }

    public static void TRfcApiStart(RfcIoOpenCntl cntl, String where) {
        Trc.ab_rfctrc("\n>>> " + where + " [" + (cntl == null ? 0L : cntl.hrfc) + "] >" + Trc.getTimeStamp() + "< ...\n\n");
    }

    public static String convIDToString(byte[] convid) {
        if (convid != null) {
            try {
                return convid[0] == 0 ? "<initial>" : new String(convid, "US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return "<empty>";
    }
}

