package com.haomostudio.so.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.CaseFormat;
import com.haomostudio.so.dao.*;
import com.haomostudio.so.po.*;
import com.haomostudio.so.vo.*;
import com.haomostudio.so.service.*;
import com.haomostudio.so.service.HmUtils.MybatisExampleHelper;
import org.apache.ibatis.binding.MapperProxy;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.haomo.plugin.Page;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.*;
import java.util.stream.Collectors;

/**
* Created by hxgqh on 2016/1/7.
*/
@Service("tAppCustomerService")
public class TAppCustomerServiceImpl implements TAppCustomerService{
    protected static final Logger LOG = LoggerFactory.getLogger(TAppCustomerServiceImpl.class);

    // 将所有的modelMapper注入
    @Autowired
    TAccessFieldLogMapper tAccessFieldLogMapper;

    @Autowired
    TAccessStoreLogMapper tAccessStoreLogMapper;

    @Autowired
    TActivityDetailMapper tActivityDetailMapper;

    @Autowired
    TAdminUserMapper tAdminUserMapper;

    @Autowired
    TAdminUserRoleMapper tAdminUserRoleMapper;

    @Autowired
    TAdminUserStoreMapper tAdminUserStoreMapper;

    @Autowired
    TAgreementMapper tAgreementMapper;

    @Autowired
    TAppCustomerMapper tAppCustomerMapper;

    @Autowired
    TAppCustomerLevelMapper tAppCustomerLevelMapper;

    @Autowired
    TAppLevelMapper tAppLevelMapper;

    @Autowired
    TAppVersionMapper tAppVersionMapper;

    @Autowired
    TBasePinyinMapper tBasePinyinMapper;

    @Autowired
    TCantonfairCheckerMapper tCantonfairCheckerMapper;

    @Autowired
    TCantonfairCheckerLogMapper tCantonfairCheckerLogMapper;

    @Autowired
    TCantonfairCheckerShopMapper tCantonfairCheckerShopMapper;

    @Autowired
    TCantonfairCouponMapper tCantonfairCouponMapper;

    @Autowired
    TCantonfairOauth2UserMapper tCantonfairOauth2UserMapper;

    @Autowired
    TCantonfairOrderMapper tCantonfairOrderMapper;

    @Autowired
    TCantonfairRedemptionMapper tCantonfairRedemptionMapper;

    @Autowired
    TCantonfairRuleMapper tCantonfairRuleMapper;

    @Autowired
    TCantonfairShopMapper tCantonfairShopMapper;

    @Autowired
    TClientMapper tClientMapper;

    @Autowired
    TCompanyMapper tCompanyMapper;

    @Autowired
    TCompanyAggrementRentMapper tCompanyAggrementRentMapper;

    @Autowired
    TCompanyMonthlyBillMapper tCompanyMonthlyBillMapper;

    @Autowired
    TCompanyMonthlyBillLogMapper tCompanyMonthlyBillLogMapper;

    @Autowired
    TCompanyMonthlyBillOrderMapper tCompanyMonthlyBillOrderMapper;

    @Autowired
    TConfigMapper tConfigMapper;

    @Autowired
    TConfigSettingMapper tConfigSettingMapper;

    @Autowired
    TConfigSettingEfficientMapper tConfigSettingEfficientMapper;

    @Autowired
    TConstantInfoMapper tConstantInfoMapper;

    @Autowired
    TCountryMapper tCountryMapper;

    @Autowired
    TCouponMapper tCouponMapper;

    @Autowired
    TCouponUserMapper tCouponUserMapper;

    @Autowired
    TCreditRegisterLogMapper tCreditRegisterLogMapper;

    @Autowired
    TCreditRewardMapper tCreditRewardMapper;

    @Autowired
    TCreditRuleMapper tCreditRuleMapper;

    @Autowired
    TCreditRuleDetailMapper tCreditRuleDetailMapper;

    @Autowired
    TCustomerMapper tCustomerMapper;

    @Autowired
    TCustomerCollectionMapper tCustomerCollectionMapper;

    @Autowired
    TCustomerJpushMapper tCustomerJpushMapper;

    @Autowired
    TCustomerPhoneMapper tCustomerPhoneMapper;

    @Autowired
    TCustomerSignMapper tCustomerSignMapper;

    @Autowired
    TCustomerTagMapper tCustomerTagMapper;

    @Autowired
    TCustomerWxappTagMapper tCustomerWxappTagMapper;

    @Autowired
    TEnterMapper tEnterMapper;

    @Autowired
    TEquipmentMapper tEquipmentMapper;

    @Autowired
    TFeedbackMapper tFeedbackMapper;

    @Autowired
    TFieldMapper tFieldMapper;

    @Autowired
    TFieldAppointmentTimeDayMapper tFieldAppointmentTimeDayMapper;

    @Autowired
    TFieldAppointmentTimeDaySnapshotMapper tFieldAppointmentTimeDaySnapshotMapper;

    @Autowired
    TFieldBusinessStatusChangeEventMapper tFieldBusinessStatusChangeEventMapper;

    @Autowired
    TFieldBusinessStatusForDateMapper tFieldBusinessStatusForDateMapper;

    @Autowired
    TFieldDateDetailMapper tFieldDateDetailMapper;

    @Autowired
    TFieldDateDetailHistoryMapper tFieldDateDetailHistoryMapper;

    @Autowired
    TFieldEquipmentMapper tFieldEquipmentMapper;

    @Autowired
    TFieldEquipmentSnapshotMapper tFieldEquipmentSnapshotMapper;

    @Autowired
    TFieldHourStationMapper tFieldHourStationMapper;

    @Autowired
    TFieldHourStationDateDetailMapper tFieldHourStationDateDetailMapper;

    @Autowired
    TFieldHourStationDateDetailHistoryMapper tFieldHourStationDateDetailHistoryMapper;

    @Autowired
    TFieldHourStationSnapshotMapper tFieldHourStationSnapshotMapper;

    @Autowired
    TFieldImgMapper tFieldImgMapper;

    @Autowired
    TFieldImgSnapshotMapper tFieldImgSnapshotMapper;

    @Autowired
    TFieldMeetingMapper tFieldMeetingMapper;

    @Autowired
    TFieldMeetingSnapshotMapper tFieldMeetingSnapshotMapper;

    @Autowired
    TFieldOfficeMapper tFieldOfficeMapper;

    @Autowired
    TFieldOfficeSnapshotMapper tFieldOfficeSnapshotMapper;

    @Autowired
    TFieldOtherMapper tFieldOtherMapper;

    @Autowired
    TFieldOtherDateDetailMapper tFieldOtherDateDetailMapper;

    @Autowired
    TFieldOtherDateDetailHistoryMapper tFieldOtherDateDetailHistoryMapper;

    @Autowired
    TFieldOtherSnapshotMapper tFieldOtherSnapshotMapper;

    @Autowired
    TFieldPauseMapper tFieldPauseMapper;

    @Autowired
    TFieldPauseSnapshotMapper tFieldPauseSnapshotMapper;

    @Autowired
    TFieldPaymentTypeMapper tFieldPaymentTypeMapper;

    @Autowired
    TFieldPaymentTypeSnapshotMapper tFieldPaymentTypeSnapshotMapper;

    @Autowired
    TFieldPriceMapper tFieldPriceMapper;

    @Autowired
    TFieldPriceSnapshotMapper tFieldPriceSnapshotMapper;

    @Autowired
    TFieldRevenueStatisticsMapper tFieldRevenueStatisticsMapper;

    @Autowired
    TFieldRoadshowHallMapper tFieldRoadshowHallMapper;

    @Autowired
    TFieldRoadshowHallDateDetailMapper tFieldRoadshowHallDateDetailMapper;

    @Autowired
    TFieldRoadshowHallDateDetailHistoryMapper tFieldRoadshowHallDateDetailHistoryMapper;

    @Autowired
    TFieldRoadshowHallSnapshotMapper tFieldRoadshowHallSnapshotMapper;

    @Autowired
    TFieldSnapshotMapper tFieldSnapshotMapper;

    @Autowired
    TFieldStationMapper tFieldStationMapper;

    @Autowired
    TFieldStationDetailMapper tFieldStationDetailMapper;

    @Autowired
    TFieldStationDetailHistoryMapper tFieldStationDetailHistoryMapper;

    @Autowired
    TFieldStationSnapshotMapper tFieldStationSnapshotMapper;

    @Autowired
    TFiledRevenueStatisticsMapper tFiledRevenueStatisticsMapper;

    @Autowired
    TFixAssertMapper tFixAssertMapper;

    @Autowired
    TFixAssertOperationMapper tFixAssertOperationMapper;

    @Autowired
    TGrantPointRecordMapper tGrantPointRecordMapper;

    @Autowired
    TGrantPointRuleMapper tGrantPointRuleMapper;

    @Autowired
    TGrantPointTimeMapper tGrantPointTimeMapper;

    @Autowired
    TGrantPointUserMapper tGrantPointUserMapper;

    @Autowired
    THotSearchMapper tHotSearchMapper;

    @Autowired
    TIndexBannerMapper tIndexBannerMapper;

    @Autowired
    TInformMapper tInformMapper;

    @Autowired
    TInfrastructureMapper tInfrastructureMapper;

    @Autowired
    TLockBaseMapper tLockBaseMapper;

    @Autowired
    TLockMaintainMapper tLockMaintainMapper;

    @Autowired
    TLockPstoneMaintainMapper tLockPstoneMaintainMapper;

    @Autowired
    TLockUseRecordMapper tLockUseRecordMapper;

    @Autowired
    TMessageCenterMapper tMessageCenterMapper;

    @Autowired
    TMultimediaMapper tMultimediaMapper;

    @Autowired
    TNetcaseInnovationTalentContestMapper tNetcaseInnovationTalentContestMapper;

    @Autowired
    TNoticeMapper tNoticeMapper;

    @Autowired
    TOperationLogMapper tOperationLogMapper;

    @Autowired
    TOrderMapper tOrderMapper;

    @Autowired
    TOrderContactMapper tOrderContactMapper;

    @Autowired
    TOrderCouponUserMapper tOrderCouponUserMapper;

    @Autowired
    TOrderFieldMapper tOrderFieldMapper;

    @Autowired
    TOrderHourStationMapper tOrderHourStationMapper;

    @Autowired
    TOrderLogMapper tOrderLogMapper;

    @Autowired
    TOrderMeetingPriceMapper tOrderMeetingPriceMapper;

    @Autowired
    TOrderOtherMapper tOrderOtherMapper;

    @Autowired
    TOrderOtherPriceMapper tOrderOtherPriceMapper;

    @Autowired
    TOrderPayMapper tOrderPayMapper;

    @Autowired
    TOrderPayAdjustmentMapper tOrderPayAdjustmentMapper;

    @Autowired
    TOrderRefundMapper tOrderRefundMapper;

    @Autowired
    TOrderRefundLogMapper tOrderRefundLogMapper;

    @Autowired
    TOrderRoadshowHallMapper tOrderRoadshowHallMapper;

    @Autowired
    TOrderRoadshowHallPriceMapper tOrderRoadshowHallPriceMapper;

    @Autowired
    TOrderStationMapper tOrderStationMapper;

    @Autowired
    TOrderStationPriceMapper tOrderStationPriceMapper;

    @Autowired
    TOrderSummaryMapper tOrderSummaryMapper;

    @Autowired
    TOuth2AdminUserMapper tOuth2AdminUserMapper;

    @Autowired
    TOuth2UserMapper tOuth2UserMapper;

    @Autowired
    TPaymentTypeMapper tPaymentTypeMapper;

    @Autowired
    TPermisMapper tPermisMapper;

    @Autowired
    TPermisModuleMapper tPermisModuleMapper;

    @Autowired
    TPermisResourceMapper tPermisResourceMapper;

    @Autowired
    TPlatformActivityMapper tPlatformActivityMapper;

    @Autowired
    TPlatformActivityGiftCouponMapper tPlatformActivityGiftCouponMapper;

    @Autowired
    TPlatformActivityGiftCustomerMapper tPlatformActivityGiftCustomerMapper;

    @Autowired
    TPlatformActivityGiftRedpacketMapper tPlatformActivityGiftRedpacketMapper;

    @Autowired
    TPlatformActivityLotteryMapper tPlatformActivityLotteryMapper;

    @Autowired
    TPlatformActivityLotteryLogMapper tPlatformActivityLotteryLogMapper;

    @Autowired
    TPlatformActivityShowConfigMapper tPlatformActivityShowConfigMapper;

    @Autowired
    TPlatformActivityStatisticsMapper tPlatformActivityStatisticsMapper;

    @Autowired
    TPlatformActivityTimeMapper tPlatformActivityTimeMapper;

    @Autowired
    TPlatformCashCouponMapper tPlatformCashCouponMapper;

    @Autowired
    TPlatformCashCouponFieldTypeMapper tPlatformCashCouponFieldTypeMapper;

    @Autowired
    TPlatformCashCouponStoreMapper tPlatformCashCouponStoreMapper;

    @Autowired
    TPlatformCouponMapper tPlatformCouponMapper;

    @Autowired
    TPlatformCouponBannerCustomerMapper tPlatformCouponBannerCustomerMapper;

    @Autowired
    TPlatformCouponCustomerMapper tPlatformCouponCustomerMapper;

    @Autowired
    TPlatformCouponReceiveMapper tPlatformCouponReceiveMapper;

    @Autowired
    TPlatformCouponReceiveConditionMapper tPlatformCouponReceiveConditionMapper;

    @Autowired
    TPlatformCouponReceiveManualMapper tPlatformCouponReceiveManualMapper;

    @Autowired
    TPlatformCouponSnapshotMapper tPlatformCouponSnapshotMapper;

    @Autowired
    TPlatformFeedbackMapper tPlatformFeedbackMapper;

    @Autowired
    TPlatformFeedbackImgsMapper tPlatformFeedbackImgsMapper;

    @Autowired
    TPlatformFieldMapper tPlatformFieldMapper;

    @Autowired
    TPlatformFieldDiscountMapper tPlatformFieldDiscountMapper;

    @Autowired
    TPlatformGiftCouponMapper tPlatformGiftCouponMapper;

    @Autowired
    TPlatformGiftCouponVerifyStationMapper tPlatformGiftCouponVerifyStationMapper;

    @Autowired
    TPlatformHourCouponMapper tPlatformHourCouponMapper;

    @Autowired
    TPlatformHourCouponFieldTypeMapper tPlatformHourCouponFieldTypeMapper;

    @Autowired
    TPlatformHourCouponStoreMapper tPlatformHourCouponStoreMapper;

    @Autowired
    TPlatformInviteMapper tPlatformInviteMapper;

    @Autowired
    TPlatformOrderMapper tPlatformOrderMapper;

    @Autowired
    TPlatformOrderContactMapper tPlatformOrderContactMapper;

    @Autowired
    TPlatformOrderCouponMapper tPlatformOrderCouponMapper;

    @Autowired
    TPlatformOrderFieldMapper tPlatformOrderFieldMapper;

    @Autowired
    TPlatformOrderHourStationMapper tPlatformOrderHourStationMapper;

    @Autowired
    TPlatformOrderHourStationPriceMapper tPlatformOrderHourStationPriceMapper;

    @Autowired
    TPlatformOrderLogMapper tPlatformOrderLogMapper;

    @Autowired
    TPlatformOrderMeetingPriceMapper tPlatformOrderMeetingPriceMapper;

    @Autowired
    TPlatformOrderOtherMapper tPlatformOrderOtherMapper;

    @Autowired
    TPlatformOrderOtherPriceMapper tPlatformOrderOtherPriceMapper;

    @Autowired
    TPlatformOrderPayMapper tPlatformOrderPayMapper;

    @Autowired
    TPlatformOrderRefundMapper tPlatformOrderRefundMapper;

    @Autowired
    TPlatformOrderRefundLogMapper tPlatformOrderRefundLogMapper;

    @Autowired
    TPlatformOrderRoadshowHallMapper tPlatformOrderRoadshowHallMapper;

    @Autowired
    TPlatformOrderRoadshowHallPriceMapper tPlatformOrderRoadshowHallPriceMapper;

    @Autowired
    TPlatformOrderStationMapper tPlatformOrderStationMapper;

    @Autowired
    TPlatformOrderStationPriceMapper tPlatformOrderStationPriceMapper;

    @Autowired
    TPlatformOrderStatisticsMapper tPlatformOrderStatisticsMapper;

    @Autowired
    TPlatformRedpacketMapper tPlatformRedpacketMapper;

    @Autowired
    TPlatformSelectionMapper tPlatformSelectionMapper;

    @Autowired
    TPlatformSelectionFieldMapper tPlatformSelectionFieldMapper;

    @Autowired
    TPlatformServiceMapper tPlatformServiceMapper;

    @Autowired
    TPlatformServiceOrderMapper tPlatformServiceOrderMapper;

    @Autowired
    TPlatformServiceProviderMapper tPlatformServiceProviderMapper;

    @Autowired
    TPlatformServiceTypeMapper tPlatformServiceTypeMapper;

    @Autowired
    TPlatformStatisticsFieldMapper tPlatformStatisticsFieldMapper;

    @Autowired
    TPlatformVerifierMapper tPlatformVerifierMapper;

    @Autowired
    TPlatformVerifierCouponCustomerMapper tPlatformVerifierCouponCustomerMapper;

    @Autowired
    TPlatformVerifierWxMpCustomerMapper tPlatformVerifierWxMpCustomerMapper;

    @Autowired
    TPlatformVerifyRecordMapper tPlatformVerifyRecordMapper;

    @Autowired
    TPlatformVerifyStationMapper tPlatformVerifyStationMapper;

    @Autowired
    TPlatformWeixinPayNotifyMapper tPlatformWeixinPayNotifyMapper;

    @Autowired
    TPlatformWeixinPayRefundReqMapper tPlatformWeixinPayRefundReqMapper;

    @Autowired
    TPlatformWeixinPayRefundRespMapper tPlatformWeixinPayRefundRespMapper;

    @Autowired
    TPlatformWeixinPayRelationNoMapper tPlatformWeixinPayRelationNoMapper;

    @Autowired
    TPlatformWeixinPayUnifiedOrderReqMapper tPlatformWeixinPayUnifiedOrderReqMapper;

    @Autowired
    TPlatformWeixinPayUnifiedOrderRespMapper tPlatformWeixinPayUnifiedOrderRespMapper;

    @Autowired
    TPointRefurnRecordMapper tPointRefurnRecordMapper;

    @Autowired
    TPointUseRecordMapper tPointUseRecordMapper;

    @Autowired
    TPointUseRecordDetailMapper tPointUseRecordDetailMapper;

    @Autowired
    TProductMapper tProductMapper;

    @Autowired
    TProfessionMapper tProfessionMapper;

    @Autowired
    TProfessionTagMapper tProfessionTagMapper;

    @Autowired
    TPushPermisMapper tPushPermisMapper;

    @Autowired
    TRechargePointRecordMapper tRechargePointRecordMapper;

    @Autowired
    TRegionMapper tRegionMapper;

    @Autowired
    TRegionInfoMapper tRegionInfoMapper;

    @Autowired
    TRepairMapper tRepairMapper;

    @Autowired
    TResourceMapper tResourceMapper;

    @Autowired
    TRoleMapper tRoleMapper;

    @Autowired
    TRolePermisMapper tRolePermisMapper;

    @Autowired
    TRolePushPermisMapper tRolePushPermisMapper;

    @Autowired
    TSignRecordMapper tSignRecordMapper;

    @Autowired
    TSignRecordLogMapper tSignRecordLogMapper;

    @Autowired
    TSmsCountryMapper tSmsCountryMapper;

    @Autowired
    TSpaceMapper tSpaceMapper;

    @Autowired
    TSpaceKeeperMapper tSpaceKeeperMapper;

    @Autowired
    TSpaceKeeperCompanyMapper tSpaceKeeperCompanyMapper;

    @Autowired
    TSpaceKeeperOrderMapper tSpaceKeeperOrderMapper;

    @Autowired
    TSpaceServiceTypeMapper tSpaceServiceTypeMapper;

    @Autowired
    TSpaceWeixinMapper tSpaceWeixinMapper;

    @Autowired
    TSpaceWeixinPayMapper tSpaceWeixinPayMapper;

    @Autowired
    TStaffMapper tStaffMapper;

    @Autowired
    TStaffCodeMapper tStaffCodeMapper;

    @Autowired
    TStoreMapper tStoreMapper;

    @Autowired
    TStoreFeaturesMapper tStoreFeaturesMapper;

    @Autowired
    TStoreImgMapper tStoreImgMapper;

    @Autowired
    TStoreImgSnapshotMapper tStoreImgSnapshotMapper;

    @Autowired
    TStoreInfrastructureMapper tStoreInfrastructureMapper;

    @Autowired
    TStoreInfrastructureSnapshotMapper tStoreInfrastructureSnapshotMapper;

    @Autowired
    TStoreSnapshotMapper tStoreSnapshotMapper;

    @Autowired
    TStoreStarMapper tStoreStarMapper;

    @Autowired
    TSupervisorMapper tSupervisorMapper;

    @Autowired
    TTabletUserMapper tTabletUserMapper;

    @Autowired
    TTabletVersionMapper tTabletVersionMapper;

    @Autowired
    TTagMapper tTagMapper;

    @Autowired
    TTeamMapper tTeamMapper;

    @Autowired
    TTeamSnapshotMapper tTeamSnapshotMapper;

    @Autowired
    TUnlockRecordMapper tUnlockRecordMapper;

    @Autowired
    TUserMapper tUserMapper;

    @Autowired
    TUserActivityMapper tUserActivityMapper;

    @Autowired
    TUserCreditMapper tUserCreditMapper;

    @Autowired
    TUserCreditLogMapper tUserCreditLogMapper;

    @Autowired
    TUserForeverPointMapper tUserForeverPointMapper;

    @Autowired
    TUserPointCardMapper tUserPointCardMapper;

    @Autowired
    TUserPointLogMapper tUserPointLogMapper;

    @Autowired
    TValueAddServiceMapper tValueAddServiceMapper;

    @Autowired
    TValueAddServiceOrderMapper tValueAddServiceOrderMapper;

    @Autowired
    TValueAddServiceProviderMapper tValueAddServiceProviderMapper;

    @Autowired
    TValueAddServiceTypeMapper tValueAddServiceTypeMapper;

    @Autowired
    TVasSpaceTypeMapper tVasSpaceTypeMapper;

    @Autowired
    TVisitReservationMapper tVisitReservationMapper;

    @Autowired
    TWeixinMessageTemplateMapper tWeixinMessageTemplateMapper;

    @Autowired
    TWeixinPayNotifyMapper tWeixinPayNotifyMapper;

    @Autowired
    TWeixinPayRefundReqMapper tWeixinPayRefundReqMapper;

    @Autowired
    TWeixinPayRefundRespMapper tWeixinPayRefundRespMapper;

    @Autowired
    TWeixinPayRelationNoMapper tWeixinPayRelationNoMapper;

    @Autowired
    TWeixinPayUnifiedOrderReqMapper tWeixinPayUnifiedOrderReqMapper;

    @Autowired
    TWeixinPayUnifiedOrderRespMapper tWeixinPayUnifiedOrderRespMapper;

    @Autowired
    TWxappCustomerMapper tWxappCustomerMapper;

    @Autowired
    TWxappCustomerBindChangeMapper tWxappCustomerBindChangeMapper;

    @Autowired
    TWxappRegisterwayMapper tWxappRegisterwayMapper;

    @Autowired
    TWxappTagMapper tWxappTagMapper;

    @Autowired
    TWxMpCustomerMapper tWxMpCustomerMapper;


    @Override
    public int create(TAppCustomer item) {
        return tAppCustomerMapper.insertSelective(item);
    }

    @Override
    public int delete(Integer id) {
        return tAppCustomerMapper.deleteByPrimaryKey(id);
    }

    @Override
    public int update(TAppCustomer item) {
        return tAppCustomerMapper.updateByPrimaryKeySelective(item);
    }

    @Override
    public TAppCustomer get(Integer id) {
        return tAppCustomerMapper.selectByPrimaryKey(id);
    }

    private void assignRelates(String relates, List<TAppCustomerVO> modelVOList){
        JSONObject relatesObj = JSON.parseObject(relates);
        for (String table: relatesObj.keySet()) {
            for(TAppCustomerVO modelVO: modelVOList){
                List<String> joinCols = (List<String>) relatesObj.get(table);
                TAppCustomerExample tableExampleObj = new TAppCustomerExample();
                Map<String, Map<String, Map<String, Object>>> tableFilters = new HashMap<>();
                for(String joinCol: joinCols){
                    Map<String, Map<String, Object>> column = new HashMap<>();
                    Method m = MybatisExampleHelper.getMethod(modelVO.getSuperior(),
                        "get"+ CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, joinCol));
                    Map<String, Object> condition = new HashMap();
                    try{
                        if (m.invoke(modelVO.getSuperior())==null){
                            return;
                        }
                        condition.put("equalTo", (String)JSON.parse(JSON.toJSONString(m.invoke(modelVO.getSuperior()))));
                        column.put(joinCol, condition);
                        tableFilters.put(table, column);
                    }
                    catch (InvocationTargetException e) {
                        LOG.error(e.toString());
                    }
                    catch (IllegalAccessException e){
                        LOG.error(e.toString());
                    }
                }

                MybatisExampleHelper.assignWhereClause(tableExampleObj, tableExampleObj.or(), table, JSON.toJSONString(tableFilters));
                tableExampleObj.setOrderByClause(MybatisExampleHelper.createOrderClause("id", "asc"));

                // 获取到关联表的列表
                try{
                    Field mapperFieldDef = this.getClass()
                    .getDeclaredField(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, table)+"Mapper");
                    mapperFieldDef.setAccessible(true);
                    Object fieldValue = mapperFieldDef.get(this);
                    MapperProxy proxy = (MapperProxy) Proxy.getInvocationHandler(fieldValue);
                    Method sbewr = MybatisExampleHelper.getMethod(fieldValue, "selectByExample");
                    Page page = new Page(0,1000);
                    tableExampleObj.setPage(page);
                    Object[] args = new Object[]{tableExampleObj};
                    modelVO.getRelates().put(table, (List<Object>)(proxy.invoke(proxy, sbewr, args)));
                }
                catch (Throwable e){
                    LOG.error(e.toString());
                }
            }
        }
    }

    @Override
    public List<TAppCustomer> getListWithPagingAndFilter(
        Integer pageNo, Integer pageSize,
        String sortItem, String sortOrder,
        String filters){
        TAppCustomerExample exampleObj = new TAppCustomerExample();
        Page page = new Page((pageNo - 1) * pageSize, pageSize);
        exampleObj.setPage(page);
        MybatisExampleHelper.assignWhereClause(exampleObj, exampleObj.or(), "TAppCustomer", filters);
        exampleObj.setOrderByClause(MybatisExampleHelper.createOrderClause(sortItem, sortOrder));

        return tAppCustomerMapper.selectByExample(exampleObj);
    }

    @Override
    public Object getListWithPagingAndFilter(
        Integer pageNo, Integer pageSize,
        String sortItem, String sortOrder,
        String filters, String includes, String refers, String relates){
        TAppCustomerExample exampleObj = new TAppCustomerExample();
        Page page = new Page((pageNo - 1) * pageSize, pageSize);
        exampleObj.setPage(page);
        MybatisExampleHelper.assignWhereClause(exampleObj, exampleObj.or(), "TAppCustomer", filters);
        exampleObj.setOrderByClause(MybatisExampleHelper.createOrderClause(sortItem, sortOrder));

        List<TAppCustomer> modelList = tAppCustomerMapper.selectByExample(exampleObj);

        List<TAppCustomerVO> modelVOList = modelList.stream().map(model -> new TAppCustomerVO(model)).collect(Collectors.toList());

         // 处理includes的外链字段  处理refers的关联表
        if((includes != null || refers != null)&& modelList.size() > 0){
            //对Vo层数据循环处理外链表数据
            modelVOList.stream().forEach(status->{
                if (includes != null){
                    this.assignIncludes(includes,status);
                }
                if (refers != null){
                    this.assignRefers(refers,status);
                }
            });
        }

        // 处理join的关联表
        if(relates != null && modelList.size() > 0){
            this.assignRelates(relates, modelVOList);
        }

        if(includes == null && refers == null && relates == null){
            return modelList;
        }
        else{
            return modelVOList;
        }
    }

    @Override
    public Long countListWithPagingAndFilter(String filters){
        TAppCustomerExample exampleObj = new TAppCustomerExample();
        MybatisExampleHelper.assignWhereClause(exampleObj, exampleObj.or(), "TAppCustomer", filters);
        return tAppCustomerMapper.countByExample(exampleObj);
    }
    
    private void assignIncludes(String includes, TAppCustomerVO status){
            JSONObject includesObj = JSON.parseObject(includes);
            //定义容器存储所有外链表数据
            Map<String,Object> map = new HashMap();
            // 循环解析每一个键值对
            if (includesObj!=null && includesObj.keySet().size() >0){
                includesObj.keySet().stream().forEach(table->{
                    //每一个key都是一个po实体类名
                    Object className = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, table);
                    JSONObject jsonObject = includesObj.getJSONObject(
                            CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, table));
                    //对内层的includes数据进行解析
                    JSONArray columnCondition = jsonObject.getJSONArray("includes");
                    if (columnCondition != null && columnCondition.toArray().length >0){
                        //循环数组
                        Arrays.stream(columnCondition.toArray()).forEach(obj -> {
                            //反射机制将要执行的方法名
                            String ffName = "get"+CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, obj.toString());
                            //获取Method的对象
                            Method m = MybatisExampleHelper.getMethod(status.getSuperior(), ffName);
                            MybatisExampleHelper.dealSearchIncludes(m,status.getSuperior(),
                                    className,map,table,this.getClass().getPackage().getName());
    
                        });
                    }
                });
            }
            status.setIncludes(map);
        }
    
        private void assignRefers(String refers, TAppCustomerVO status){
            //解析includes字符串为JSONObject
            JSONObject refersObj = JSON.parseObject(refers);
            //定义容器存储所有外链表数据
            Map<String,List<Object>> map = new HashMap();
            if (refersObj!=null && refersObj.keySet().size() > 0){
                // 循环解析每一个键值对
                refersObj.keySet().stream().forEach(table -> {
                    //每一个key都是一个po实体类名
                    JSONObject jsonObject = refersObj.getJSONObject(
                            CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, table));
                    //对内层的includes数据进行解析
                    JSONArray columnCondition = jsonObject.getJSONArray("includes");
                    if (columnCondition != null && columnCondition.toArray().length > 0){
                        //循环数组
                        Arrays.stream(columnCondition.toArray()).forEach(obj -> {
                            MybatisExampleHelper.dealSearchRefers(status.getSuperior().getId(),
                                    table,map,obj,CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, table),
                                    this.getClass().getPackage().getName());
                        });
                    }
                });
            }
    
            status.setRefers(map);
        }
}
