package com.bril.webfilemodule.weex;

import android.content.Intent;

import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.WXModule;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Xinghx on 2018/6/26 0026.
 */

public class NetFileChooseModule extends WXModule {


    private INetFileChoose netFileChoose;

    @JSMethod
    public void chooseNetFile(String userId, String moduleName, boolean isNextCloud, final JSCallback jsCallback) {
        netFileChoose = new NetFileChoose(mWXSDKInstance.getContext());
        final Map<String, Object> ret = new HashMap<>();
        netFileChoose.onChooseFile(userId, moduleName, isNextCloud, new INetFileChoose.OnFileNetChooseListener() {
            @Override
            public void onNetFileChoose(String fileId, String fileName, String filePath) {
                ret.put("fileId", fileId);
                ret.put("fileName", fileName);
                ret.put("filePath", filePath);
                jsCallback.invoke(ret);
            }

            @Override
            public void onNextCloudFileChoose(String absolutePath, String filePath) {
                ret.put("fileId", absolutePath);
                ret.put("filePath", filePath);
                jsCallback.invoke(ret);
            }
        });


    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        netFileChoose.notifyActivityResult(requestCode, resultCode, data);
    }
}
