package com.bril.webfilemodule.weex;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;

import com.bril.webfile.FileActivity;

/**
 * Created by Xinghx on 2018/6/26 0026.
 */

public class NetFileChoose implements INetFileChoose{
    public static final int FILE_CHOOSE = 0x012;
    public static final int FILE_NEXTCLOUD= 0x013;
    private Context mContext;
    private OnFileNetChooseListener mCallback;

    public NetFileChoose(Context mContext) {
        this.mContext = mContext;
    }

    @Override
    public void notifyActivityResult(int requestCode, int resultCode, Intent data) {
        if (data != null) {
            switch (requestCode) {
                case FILE_CHOOSE:
                    String filePath = data.getStringExtra("filePath");
                    String fileName = data.getStringExtra("fileName");
                    String fileId = data.getStringExtra("fileId");
                    mCallback.onNetFileChoose(fileId,fileName,filePath);
                    break;
                case FILE_NEXTCLOUD:
                    String absolutePath = data.getStringExtra("absolutePath");
                    String filePaths = data.getStringExtra("filePaths");
                    mCallback.onNextCloudFileChoose(absolutePath, filePaths);
                    break;
            }
        }
    }

    @Override
    public void onChooseFile(String userId,String moduleName,boolean isNextCloud,OnFileNetChooseListener listener) {
        mCallback = listener;
        Intent intent = new Intent(mContext, FileActivity.class);
        intent.putExtra("userId", userId);
        intent.putExtra("moduleName", moduleName);
        if (isNextCloud) {
            ((Activity) mContext).startActivityForResult(intent, FILE_NEXTCLOUD);
        } else {
            ((Activity) mContext).startActivityForResult(intent, FILE_CHOOSE);
        }
    }
}
