package com.bril.webfilemodule;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;

import com.bril.webfile.FileActivity;

public class MainActivity extends AppCompatActivity {
    public static final int FILE_CHOOSE = 0x012;
    public static final int FILE_NEXTCLOUD= 0x013;
    String notification = "";
    String conferenceManagement = "";
    private static final String TAG = "MainActivity";
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
    }

    public void voice(View view) {
        Intent intent = new Intent(this, FileActivity.class);
        intent.putExtra("userId", "716");
        intent.putExtra("moduleName", "speechRecognition");
        startActivityForResult(intent,FILE_CHOOSE);
    }

    public void notification(View view) {
        Intent intent = new Intent(this, FileActivity.class);
        intent.putExtra("userId", "716");
        intent.putExtra("moduleName", "notification");
        startActivityForResult(intent,FILE_CHOOSE);
    }

    public void conferenceManagement(View view) {
        Intent intent = new Intent(this, FileActivity.class);
        intent.putExtra("userId", "716");
        intent.putExtra("moduleName", "conferenceManagement");
        startActivityForResult(intent,FILE_CHOOSE);
    }

    public void documentFlow(View view) {
        Intent intent = new Intent(this, FileActivity.class);
        intent.putExtra("userId", "716");
        intent.putExtra("moduleName", "documentFlow");
        startActivityForResult(intent,FILE_CHOOSE);
    }

    public void issueCollection(View view) {
        Intent intent = new Intent(this, FileActivity.class);
        intent.putExtra("userId", "716");
        intent.putExtra("moduleName", "issueCollection");
        startActivityForResult(intent,FILE_CHOOSE);
    }

    public void documentGeneration(View view) {
        Intent intent = new Intent(this, FileActivity.class);
        intent.putExtra("userId", "716");
        intent.putExtra("moduleName", "documentGeneration");
        startActivityForResult(intent,FILE_CHOOSE);
    }

    public void ocrRecognition(View view) {
        Intent intent = new Intent(this, FileActivity.class);
        intent.putExtra("userId", "716");
        intent.putExtra("moduleName", "ocrRecognition");
        startActivityForResult(intent,FILE_CHOOSE);
    }

    public void documentScan(View view) {
        Intent intent = new Intent(this, FileActivity.class);
        intent.putExtra("userId", "716");
        intent.putExtra("moduleName", "documentScan");
        startActivityForResult(intent,FILE_CHOOSE);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (data != null) {
            switch (requestCode) {
                case FILE_CHOOSE:
                    String filePath = data.getStringExtra("filePath");
                    String fileName = data.getStringExtra("fileName");
                    String fileId = data.getStringExtra("fileId");
                    Log.d(TAG, "fileID:" + fileId + " filePath:" + filePath + " fileName:" + fileName);
                    break;
                case FILE_NEXTCLOUD:
                    String absolutePath = data.getStringExtra("absolutePath");
                    String filePaths = data.getStringExtra("filePaths");
                    Log.d(TAG, "onActivityResult: " + absolutePath + "   " + filePaths);
                    break;
            }
        }
    }

    public void shareFolder(View view) {
        Intent intent = new Intent(this, FileActivity.class);
        intent.putExtra("userId", "716");
        intent.putExtra("moduleName", "shareFolder");
        startActivityForResult(intent,FILE_NEXTCLOUD);
    }

    public void myselfNetDisk(View view) {
        Intent intent = new Intent(this, FileActivity.class);
        intent.putExtra("userId", "716");
        intent.putExtra("moduleName", "myselfNetDisk");
        startActivityForResult(intent,FILE_NEXTCLOUD);
    }

    public void documentManager(View view) {
        Intent intent = new Intent(this, FileActivity.class);
        intent.putExtra("userId", "716");
        intent.putExtra("moduleName", "documentManager");
        startActivityForResult(intent,FILE_NEXTCLOUD);
    }
}
