package me.texy.treeview.binder;

import android.view.View;

import me.texy.treeview.base.BaseNodeViewBinder;
import me.texy.treeview.base.BaseNodeViewFactory;


/**
 * Created by zxy on 17/4/23.
 */

public class MyNodeViewFactory extends BaseNodeViewFactory {
    private int checkBoxVisible = View.VISIBLE;

    public MyNodeViewFactory() {

    }

    public MyNodeViewFactory(int checkBoxVisible) {
        this.checkBoxVisible = checkBoxVisible;
    }

    @Override
    public BaseNodeViewBinder getNodeViewBinder(View view, int level) {
        switch (level) {
            case 0:
                return new FirstLevelNodeViewBinder(view, checkBoxVisible);
            case 1:
                return new SecondLevelNodeViewBinder(view, checkBoxVisible);
            case 2:
                return new ThirdLevelNodeViewBinder(view, checkBoxVisible);
            case 3:
                return new ThirdLevelNodeViewBinder(view, checkBoxVisible);
            case 4:
                return new ThirdLevelNodeViewBinder(view, checkBoxVisible);
            default:
                return new FourthLevelNodeViewBinder(view, checkBoxVisible);
        }
    }
}
