package me.texy.treeview.binder;

import android.view.View;
import android.widget.CheckBox;
import android.widget.TextView;

import me.texy.treeview.R;
import me.texy.treeview.TreeNode;
import me.texy.treeview.base.CheckableNodeViewBinder;

/**
 * Created by zxy on 17/4/23.
 */

public class FourthLevelNodeViewBinder extends CheckableNodeViewBinder {

    TextView textView;
    private int checkBoxVisible;
    CheckBox checkBox;

    public FourthLevelNodeViewBinder(View itemView, int checkBoxVisible) {
        super(itemView);
        this.checkBoxVisible = checkBoxVisible;
        checkBox = (CheckBox) itemView.findViewById(R.id.checkBox);
        textView = (TextView) itemView.findViewById(R.id.node_name_view);
    }

    @Override
    public int getCheckableViewId() {
        return R.id.checkBox;
    }

    @Override
    public int getLayoutId() {
        return R.layout.item_fourth_level;
    }

    @Override
    public void bindView(TreeNode treeNode) {
        checkBox.setVisibility(checkBoxVisible);
        textView.setText(treeNode.getValue().toString());
    }
}
