/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.image;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Movie;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import org.xutils.common.util.LogUtil;

public class GifDrawable
extends Drawable
implements Runnable,
Animatable {
    private int byteCount;
    private volatile boolean running;
    private final Movie movie;
    private final int duration;
    private final long begin = SystemClock.uptimeMillis();

    public GifDrawable(Movie movie, int byteCount) {
        this.movie = movie;
        this.byteCount = byteCount;
        this.duration = movie.duration();
    }

    public Movie getMovie() {
        return this.movie;
    }

    public int getByteCount() {
        if (this.byteCount == 0) {
            this.byteCount = this.movie.width() * this.movie.height() * 3 * 5;
        }
        return this.byteCount;
    }

    public void draw(Canvas canvas) {
        try {
            int time = this.duration > 0 ? (int)(SystemClock.uptimeMillis() - this.begin) % this.duration : 0;
            this.movie.setTime(time);
            this.movie.draw(canvas, 0.0f, 0.0f);
            this.start();
        }
        catch (Throwable ex) {
            LogUtil.e(ex.getMessage(), ex);
        }
    }

    public void start() {
        if (!this.isRunning()) {
            this.running = true;
            this.run();
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.unscheduleSelf(this);
        }
    }

    public boolean isRunning() {
        return this.running && this.duration > 0;
    }

    @Override
    public void run() {
        if (this.duration > 0) {
            this.invalidateSelf();
            this.scheduleSelf(this, SystemClock.uptimeMillis() + 300L);
        }
    }

    public void setAlpha(int alpha) {
    }

    public int getIntrinsicWidth() {
        return this.movie.width();
    }

    public int getIntrinsicHeight() {
        return this.movie.height();
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return this.movie.isOpaque() ? -1 : -3;
    }
}

