/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http.request;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.xutils.common.util.LogUtil;
import org.xutils.http.ProgressHandler;
import org.xutils.http.RequestParams;
import org.xutils.http.loader.Loader;
import org.xutils.http.loader.LoaderFactory;
import org.xutils.x;

public abstract class UriRequest
implements Closeable {
    protected final String queryUrl;
    protected final RequestParams params;
    protected final Loader<?> loader;
    protected ClassLoader callingClassLoader = null;
    protected ProgressHandler progressHandler = null;

    UriRequest(RequestParams params, Type loadType) throws Throwable {
        this.params = params;
        this.queryUrl = this.buildQueryUrl(params);
        this.loader = LoaderFactory.getLoader(loadType, params);
    }

    protected String buildQueryUrl(RequestParams params) {
        return params.getUri();
    }

    public void setProgressHandler(ProgressHandler progressHandler) {
        this.progressHandler = progressHandler;
        this.loader.setProgressHandler(progressHandler);
    }

    public void setCallingClassLoader(ClassLoader callingClassLoader) {
        this.callingClassLoader = callingClassLoader;
    }

    public RequestParams getParams() {
        return this.params;
    }

    public String getRequestUri() {
        return this.queryUrl;
    }

    public abstract void sendRequest() throws IOException;

    public abstract boolean isLoading();

    public abstract String getCacheKey();

    public Object loadResult() throws Throwable {
        return this.loader.load(this);
    }

    public abstract Object loadResultFromCache() throws Throwable;

    public abstract void clearCacheHeader();

    public void save2Cache() {
        x.task().run(new Runnable(){

            @Override
            public void run() {
                try {
                    UriRequest.this.loader.save2Cache(UriRequest.this);
                }
                catch (Throwable ex) {
                    LogUtil.e(ex.getMessage(), ex);
                }
            }
        });
    }

    public abstract InputStream getInputStream() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract long getContentLength();

    public abstract int getResponseCode() throws IOException;

    public abstract String getResponseMessage() throws IOException;

    public abstract long getExpiration();

    public abstract long getLastModified();

    public abstract String getETag();

    public abstract String getResponseHeader(String var1);

    public abstract Map<String, List<String>> getResponseHeaders();

    public abstract long getHeaderFieldDate(String var1, long var2);

    public String toString() {
        return this.getRequestUri();
    }
}

