/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http.request;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.xutils.cache.DiskCacheEntity;
import org.xutils.cache.LruDiskCache;
import org.xutils.common.util.IOUtil;
import org.xutils.common.util.LogUtil;
import org.xutils.http.RequestParams;
import org.xutils.http.request.UriRequest;
import org.xutils.x;

public class AssetsRequest
extends UriRequest {
    private long contentLength = 0L;
    private InputStream inputStream;

    public AssetsRequest(RequestParams params, Type loadType) throws Throwable {
        super(params, loadType);
    }

    @Override
    public void sendRequest() throws IOException {
    }

    @Override
    public boolean isLoading() {
        return true;
    }

    @Override
    public String getCacheKey() {
        return this.queryUrl;
    }

    @Override
    public Object loadResult() throws Throwable {
        return this.loader.load(this);
    }

    @Override
    public Object loadResultFromCache() throws Throwable {
        DiskCacheEntity cacheEntity = LruDiskCache.getDiskCache(this.params.getCacheDirName()).setMaxSize(this.params.getCacheSize()).get(this.getCacheKey());
        if (cacheEntity != null) {
            Date lastModifiedDate = cacheEntity.getLastModify();
            if (lastModifiedDate == null || lastModifiedDate.getTime() < this.getAssetsLastModified()) {
                return null;
            }
            return this.loader.loadFromCache(cacheEntity);
        }
        return null;
    }

    @Override
    public void clearCacheHeader() {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null && this.callingClassLoader != null) {
            String assetsPath = "assets/" + this.queryUrl.substring("assets://".length());
            this.inputStream = this.callingClassLoader.getResourceAsStream(assetsPath);
            this.contentLength = this.inputStream.available();
        }
        return this.inputStream;
    }

    @Override
    public void close() throws IOException {
        IOUtil.closeQuietly(this.inputStream);
        this.inputStream = null;
    }

    @Override
    public long getContentLength() {
        try {
            this.getInputStream();
            return this.contentLength;
        }
        catch (Throwable ex) {
            LogUtil.e(ex.getMessage(), ex);
            return 0L;
        }
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.getInputStream() != null ? 200 : 404;
    }

    @Override
    public String getResponseMessage() throws IOException {
        return null;
    }

    @Override
    public long getExpiration() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getLastModified() {
        return this.getAssetsLastModified();
    }

    @Override
    public String getETag() {
        return null;
    }

    @Override
    public String getResponseHeader(String name) {
        return null;
    }

    @Override
    public Map<String, List<String>> getResponseHeaders() {
        return null;
    }

    @Override
    public long getHeaderFieldDate(String name, long defaultValue) {
        return defaultValue;
    }

    protected long getAssetsLastModified() {
        return new File(x.app().getApplicationInfo().sourceDir).lastModified();
    }
}

