/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http.loader;

import android.text.TextUtils;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import org.xutils.cache.DiskCacheEntity;
import org.xutils.common.util.IOUtil;
import org.xutils.common.util.ParameterizedTypeUtil;
import org.xutils.http.RequestParams;
import org.xutils.http.annotation.HttpResponse;
import org.xutils.http.app.ResponseParser;
import org.xutils.http.loader.Loader;
import org.xutils.http.request.UriRequest;

class ObjectLoader
extends Loader<Object> {
    private String charset = "UTF-8";
    private String resultStr = null;
    private final Type objectType;
    private final Class<?> objectClass;
    private final ResponseParser parser;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectLoader(Type objectType) {
        this.objectType = objectType;
        if (objectType instanceof ParameterizedType) {
            this.objectClass = (Class)((ParameterizedType)objectType).getRawType();
        } else {
            if (objectType instanceof TypeVariable) {
                throw new IllegalArgumentException("not support callback type" + objectType.toString());
            }
            this.objectClass = (Class)objectType;
        }
        if (List.class.equals(this.objectClass)) {
            Type itemType = ParameterizedTypeUtil.getParameterizedType(this.objectType, List.class, 0);
            Class itemClass = null;
            if (itemType instanceof ParameterizedType) {
                itemClass = (Class)((ParameterizedType)itemType).getRawType();
            } else {
                if (itemType instanceof TypeVariable) {
                    throw new IllegalArgumentException("not support callback type" + itemType.toString());
                }
                itemClass = (Class)itemType;
            }
            HttpResponse response = itemClass.getAnnotation(HttpResponse.class);
            if (response == null) throw new IllegalArgumentException("not found @HttpResponse from " + itemType);
            try {
                this.parser = response.parser().newInstance();
                return;
            }
            catch (Throwable ex) {
                throw new RuntimeException("create parser error", ex);
            }
        }
        HttpResponse response = this.objectClass.getAnnotation(HttpResponse.class);
        if (response == null) throw new IllegalArgumentException("not found @HttpResponse from " + this.objectType);
        try {
            this.parser = response.parser().newInstance();
            return;
        }
        catch (Throwable ex) {
            throw new RuntimeException("create parser error", ex);
        }
    }

    @Override
    public Loader<Object> newInstance() {
        throw new IllegalAccessError("use constructor create ObjectLoader.");
    }

    @Override
    public void setParams(RequestParams params) {
        String charset;
        if (params != null && !TextUtils.isEmpty((CharSequence)(charset = params.getCharset()))) {
            this.charset = charset;
        }
    }

    @Override
    public Object load(InputStream in) throws Throwable {
        this.resultStr = IOUtil.readStr(in, this.charset);
        return this.parser.parse(this.objectType, this.objectClass, this.resultStr);
    }

    @Override
    public Object load(UriRequest request) throws Throwable {
        request.sendRequest();
        this.parser.checkResponse(request);
        return this.load(request.getInputStream());
    }

    @Override
    public Object loadFromCache(DiskCacheEntity cacheEntity) throws Throwable {
        String text;
        if (cacheEntity != null && !TextUtils.isEmpty((CharSequence)(text = cacheEntity.getTextContent()))) {
            return this.parser.parse(this.objectType, this.objectClass, text);
        }
        return null;
    }

    @Override
    public void save2Cache(UriRequest request) {
        this.saveStringCache(request, this.resultStr);
    }
}

