/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http.loader;

import java.io.File;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xutils.http.RequestParams;
import org.xutils.http.loader.BooleanLoader;
import org.xutils.http.loader.ByteArrayLoader;
import org.xutils.http.loader.FileLoader;
import org.xutils.http.loader.IntegerLoader;
import org.xutils.http.loader.JSONArrayLoader;
import org.xutils.http.loader.JSONObjectLoader;
import org.xutils.http.loader.Loader;
import org.xutils.http.loader.ObjectLoader;
import org.xutils.http.loader.StringLoader;

public final class LoaderFactory {
    private static final HashMap<Type, Loader> converterHashMap = new HashMap();

    static {
        converterHashMap.put((Type)((Object)JSONObject.class), new JSONObjectLoader());
        converterHashMap.put((Type)((Object)JSONArray.class), new JSONArrayLoader());
        converterHashMap.put((Type)((Object)String.class), new StringLoader());
        converterHashMap.put((Type)((Object)File.class), new FileLoader());
        converterHashMap.put((Type)((Object)byte[].class), new ByteArrayLoader());
        BooleanLoader booleanLoader = new BooleanLoader();
        converterHashMap.put(Boolean.TYPE, booleanLoader);
        converterHashMap.put((Type)((Object)Boolean.class), booleanLoader);
        IntegerLoader integerLoader = new IntegerLoader();
        converterHashMap.put(Integer.TYPE, integerLoader);
        converterHashMap.put((Type)((Object)Integer.class), integerLoader);
    }

    private LoaderFactory() {
    }

    public static Loader<?> getLoader(Type type, RequestParams params) {
        ObjectLoader result = converterHashMap.get(type);
        result = result == null ? new ObjectLoader(type) : ((Loader)result).newInstance();
        ((Loader)result).setParams(params);
        return result;
    }

    public static <T> void registerLoader(Type type, Loader<T> loader) {
        converterHashMap.put(type, loader);
    }
}

