/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http.app;

import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.xutils.common.util.LogUtil;
import org.xutils.http.RequestParams;
import org.xutils.http.annotation.HttpRequest;
import org.xutils.http.app.ParamsBuilder;

public class DefaultParamsBuilder
implements ParamsBuilder {
    private static SSLSocketFactory trustAllSSlSocketFactory;

    @Override
    public String buildUri(RequestParams params, HttpRequest httpRequest) {
        return String.valueOf(httpRequest.host()) + "/" + httpRequest.path();
    }

    @Override
    public String buildCacheKey(RequestParams params, String[] cacheKeys) {
        String cacheKey = null;
        if (cacheKeys != null && cacheKeys.length > 0) {
            cacheKey = String.valueOf(params.getUri()) + "?";
            String[] stringArray = cacheKeys;
            int n = cacheKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String value = params.getStringParameter(key);
                if (value != null) {
                    cacheKey = String.valueOf(cacheKey) + key + "=" + value + "&";
                }
                ++n2;
            }
        }
        return cacheKey;
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        return DefaultParamsBuilder.getTrustAllSSLSocketFactory();
    }

    @Override
    public void buildParams(RequestParams params) {
    }

    @Override
    public void buildSign(RequestParams params, String[] signs) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SSLSocketFactory getTrustAllSSLSocketFactory() {
        if (trustAllSSlSocketFactory != null) return trustAllSSlSocketFactory;
        Class<DefaultParamsBuilder> clazz = DefaultParamsBuilder.class;
        synchronized (DefaultParamsBuilder.class) {
            if (trustAllSSlSocketFactory != null) return trustAllSSlSocketFactory;
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, trustAllCerts, null);
                trustAllSSlSocketFactory = sslContext.getSocketFactory();
            }
            catch (Throwable ex) {
                LogUtil.e(ex.getMessage(), ex);
            }
            return trustAllSSlSocketFactory;
        }
    }
}

