/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http;

import android.os.Parcelable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.json.JSONException;
import org.json.JSONObject;
import org.xutils.common.util.LogUtil;
import org.xutils.http.RequestParams;

final class RequestParamsHelper {
    private static final ClassLoader BOOT_CL = String.class.getClassLoader();

    private RequestParamsHelper() {
    }

    static void parseKV(Object entity, Class<?> type, ParseKVListener listener) {
        if (type == null || type == RequestParams.class || type == Object.class) {
            return;
        }
        ClassLoader cl = type.getClassLoader();
        if (cl == null || cl == BOOT_CL) {
            return;
        }
        Field[] fields = type.getDeclaredFields();
        if (fields != null && fields.length > 0) {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!Modifier.isTransient(field.getModifiers()) && field.getType() != Parcelable.Creator.class) {
                    field.setAccessible(true);
                    try {
                        String name = field.getName();
                        Object value = field.get(entity);
                        if (value != null) {
                            listener.onParseKV(name, value);
                        }
                    }
                    catch (IllegalAccessException ex) {
                        LogUtil.e(ex.getMessage(), ex);
                    }
                }
                ++n2;
            }
        }
        RequestParamsHelper.parseKV(entity, type.getSuperclass(), listener);
    }

    static Object parseJSONObject(Object value) {
        Object result = value;
        ClassLoader cl = value.getClass().getClassLoader();
        if (cl != null && cl != BOOT_CL) {
            final JSONObject jo = new JSONObject();
            RequestParamsHelper.parseKV(value, value.getClass(), new ParseKVListener(){

                @Override
                public void onParseKV(String name, Object value) {
                    try {
                        value = RequestParamsHelper.parseJSONObject(value);
                        jo.put(name, value);
                    }
                    catch (JSONException ex) {
                        LogUtil.e(ex.getMessage(), ex);
                    }
                }
            });
            result = jo;
        }
        return result;
    }

    static interface ParseKVListener {
        public void onParseKV(String var1, Object var2);
    }
}

