/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http;

import android.text.TextUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xutils.common.util.KeyValue;
import org.xutils.common.util.LogUtil;
import org.xutils.http.HttpMethod;
import org.xutils.http.RequestParamsHelper;
import org.xutils.http.body.BodyItemWrapper;
import org.xutils.http.body.FileBody;
import org.xutils.http.body.InputStreamBody;
import org.xutils.http.body.MultipartBody;
import org.xutils.http.body.RequestBody;
import org.xutils.http.body.StringBody;
import org.xutils.http.body.UrlEncodedParamsBody;

abstract class BaseParams {
    private String charset = "UTF-8";
    private HttpMethod method;
    private String bodyContent;
    private boolean multipart = false;
    private boolean asJsonContent = false;
    private RequestBody requestBody;
    private final List<Header> headers = new ArrayList<Header>();
    private final List<KeyValue> queryStringParams = new ArrayList<KeyValue>();
    private final List<KeyValue> bodyParams = new ArrayList<KeyValue>();
    private final List<KeyValue> fileParams = new ArrayList<KeyValue>();

    BaseParams() {
    }

    public void setCharset(String charset) {
        if (!TextUtils.isEmpty((CharSequence)charset)) {
            this.charset = charset;
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public void setMultipart(boolean multipart) {
        this.multipart = multipart;
    }

    public boolean isAsJsonContent() {
        return this.asJsonContent;
    }

    public void setAsJsonContent(boolean asJsonContent) {
        this.asJsonContent = asJsonContent;
    }

    public void setHeader(String name, String value) {
        Header header = new Header(name, value, true);
        Iterator<Header> it = this.headers.iterator();
        while (it.hasNext()) {
            KeyValue kv = it.next();
            if (!name.equals(kv.key)) continue;
            it.remove();
        }
        this.headers.add(header);
    }

    public void addHeader(String name, String value) {
        this.headers.add(new Header(name, value, false));
    }

    public void addParameter(String name, Object value) {
        if (value == null) {
            return;
        }
        if (this.method == null || HttpMethod.permitsRequestBody(this.method)) {
            if (!TextUtils.isEmpty((CharSequence)name)) {
                if (value instanceof File || value instanceof InputStream || value instanceof byte[]) {
                    this.fileParams.add(new KeyValue(name, value));
                } else if (value instanceof List) {
                    for (Object item : (List)value) {
                        this.bodyParams.add(new ArrayItem(name, item));
                    }
                } else if (value.getClass().isArray()) {
                    int len = Array.getLength(value);
                    int i = 0;
                    while (i < len) {
                        this.bodyParams.add(new ArrayItem(name, Array.get(value, i)));
                        ++i;
                    }
                } else {
                    this.bodyParams.add(new KeyValue(name, value));
                }
            } else {
                this.bodyContent = value.toString();
            }
        } else if (!TextUtils.isEmpty((CharSequence)name)) {
            if (value instanceof List) {
                for (Object item : (List)value) {
                    this.queryStringParams.add(new ArrayItem(name, item));
                }
            } else if (value.getClass().isArray()) {
                int len = Array.getLength(value);
                int i = 0;
                while (i < len) {
                    this.queryStringParams.add(new ArrayItem(name, Array.get(value, i)));
                    ++i;
                }
            } else {
                this.queryStringParams.add(new KeyValue(name, value));
            }
        }
    }

    public void addQueryStringParameter(String name, String value) {
        if (!TextUtils.isEmpty((CharSequence)name)) {
            this.queryStringParams.add(new KeyValue(name, value));
        }
    }

    public void addBodyParameter(String name, String value) {
        if (!TextUtils.isEmpty((CharSequence)name)) {
            this.bodyParams.add(new KeyValue(name, value));
        } else {
            this.bodyContent = value;
        }
    }

    public void addBodyParameter(String name, File value) {
        this.addBodyParameter(name, value, null, null);
    }

    public void addBodyParameter(String name, Object value, String contentType) {
        this.addBodyParameter(name, value, contentType, null);
    }

    public void addBodyParameter(String name, Object value, String contentType, String fileName) {
        if (TextUtils.isEmpty((CharSequence)contentType) && TextUtils.isEmpty((CharSequence)fileName)) {
            this.fileParams.add(new KeyValue(name, value));
        } else {
            this.fileParams.add(new KeyValue(name, new BodyItemWrapper(value, contentType, fileName)));
        }
    }

    public void setBodyContent(String content) {
        this.bodyContent = content;
    }

    public String getBodyContent() {
        this.checkBodyParams();
        return this.bodyContent;
    }

    public List<Header> getHeaders() {
        return new ArrayList<Header>(this.headers);
    }

    public List<KeyValue> getQueryStringParams() {
        this.checkBodyParams();
        return new ArrayList<KeyValue>(this.queryStringParams);
    }

    public List<KeyValue> getBodyParams() {
        this.checkBodyParams();
        return new ArrayList<KeyValue>(this.bodyParams);
    }

    public List<KeyValue> getFileParams() {
        this.checkBodyParams();
        return new ArrayList<KeyValue>(this.fileParams);
    }

    public List<KeyValue> getStringParams() {
        ArrayList<KeyValue> result = new ArrayList<KeyValue>(this.queryStringParams.size() + this.bodyParams.size());
        result.addAll(this.queryStringParams);
        result.addAll(this.bodyParams);
        return result;
    }

    public String getStringParameter(String name) {
        for (KeyValue kv : this.queryStringParams) {
            if (name == null && kv.key == null) {
                return kv.getValueStr();
            }
            if (name == null || !name.equals(kv.key)) continue;
            return kv.getValueStr();
        }
        for (KeyValue kv : this.bodyParams) {
            if (name == null && kv.key == null) {
                return kv.getValueStr();
            }
            if (name == null || !name.equals(kv.key)) continue;
            return kv.getValueStr();
        }
        return null;
    }

    public List<KeyValue> getParams(String name) {
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        for (KeyValue kv : this.queryStringParams) {
            if (name == null && kv.key == null) {
                result.add(kv);
                continue;
            }
            if (name == null || !name.equals(kv.key)) continue;
            result.add(kv);
        }
        for (KeyValue kv : this.bodyParams) {
            if (name == null && kv.key == null) {
                result.add(kv);
                continue;
            }
            if (name == null || !name.equals(kv.key)) continue;
            result.add(kv);
        }
        for (KeyValue kv : this.fileParams) {
            if (name == null && kv.key == null) {
                result.add(kv);
                continue;
            }
            if (name == null || !name.equals(kv.key)) continue;
            result.add(kv);
        }
        return result;
    }

    public void clearParams() {
        this.queryStringParams.clear();
        this.bodyParams.clear();
        this.fileParams.clear();
        this.bodyContent = null;
        this.requestBody = null;
    }

    public void removeParameter(String name) {
        if (!TextUtils.isEmpty((CharSequence)name)) {
            KeyValue kv;
            Iterator<KeyValue> it = this.queryStringParams.iterator();
            while (it.hasNext()) {
                kv = it.next();
                if (!name.equals(kv.key)) continue;
                it.remove();
            }
            it = this.bodyParams.iterator();
            while (it.hasNext()) {
                kv = it.next();
                if (!name.equals(kv.key)) continue;
                it.remove();
            }
            it = this.fileParams.iterator();
            while (it.hasNext()) {
                kv = it.next();
                if (!name.equals(kv.key)) continue;
                it.remove();
            }
        } else {
            this.bodyContent = null;
        }
    }

    public void setRequestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
    }

    public RequestBody getRequestBody() throws IOException {
        this.checkBodyParams();
        if (this.requestBody != null) {
            return this.requestBody;
        }
        RequestBody result = null;
        if (!TextUtils.isEmpty((CharSequence)this.bodyContent)) {
            result = new StringBody(this.bodyContent, this.charset);
        } else if (this.multipart || this.fileParams.size() > 0) {
            if (!this.multipart && this.fileParams.size() == 1) {
                Iterator<KeyValue> iterator = this.fileParams.iterator();
                if (iterator.hasNext()) {
                    KeyValue kv = iterator.next();
                    String contentType = null;
                    Object value = kv.value;
                    if (value instanceof BodyItemWrapper) {
                        BodyItemWrapper wrapper = (BodyItemWrapper)value;
                        value = wrapper.getValue();
                        contentType = wrapper.getContentType();
                    }
                    if (value instanceof File) {
                        result = new FileBody((File)value, contentType);
                    } else if (value instanceof InputStream) {
                        result = new InputStreamBody((InputStream)value, contentType);
                    } else if (value instanceof byte[]) {
                        result = new InputStreamBody(new ByteArrayInputStream((byte[])value), contentType);
                    } else if (value instanceof String) {
                        result = new StringBody((String)value, this.charset);
                        result.setContentType(contentType);
                    } else {
                        LogUtil.w("Some params will be ignored for: " + this.toString());
                    }
                }
            } else {
                this.multipart = true;
                result = new MultipartBody(this.fileParams, this.charset);
            }
        } else if (this.bodyParams.size() > 0) {
            result = new UrlEncodedParamsBody(this.bodyParams, this.charset);
        }
        return result;
    }

    private void checkBodyParams() {
        if (!(this.bodyParams.isEmpty() || HttpMethod.permitsRequestBody(this.method) && TextUtils.isEmpty((CharSequence)this.bodyContent) && this.requestBody == null)) {
            this.queryStringParams.addAll(this.bodyParams);
            this.bodyParams.clear();
        }
        if (!this.bodyParams.isEmpty() && (this.multipart || this.fileParams.size() > 0)) {
            this.fileParams.addAll(this.bodyParams);
            this.bodyParams.clear();
        }
        if (this.asJsonContent && !this.bodyParams.isEmpty()) {
            try {
                JSONObject jsonObject = null;
                jsonObject = !TextUtils.isEmpty((CharSequence)this.bodyContent) ? new JSONObject(this.bodyContent) : new JSONObject();
                this.params2Json(jsonObject, this.bodyParams);
                this.bodyContent = jsonObject.toString();
                this.bodyParams.clear();
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void params2Json(JSONObject jsonObject, List<KeyValue> paramList) throws JSONException {
        JSONArray ja;
        String key;
        HashSet<String> arraySet = new HashSet<String>(paramList.size());
        LinkedHashMap<String, JSONArray> tempData = new LinkedHashMap<String, JSONArray>(paramList.size());
        int i = 0;
        while (i < paramList.size()) {
            KeyValue kv = paramList.get(i);
            key = kv.key;
            if (!TextUtils.isEmpty((CharSequence)key)) {
                ja = null;
                if (tempData.containsKey(key)) {
                    ja = (JSONArray)tempData.get(key);
                } else {
                    ja = new JSONArray();
                    tempData.put(key, ja);
                }
                ja.put(RequestParamsHelper.parseJSONObject(kv.value));
                if (kv instanceof ArrayItem) {
                    arraySet.add(key);
                }
            }
            ++i;
        }
        for (Map.Entry entry : tempData.entrySet()) {
            key = (String)entry.getKey();
            ja = (JSONArray)entry.getValue();
            if (ja.length() > 1 || arraySet.contains(key)) {
                jsonObject.put(key, (Object)ja);
                continue;
            }
            Object value = ja.get(0);
            jsonObject.put(key, value);
        }
    }

    public static final class ArrayItem
    extends KeyValue {
        public ArrayItem(String key, Object value) {
            super(key, value);
        }
    }

    public static final class Header
    extends KeyValue {
        public final boolean setHeader;

        public Header(String key, String value, boolean setHeader) {
            super(key, value);
            this.setHeader = setHeader;
        }
    }
}

