/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.db.table;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.xutils.common.util.LogUtil;
import org.xutils.db.annotation.Column;
import org.xutils.db.converter.ColumnConverterFactory;
import org.xutils.db.table.ColumnEntity;

final class TableUtils {
    private TableUtils() {
    }

    static synchronized LinkedHashMap<String, ColumnEntity> findColumnMap(Class<?> entityType) {
        LinkedHashMap<String, ColumnEntity> columnMap = new LinkedHashMap<String, ColumnEntity>();
        TableUtils.addColumns2Map(entityType, columnMap);
        return columnMap;
    }

    private static void addColumns2Map(Class<?> entityType, HashMap<String, ColumnEntity> columnMap) {
        if (Object.class.equals(entityType)) {
            return;
        }
        try {
            Field[] fields;
            Field[] fieldArray = fields = entityType.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnEntity column;
                Column columnAnn;
                Field field = fieldArray[n2];
                int modify = field.getModifiers();
                if (!Modifier.isStatic(modify) && !Modifier.isTransient(modify) && (columnAnn = field.getAnnotation(Column.class)) != null && ColumnConverterFactory.isSupportColumnConverter(field.getType()) && !columnMap.containsKey((column = new ColumnEntity(entityType, field, columnAnn)).getName())) {
                    columnMap.put(column.getName(), column);
                }
                ++n2;
            }
            TableUtils.addColumns2Map(entityType.getSuperclass(), columnMap);
        }
        catch (Throwable e) {
            LogUtil.e(e.getMessage(), e);
        }
    }
}

