/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.db.table;

import android.database.Cursor;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import org.xutils.DbManager;
import org.xutils.common.util.IOUtil;
import org.xutils.db.annotation.Table;
import org.xutils.db.table.ColumnEntity;
import org.xutils.db.table.TableUtils;
import org.xutils.ex.DbException;

public final class TableEntity<T> {
    private final DbManager db;
    private final String name;
    private final String onCreated;
    private ColumnEntity id;
    private Class<T> entityType;
    private Constructor<T> constructor;
    private volatile boolean checkedDatabase;
    private final LinkedHashMap<String, ColumnEntity> columnMap;

    TableEntity(DbManager db, Class<T> entityType) throws Throwable {
        this.db = db;
        this.entityType = entityType;
        this.constructor = entityType.getConstructor(new Class[0]);
        this.constructor.setAccessible(true);
        Table table = entityType.getAnnotation(Table.class);
        this.name = table.name();
        this.onCreated = table.onCreated();
        this.columnMap = TableUtils.findColumnMap(entityType);
        for (ColumnEntity column : this.columnMap.values()) {
            if (!column.isId()) continue;
            this.id = column;
            break;
        }
    }

    public T createEntity() throws Throwable {
        return this.constructor.newInstance(new Object[0]);
    }

    public boolean tableIsExist() throws DbException {
        if (this.isCheckedDatabase()) {
            return true;
        }
        Cursor cursor = this.db.execQuery("SELECT COUNT(*) AS c FROM sqlite_master WHERE type='table' AND name='" + this.name + "'");
        if (cursor != null) {
            try {
                int count;
                if (cursor.moveToNext() && (count = cursor.getInt(0)) > 0) {
                    this.setCheckedDatabase(true);
                    return true;
                }
            }
            catch (Throwable e) {
                throw new DbException(e);
            }
            finally {
                IOUtil.closeQuietly(cursor);
            }
        }
        return false;
    }

    public DbManager getDb() {
        return this.db;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getEntityType() {
        return this.entityType;
    }

    public String getOnCreated() {
        return this.onCreated;
    }

    public ColumnEntity getId() {
        return this.id;
    }

    public LinkedHashMap<String, ColumnEntity> getColumnMap() {
        return this.columnMap;
    }

    boolean isCheckedDatabase() {
        return this.checkedDatabase;
    }

    void setCheckedDatabase(boolean checkedDatabase) {
        this.checkedDatabase = checkedDatabase;
    }

    public String toString() {
        return this.name;
    }
}

