/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.db.table;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.xutils.common.util.LogUtil;
import org.xutils.db.converter.ColumnConverter;
import org.xutils.db.converter.ColumnConverterFactory;

public final class ColumnUtils {
    private static final HashSet<Class<?>> BOOLEAN_TYPES = new HashSet(2);
    private static final HashSet<Class<?>> INTEGER_TYPES = new HashSet(2);
    private static final HashSet<Class<?>> AUTO_INCREMENT_TYPES = new HashSet(4);

    static {
        BOOLEAN_TYPES.add(Boolean.TYPE);
        BOOLEAN_TYPES.add(Boolean.class);
        INTEGER_TYPES.add(Integer.TYPE);
        INTEGER_TYPES.add(Integer.class);
        AUTO_INCREMENT_TYPES.addAll(INTEGER_TYPES);
        AUTO_INCREMENT_TYPES.add(Long.TYPE);
        AUTO_INCREMENT_TYPES.add(Long.class);
    }

    private ColumnUtils() {
    }

    public static boolean isAutoIdType(Class<?> fieldType) {
        return AUTO_INCREMENT_TYPES.contains(fieldType);
    }

    public static boolean isInteger(Class<?> fieldType) {
        return INTEGER_TYPES.contains(fieldType);
    }

    public static boolean isBoolean(Class<?> fieldType) {
        return BOOLEAN_TYPES.contains(fieldType);
    }

    public static Object convert2DbValueIfNeeded(Object value) {
        Object result = value;
        if (value != null) {
            Class<?> valueType = value.getClass();
            ColumnConverter converter = ColumnConverterFactory.getColumnConverter(valueType);
            result = converter.fieldValue2DbValue(value);
        }
        return result;
    }

    static Method findGetMethod(Class<?> entityType, Field field) {
        if (Object.class.equals(entityType)) {
            return null;
        }
        String fieldName = field.getName();
        Method getMethod = null;
        if (ColumnUtils.isBoolean(field.getType())) {
            getMethod = ColumnUtils.findBooleanGetMethod(entityType, fieldName);
        }
        if (getMethod == null) {
            String methodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            try {
                getMethod = entityType.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                LogUtil.d(String.valueOf(entityType.getName()) + "#" + methodName + " not exist");
            }
        }
        if (getMethod == null) {
            return ColumnUtils.findGetMethod(entityType.getSuperclass(), field);
        }
        return getMethod;
    }

    static Method findSetMethod(Class<?> entityType, Field field) {
        if (Object.class.equals(entityType)) {
            return null;
        }
        String fieldName = field.getName();
        Class<?> fieldType = field.getType();
        Method setMethod = null;
        if (ColumnUtils.isBoolean(fieldType)) {
            setMethod = ColumnUtils.findBooleanSetMethod(entityType, fieldName, fieldType);
        }
        if (setMethod == null) {
            String methodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            try {
                setMethod = entityType.getDeclaredMethod(methodName, fieldType);
            }
            catch (NoSuchMethodException e) {
                LogUtil.d(String.valueOf(entityType.getName()) + "#" + methodName + " not exist");
            }
        }
        if (setMethod == null) {
            return ColumnUtils.findSetMethod(entityType.getSuperclass(), field);
        }
        return setMethod;
    }

    private static Method findBooleanGetMethod(Class<?> entityType, String fieldName) {
        String methodName = null;
        methodName = fieldName.startsWith("is") ? fieldName : "is" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            return entityType.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LogUtil.d(String.valueOf(entityType.getName()) + "#" + methodName + " not exist");
            return null;
        }
    }

    private static Method findBooleanSetMethod(Class<?> entityType, String fieldName, Class<?> fieldType) {
        String methodName = null;
        methodName = fieldName.startsWith("is") ? "set" + fieldName.substring(2, 3).toUpperCase() + fieldName.substring(3) : "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            return entityType.getDeclaredMethod(methodName, fieldType);
        }
        catch (NoSuchMethodException e) {
            LogUtil.d(String.valueOf(entityType.getName()) + "#" + methodName + " not exist");
            return null;
        }
    }
}

