/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.db.sqlite;

import android.text.TextUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xutils.db.converter.ColumnConverterFactory;
import org.xutils.db.sqlite.ColumnDbType;
import org.xutils.db.table.ColumnUtils;

public class WhereBuilder {
    private final List<String> whereItems = new ArrayList<String>();

    private WhereBuilder() {
    }

    public static WhereBuilder b() {
        return new WhereBuilder();
    }

    public static WhereBuilder b(String columnName, String op, Object value) {
        WhereBuilder result = new WhereBuilder();
        result.appendCondition(null, columnName, op, value);
        return result;
    }

    public WhereBuilder and(String columnName, String op, Object value) {
        this.appendCondition(this.whereItems.size() == 0 ? null : "AND", columnName, op, value);
        return this;
    }

    public WhereBuilder and(WhereBuilder where) {
        String condition = this.whereItems.size() == 0 ? " " : "AND ";
        return this.expr(String.valueOf(condition) + "(" + where.toString() + ")");
    }

    public WhereBuilder or(String columnName, String op, Object value) {
        this.appendCondition(this.whereItems.size() == 0 ? null : "OR", columnName, op, value);
        return this;
    }

    public WhereBuilder or(WhereBuilder where) {
        String condition = this.whereItems.size() == 0 ? " " : "OR ";
        return this.expr(String.valueOf(condition) + "(" + where.toString() + ")");
    }

    public WhereBuilder expr(String expr) {
        this.whereItems.add(" " + expr);
        return this;
    }

    public int getWhereItemSize() {
        return this.whereItems.size();
    }

    public String toString() {
        if (this.whereItems.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String item : this.whereItems) {
            sb.append(item);
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendCondition(String conj, String columnName, String op, Object value) {
        StringBuilder builder = new StringBuilder();
        if (this.whereItems.size() > 0) {
            builder.append(" ");
        }
        if (!TextUtils.isEmpty((CharSequence)conj)) {
            builder.append(conj).append(" ");
        }
        builder.append("\"").append(columnName).append("\"");
        if ("!=".equals(op)) {
            op = "<>";
        } else if ("==".equals(op)) {
            op = "=";
        }
        if (value == null) {
            if ("=".equals(op)) {
                builder.append(" IS NULL");
            } else if ("<>".equals(op)) {
                builder.append(" IS NOT NULL");
            } else {
                builder.append(" ").append(op).append(" NULL");
            }
        } else {
            builder.append(" ").append(op).append(" ");
            if ("IN".equalsIgnoreCase(op)) {
                ArrayList<Object> items = null;
                if (value instanceof Iterable) {
                    items = (ArrayList<Object>)value;
                } else if (value.getClass().isArray()) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    int n = Array.getLength(value);
                    int i = 0;
                    while (i < n) {
                        arrayList.add(Array.get(value, i));
                        ++i;
                    }
                    items = arrayList;
                }
                if (items == null) throw new IllegalArgumentException("value must be an Array or an Iterable.");
                StringBuilder inSb = new StringBuilder("(");
                for (Object t : items) {
                    Object itemColValue = ColumnUtils.convert2DbValueIfNeeded(t);
                    if (ColumnDbType.TEXT.equals((Object)ColumnConverterFactory.getDbColumnType(itemColValue.getClass()))) {
                        String valueStr = itemColValue.toString();
                        if (valueStr.indexOf(39) != -1) {
                            valueStr = valueStr.replace("'", "''");
                        }
                        inSb.append("'").append(valueStr).append("'");
                    } else {
                        inSb.append(itemColValue);
                    }
                    inSb.append(",");
                }
                inSb.deleteCharAt(inSb.length() - 1);
                inSb.append(")");
                builder.append(inSb.toString());
            } else if ("BETWEEN".equalsIgnoreCase(op)) {
                ArrayList<Object> items = null;
                if (value instanceof Iterable) {
                    items = (ArrayList<Object>)value;
                } else if (value.getClass().isArray()) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    int n = Array.getLength(value);
                    int i = 0;
                    while (i < n) {
                        arrayList.add(Array.get(value, i));
                        ++i;
                    }
                    items = arrayList;
                }
                if (items == null) throw new IllegalArgumentException("value must be an Array or an Iterable.");
                Iterator iterator = items.iterator();
                if (!iterator.hasNext()) {
                    throw new IllegalArgumentException("value must have tow items.");
                }
                Object t = iterator.next();
                if (!iterator.hasNext()) {
                    throw new IllegalArgumentException("value must have tow items.");
                }
                Object end = iterator.next();
                Object startColValue = ColumnUtils.convert2DbValueIfNeeded(t);
                Object endColValue = ColumnUtils.convert2DbValueIfNeeded(end);
                if (ColumnDbType.TEXT.equals((Object)ColumnConverterFactory.getDbColumnType(startColValue.getClass()))) {
                    String endStr;
                    String startStr = startColValue.toString();
                    if (startStr.indexOf(39) != -1) {
                        startStr = startStr.replace("'", "''");
                    }
                    if ((endStr = endColValue.toString()).indexOf(39) != -1) {
                        endStr = endStr.replace("'", "''");
                    }
                    builder.append("'").append(startStr).append("'");
                    builder.append(" AND ");
                    builder.append("'").append(endStr).append("'");
                } else {
                    builder.append(startColValue);
                    builder.append(" AND ");
                    builder.append(endColValue);
                }
            } else if (ColumnDbType.TEXT.equals((Object)ColumnConverterFactory.getDbColumnType((value = ColumnUtils.convert2DbValueIfNeeded(value)).getClass()))) {
                String valueStr = value.toString();
                if (valueStr.indexOf(39) != -1) {
                    valueStr = valueStr.replace("'", "''");
                }
                builder.append("'").append(valueStr).append("'");
            } else {
                builder.append(value);
            }
        }
        this.whereItems.add(builder.toString());
    }
}

