/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.db.sqlite;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import java.util.ArrayList;
import java.util.List;
import org.xutils.common.util.KeyValue;
import org.xutils.db.converter.ColumnConverter;
import org.xutils.db.converter.ColumnConverterFactory;
import org.xutils.db.sqlite.ColumnDbType;
import org.xutils.db.table.ColumnUtils;

public final class SqlInfo {
    private String sql;
    private List<KeyValue> bindArgs;

    public SqlInfo() {
    }

    public SqlInfo(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void addBindArg(KeyValue kv) {
        if (this.bindArgs == null) {
            this.bindArgs = new ArrayList<KeyValue>();
        }
        this.bindArgs.add(kv);
    }

    public void addBindArgs(List<KeyValue> bindArgs) {
        if (this.bindArgs == null) {
            this.bindArgs = bindArgs;
        } else {
            this.bindArgs.addAll(bindArgs);
        }
    }

    public SQLiteStatement buildStatement(SQLiteDatabase database) {
        SQLiteStatement result = database.compileStatement(this.sql);
        if (this.bindArgs != null) {
            int i = 1;
            while (i < this.bindArgs.size() + 1) {
                KeyValue kv = this.bindArgs.get(i - 1);
                Object value = ColumnUtils.convert2DbValueIfNeeded(kv.value);
                if (value == null) {
                    result.bindNull(i);
                } else {
                    ColumnConverter converter = ColumnConverterFactory.getColumnConverter(value.getClass());
                    ColumnDbType type = converter.getColumnDbType();
                    switch (type) {
                        case INTEGER: {
                            result.bindLong(i, ((Number)value).longValue());
                            break;
                        }
                        case REAL: {
                            result.bindDouble(i, ((Number)value).doubleValue());
                            break;
                        }
                        case TEXT: {
                            result.bindString(i, value.toString());
                            break;
                        }
                        case BLOB: {
                            result.bindBlob(i, (byte[])value);
                            break;
                        }
                        default: {
                            result.bindNull(i);
                        }
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public Object[] getBindArgs() {
        Object[] result = null;
        if (this.bindArgs != null) {
            result = new Object[this.bindArgs.size()];
            int i = 0;
            while (i < this.bindArgs.size()) {
                result[i] = ColumnUtils.convert2DbValueIfNeeded(this.bindArgs.get((int)i).value);
                ++i;
            }
        }
        return result;
    }

    public String[] getBindArgsAsStrArray() {
        String[] result = null;
        if (this.bindArgs != null) {
            result = new String[this.bindArgs.size()];
            int i = 0;
            while (i < this.bindArgs.size()) {
                Object value = ColumnUtils.convert2DbValueIfNeeded(this.bindArgs.get((int)i).value);
                result[i] = value == null ? null : value.toString();
                ++i;
            }
        }
        return result;
    }
}

