/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.db;

import android.database.Cursor;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.xutils.common.util.IOUtil;
import org.xutils.db.CursorUtils;
import org.xutils.db.Selector;
import org.xutils.db.sqlite.WhereBuilder;
import org.xutils.db.table.DbModel;
import org.xutils.db.table.TableEntity;
import org.xutils.ex.DbException;

public final class DbModelSelector {
    private String[] columnExpressions;
    private String groupByColumnName;
    private WhereBuilder having;
    private Selector<?> selector;

    private DbModelSelector(TableEntity<?> table) {
        this.selector = Selector.from(table);
    }

    protected DbModelSelector(Selector<?> selector, String groupByColumnName) {
        this.selector = selector;
        this.groupByColumnName = groupByColumnName;
    }

    protected DbModelSelector(Selector<?> selector, String[] columnExpressions) {
        this.selector = selector;
        this.columnExpressions = columnExpressions;
    }

    static DbModelSelector from(TableEntity<?> table) {
        return new DbModelSelector(table);
    }

    public DbModelSelector where(WhereBuilder whereBuilder) {
        this.selector.where(whereBuilder);
        return this;
    }

    public DbModelSelector where(String columnName, String op, Object value) {
        this.selector.where(columnName, op, value);
        return this;
    }

    public DbModelSelector and(String columnName, String op, Object value) {
        this.selector.and(columnName, op, value);
        return this;
    }

    public DbModelSelector and(WhereBuilder where) {
        this.selector.and(where);
        return this;
    }

    public DbModelSelector or(String columnName, String op, Object value) {
        this.selector.or(columnName, op, value);
        return this;
    }

    public DbModelSelector or(WhereBuilder where) {
        this.selector.or(where);
        return this;
    }

    public DbModelSelector expr(String expr) {
        this.selector.expr(expr);
        return this;
    }

    public DbModelSelector groupBy(String columnName) {
        this.groupByColumnName = columnName;
        return this;
    }

    public DbModelSelector having(WhereBuilder whereBuilder) {
        this.having = whereBuilder;
        return this;
    }

    public DbModelSelector select(String ... columnExpressions) {
        this.columnExpressions = columnExpressions;
        return this;
    }

    public DbModelSelector orderBy(String columnName) {
        this.selector.orderBy(columnName);
        return this;
    }

    public DbModelSelector orderBy(String columnName, boolean desc) {
        this.selector.orderBy(columnName, desc);
        return this;
    }

    public DbModelSelector limit(int limit) {
        this.selector.limit(limit);
        return this;
    }

    public DbModelSelector offset(int offset) {
        this.selector.offset(offset);
        return this;
    }

    public TableEntity<?> getTable() {
        return this.selector.getTable();
    }

    public DbModel findFirst() throws DbException {
        TableEntity<?> table = this.selector.getTable();
        if (!table.tableIsExist()) {
            return null;
        }
        this.limit(1);
        Cursor cursor = table.getDb().execQuery(this.toString());
        if (cursor != null) {
            try {
                if (cursor.moveToNext()) {
                    DbModel dbModel = CursorUtils.getDbModel(cursor);
                    return dbModel;
                }
            }
            catch (Throwable e) {
                throw new DbException(e);
            }
            finally {
                IOUtil.closeQuietly(cursor);
            }
        }
        return null;
    }

    public List<DbModel> findAll() throws DbException {
        TableEntity<?> table = this.selector.getTable();
        if (!table.tableIsExist()) {
            return null;
        }
        ArrayList<DbModel> result = null;
        Cursor cursor = table.getDb().execQuery(this.toString());
        if (cursor != null) {
            try {
                try {
                    result = new ArrayList<DbModel>();
                    while (cursor.moveToNext()) {
                        DbModel entity = CursorUtils.getDbModel(cursor);
                        result.add(entity);
                    }
                }
                catch (Throwable e) {
                    throw new DbException(e);
                }
            }
            finally {
                IOUtil.closeQuietly(cursor);
            }
        }
        return result;
    }

    public String toString() {
        List<Selector.OrderBy> orderByList;
        StringBuilder result = new StringBuilder();
        result.append("SELECT ");
        if (this.columnExpressions != null && this.columnExpressions.length > 0) {
            String[] stringArray = this.columnExpressions;
            int n = this.columnExpressions.length;
            int n2 = 0;
            while (n2 < n) {
                String columnExpression = stringArray[n2];
                result.append(columnExpression);
                result.append(",");
                ++n2;
            }
            result.deleteCharAt(result.length() - 1);
        } else if (!TextUtils.isEmpty((CharSequence)this.groupByColumnName)) {
            result.append(this.groupByColumnName);
        } else {
            result.append("*");
        }
        result.append(" FROM ").append("\"").append(this.selector.getTable().getName()).append("\"");
        WhereBuilder whereBuilder = this.selector.getWhereBuilder();
        if (whereBuilder != null && whereBuilder.getWhereItemSize() > 0) {
            result.append(" WHERE ").append(whereBuilder.toString());
        }
        if (!TextUtils.isEmpty((CharSequence)this.groupByColumnName)) {
            result.append(" GROUP BY ").append("\"").append(this.groupByColumnName).append("\"");
            if (this.having != null && this.having.getWhereItemSize() > 0) {
                result.append(" HAVING ").append(this.having.toString());
            }
        }
        if ((orderByList = this.selector.getOrderByList()) != null && orderByList.size() > 0) {
            int i = 0;
            while (i < orderByList.size()) {
                result.append(" ORDER BY ").append(orderByList.get(i).toString()).append(',');
                ++i;
            }
            result.deleteCharAt(result.length() - 1);
        }
        if (this.selector.getLimit() > 0) {
            result.append(" LIMIT ").append(this.selector.getLimit());
            result.append(" OFFSET ").append(this.selector.getOffset());
        }
        return result.toString();
    }
}

