/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.db;

import android.database.Cursor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.xutils.db.table.ColumnEntity;
import org.xutils.db.table.DbModel;
import org.xutils.db.table.TableEntity;

final class CursorUtils {
    CursorUtils() {
    }

    public static <T> T getEntity(TableEntity<T> table, Cursor cursor) throws Throwable {
        T entity = table.createEntity();
        LinkedHashMap<String, ColumnEntity> columnMap = table.getColumnMap();
        int columnCount = cursor.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            String columnName = cursor.getColumnName(i);
            ColumnEntity column = (ColumnEntity)((HashMap)columnMap).get(columnName);
            if (column != null) {
                column.setValueFromCursor(entity, cursor, i);
            }
            ++i;
        }
        return entity;
    }

    public static DbModel getDbModel(Cursor cursor) {
        DbModel result = new DbModel();
        int columnCount = cursor.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            result.add(cursor.getColumnName(i), cursor.getString(i));
            ++i;
        }
        return result;
    }
}

