/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.common.util;

import android.os.Process;
import android.text.TextUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.DecimalFormat;
import java.util.HashMap;
import org.xutils.common.util.IOUtil;
import org.xutils.common.util.LogUtil;
import org.xutils.x;

public final class ProcessLock
implements Closeable {
    private final String mLockName;
    private final FileLock mFileLock;
    private final File mFile;
    private final Closeable mStream;
    private static final String LOCK_FILE_DIR = "process_lock";
    private static final int PID = Process.myPid();
    private static final HashMap<String, ProcessLock> LOCK_MAP = new HashMap(5);
    private static final DecimalFormat FORMAT;

    static {
        IOUtil.deleteFileOrDir(x.app().getDir(LOCK_FILE_DIR, 0));
        FORMAT = new DecimalFormat("0.##################");
    }

    private ProcessLock(String lockName, File file, FileLock fileLock, Closeable stream) {
        this.mLockName = lockName;
        this.mFileLock = fileLock;
        this.mFile = file;
        this.mStream = stream;
    }

    public static ProcessLock tryLock(String lockName, boolean writeMode) {
        return ProcessLock.tryLockInternal(lockName, ProcessLock.customHash(lockName), writeMode);
    }

    public static ProcessLock tryLock(String lockName, boolean writeMode, long maxWaitTimeMillis) {
        ProcessLock lock = null;
        long expiryTime = System.currentTimeMillis() + maxWaitTimeMillis;
        String hash = ProcessLock.customHash(lockName);
        while (System.currentTimeMillis() < expiryTime) {
            lock = ProcessLock.tryLockInternal(lockName, hash, writeMode);
            if (lock != null) break;
            try {
                Thread.sleep(1L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return lock;
    }

    public boolean isValid() {
        return ProcessLock.isValid(this.mFileLock);
    }

    public void release() {
        ProcessLock.release(this.mLockName, this.mFileLock, this.mFile, this.mStream);
    }

    @Override
    public void close() throws IOException {
        this.release();
    }

    private static boolean isValid(FileLock fileLock) {
        return fileLock != null && fileLock.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void release(String lockName, FileLock fileLock, File file, Closeable stream) {
        HashMap<String, ProcessLock> hashMap = LOCK_MAP;
        synchronized (hashMap) {
            block9: {
                if (fileLock != null) {
                    try {
                        try {
                            LOCK_MAP.remove(lockName);
                            fileLock.release();
                            LogUtil.d("released: " + lockName + ":" + PID);
                        }
                        catch (Throwable throwable) {
                            IOUtil.closeQuietly(fileLock.channel());
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.closeQuietly(fileLock.channel());
                        throw throwable;
                    }
                    IOUtil.closeQuietly(fileLock.channel());
                }
            }
            IOUtil.closeQuietly(stream);
            IOUtil.deleteFileOrDir(file);
        }
    }

    private static String customHash(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return "0";
        }
        double hash = 0.0;
        byte[] bytes = str.getBytes();
        int i = 0;
        while (i < str.length()) {
            hash = (255.0 * hash + (double)bytes[i]) * 0.005;
            ++i;
        }
        return FORMAT.format(hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ProcessLock tryLockInternal(String lockName, String hash, boolean writeMode) {
        HashMap<String, ProcessLock> hashMap = LOCK_MAP;
        synchronized (hashMap) {
            if (LOCK_MAP.containsKey(lockName)) {
                ProcessLock lock = LOCK_MAP.get(lockName);
                if (lock == null) {
                    LOCK_MAP.remove(lockName);
                } else {
                    if (lock.isValid()) {
                        return null;
                    }
                    LOCK_MAP.remove(lockName);
                    lock.release();
                }
            }
            FileInputStream in = null;
            FileOutputStream out = null;
            Object var6_6 = null;
            FileChannel channel = null;
            try {
                File file = new File(x.app().getDir(LOCK_FILE_DIR, 0), hash);
                if (!file.exists()) {
                    if (!file.createNewFile()) return null;
                }
                if (writeMode) {
                    out = new FileOutputStream(file, false);
                    channel = out.getChannel();
                    FileOutputStream fileOutputStream = out;
                } else {
                    in = new FileInputStream(file);
                    channel = in.getChannel();
                    FileInputStream fileInputStream = in;
                }
                if (channel == null) throw new IOException("can not get file channel:" + file.getAbsolutePath());
                FileLock fileLock = channel.tryLock(0L, Long.MAX_VALUE, !writeMode);
                if (ProcessLock.isValid(fileLock)) {
                    void var6_9;
                    LogUtil.d("lock: " + lockName + ":" + PID);
                    ProcessLock processLock = new ProcessLock(lockName, file, fileLock, (Closeable)var6_9);
                    LOCK_MAP.put(lockName, processLock);
                    return processLock;
                }
                ProcessLock.release(lockName, fileLock, file, out);
            }
            catch (Throwable ignored) {
                LogUtil.d("tryLock: " + lockName + ", " + ignored.getMessage());
                IOUtil.closeQuietly(in);
                IOUtil.closeQuietly(out);
                IOUtil.closeQuietly(channel);
            }
            return null;
        }
    }

    public String toString() {
        return this.mLockName;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }
}

