/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.common.util;

import android.text.TextUtils;
import android.util.Log;
import org.xutils.x;

public class LogUtil {
    public static String customTagPrefix = "x_log";

    private LogUtil() {
    }

    private static String generateTag() {
        StackTraceElement caller = new Throwable().getStackTrace()[2];
        String tag = "%s.%s(L:%d)";
        String callerClazzName = caller.getClassName();
        callerClazzName = callerClazzName.substring(callerClazzName.lastIndexOf(".") + 1);
        tag = String.format(tag, callerClazzName, caller.getMethodName(), caller.getLineNumber());
        tag = TextUtils.isEmpty((CharSequence)customTagPrefix) ? tag : String.valueOf(customTagPrefix) + ":" + tag;
        return tag;
    }

    public static void d(String content) {
        if (!x.isDebug()) {
            return;
        }
        String tag = LogUtil.generateTag();
        Log.d((String)tag, (String)content);
    }

    public static void d(String content, Throwable tr) {
        if (!x.isDebug()) {
            return;
        }
        String tag = LogUtil.generateTag();
        Log.d((String)tag, (String)content, (Throwable)tr);
    }

    public static void e(String content) {
        if (!x.isDebug()) {
            return;
        }
        String tag = LogUtil.generateTag();
        Log.e((String)tag, (String)content);
    }

    public static void e(String content, Throwable tr) {
        if (!x.isDebug()) {
            return;
        }
        String tag = LogUtil.generateTag();
        Log.e((String)tag, (String)content, (Throwable)tr);
    }

    public static void i(String content) {
        if (!x.isDebug()) {
            return;
        }
        String tag = LogUtil.generateTag();
        Log.i((String)tag, (String)content);
    }

    public static void i(String content, Throwable tr) {
        if (!x.isDebug()) {
            return;
        }
        String tag = LogUtil.generateTag();
        Log.i((String)tag, (String)content, (Throwable)tr);
    }

    public static void v(String content) {
        if (!x.isDebug()) {
            return;
        }
        String tag = LogUtil.generateTag();
        Log.v((String)tag, (String)content);
    }

    public static void v(String content, Throwable tr) {
        if (!x.isDebug()) {
            return;
        }
        String tag = LogUtil.generateTag();
        Log.v((String)tag, (String)content, (Throwable)tr);
    }

    public static void w(String content) {
        if (!x.isDebug()) {
            return;
        }
        String tag = LogUtil.generateTag();
        Log.w((String)tag, (String)content);
    }

    public static void w(String content, Throwable tr) {
        if (!x.isDebug()) {
            return;
        }
        String tag = LogUtil.generateTag();
        Log.w((String)tag, (String)content, (Throwable)tr);
    }

    public static void w(Throwable tr) {
        if (!x.isDebug()) {
            return;
        }
        String tag = LogUtil.generateTag();
        Log.w((String)tag, (Throwable)tr);
    }

    public static void wtf(String content) {
        if (!x.isDebug()) {
            return;
        }
        String tag = LogUtil.generateTag();
        Log.wtf((String)tag, (String)content);
    }

    public static void wtf(String content, Throwable tr) {
        if (!x.isDebug()) {
            return;
        }
        String tag = LogUtil.generateTag();
        Log.wtf((String)tag, (String)content, (Throwable)tr);
    }

    public static void wtf(Throwable tr) {
        if (!x.isDebug()) {
            return;
        }
        String tag = LogUtil.generateTag();
        Log.wtf((String)tag, (Throwable)tr);
    }
}

