/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.common.util;

import android.database.Cursor;
import android.text.TextUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class IOUtil {
    private IOUtil() {
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Cursor cursor) {
        if (cursor != null) {
            try {
                cursor.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        ByteArrayOutputStream out = null;
        try {
            int len;
            out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
        }
        finally {
            IOUtil.closeQuietly(out);
        }
        return out.toByteArray();
    }

    public static byte[] readBytes(InputStream in, long skip, long size) throws IOException {
        ByteArrayOutputStream out = null;
        try {
            if (skip > 0L) {
                long skipSize = 0L;
                while (skip > 0L && (skipSize = in.skip(skip)) > 0L) {
                    skip -= skipSize;
                }
            }
            out = new ByteArrayOutputStream();
            int i = 0;
            while ((long)i < size) {
                out.write(in.read());
                ++i;
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(out);
            throw throwable;
        }
        IOUtil.closeQuietly(out);
        return out.toByteArray();
    }

    public static String readStr(InputStream in) throws IOException {
        return IOUtil.readStr(in, "UTF-8");
    }

    public static String readStr(InputStream in, String charset) throws IOException {
        int len;
        if (TextUtils.isEmpty((CharSequence)charset)) {
            charset = "UTF-8";
        }
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        InputStreamReader reader = new InputStreamReader(in, charset);
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[1024];
        while ((len = reader.read(buf)) >= 0) {
            sb.append(buf, 0, len);
        }
        return sb.toString().trim();
    }

    public static void writeStr(OutputStream out, String str) throws IOException {
        IOUtil.writeStr(out, str, "UTF-8");
    }

    public static void writeStr(OutputStream out, String str, String charset) throws IOException {
        if (TextUtils.isEmpty((CharSequence)charset)) {
            charset = "UTF-8";
        }
        OutputStreamWriter writer = new OutputStreamWriter(out, charset);
        writer.write(str);
        ((Writer)writer).flush();
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        if (!(out instanceof BufferedOutputStream)) {
            out = new BufferedOutputStream(out);
        }
        int len = 0;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.flush();
    }

    public static boolean deleteFileOrDir(File path) {
        if (path == null || !path.exists()) {
            return true;
        }
        if (path.isFile()) {
            return path.delete();
        }
        File[] files = path.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                IOUtil.deleteFileOrDir(file);
                ++n2;
            }
        }
        return path.delete();
    }
}

