/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.common.util;

import android.os.Environment;
import android.os.StatFs;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.xutils.common.util.IOUtil;
import org.xutils.common.util.LogUtil;
import org.xutils.x;

public class FileUtil {
    private FileUtil() {
    }

    public static File getCacheDir(String dirName) {
        File cacheDir;
        File result = FileUtil.existsSdcard().booleanValue() ? ((cacheDir = x.app().getExternalCacheDir()) == null ? new File(Environment.getExternalStorageDirectory(), ".android/" + x.app().getPackageName() + "/" + dirName) : new File(cacheDir, dirName)) : new File(x.app().getFilesDir(), dirName);
        if (result.exists() || result.mkdirs()) {
            return result;
        }
        return null;
    }

    public static boolean isDiskAvailable() {
        long size = FileUtil.getDiskAvailableSize();
        return size > 0xA00000L;
    }

    public static long getDiskAvailableSize() {
        if (!FileUtil.existsSdcard().booleanValue()) {
            return 0L;
        }
        File path = Environment.getExternalStorageDirectory();
        StatFs stat = new StatFs(path.getAbsolutePath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return availableBlocks * blockSize;
    }

    public static Boolean existsSdcard() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static long getFileOrDirSize(File file) {
        if (!file.exists()) {
            return 0L;
        }
        if (!file.isDirectory()) {
            return file.length();
        }
        long length = 0L;
        File[] list = file.listFiles();
        if (list != null) {
            File[] fileArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                File item = fileArray[n2];
                length += FileUtil.getFileOrDirSize(item);
                ++n2;
            }
        }
        return length;
    }

    public static boolean copy(String fromPath, String toPath) {
        boolean result;
        block7: {
            result = false;
            File from = new File(fromPath);
            if (!from.exists()) {
                return result;
            }
            File toFile = new File(toPath);
            IOUtil.deleteFileOrDir(toFile);
            File toDir = toFile.getParentFile();
            if (toDir.exists() || toDir.mkdirs()) {
                FileInputStream in = null;
                FileOutputStream out = null;
                try {
                    try {
                        in = new FileInputStream(from);
                        out = new FileOutputStream(toFile);
                        IOUtil.copy(in, out);
                        result = true;
                    }
                    catch (Throwable ex) {
                        LogUtil.d(ex.getMessage(), ex);
                        result = false;
                        IOUtil.closeQuietly(in);
                        IOUtil.closeQuietly(out);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(in);
                    IOUtil.closeQuietly(out);
                    throw throwable;
                }
                IOUtil.closeQuietly(in);
                IOUtil.closeQuietly(out);
            }
        }
        return result;
    }
}

