/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.common.task;

import android.os.Looper;
import java.util.concurrent.atomic.AtomicInteger;
import org.xutils.common.Callback;
import org.xutils.common.TaskController;
import org.xutils.common.task.AbsTask;
import org.xutils.common.task.TaskProxy;
import org.xutils.common.util.LogUtil;
import org.xutils.x;

public final class TaskControllerImpl
implements TaskController {
    private static TaskController instance;

    private TaskControllerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void registerInstance() {
        if (instance == null) {
            Class<TaskController> clazz = TaskController.class;
            // MONITORENTER : org.xutils.common.TaskController.class
            if (instance == null) {
                instance = new TaskControllerImpl();
            }
            // MONITOREXIT : clazz
        }
        x.Ext.setTaskController(instance);
    }

    @Override
    public <T> AbsTask<T> start(AbsTask<T> task) {
        TaskProxy<T> proxy = null;
        proxy = task instanceof TaskProxy ? (TaskProxy<T>)task : new TaskProxy<T>(task);
        try {
            proxy.doBackground();
        }
        catch (Throwable ex) {
            LogUtil.e(ex.getMessage(), ex);
        }
        return proxy;
    }

    @Override
    public <T> T startSync(AbsTask<T> task) throws Throwable {
        T result;
        block6: {
            result = null;
            try {
                task.onWaiting();
                task.onStarted();
                result = task.doBackground();
                task.onSuccess(result);
            }
            catch (Callback.CancelledException cex) {
                task.onCancelled(cex);
                task.onFinished();
                break block6;
            }
            catch (Throwable ex) {
                try {
                    task.onError(ex, false);
                    throw ex;
                }
                catch (Throwable throwable) {
                    task.onFinished();
                    throw throwable;
                }
            }
            task.onFinished();
        }
        return result;
    }

    @Override
    public <T extends AbsTask<?>> Callback.Cancelable startTasks(final Callback.GroupCallback<T> groupCallback, T ... tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException("task must not be null");
        }
        Runnable callIfOnAllFinished = new Runnable((AbsTask[])tasks){
            private final int total;
            private final AtomicInteger count;
            {
                this.total = absTaskArray.length;
                this.count = new AtomicInteger(0);
            }

            @Override
            public void run() {
                if (this.count.incrementAndGet() == this.total && groupCallback != null) {
                    groupCallback.onAllFinished();
                }
            }
        };
        T[] TArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            T task = TArray[n2];
            this.start(new TaskProxy((AbsTask)task, (AbsTask)task, callIfOnAllFinished){
                private final /* synthetic */ AbsTask val$task;
                private final /* synthetic */ Runnable val$callIfOnAllFinished;
                {
                    this.val$task = absTask;
                    this.val$callIfOnAllFinished = runnable;
                    super($anonymous0);
                }

                @Override
                protected void onSuccess(Object result) {
                    super.onSuccess(result);
                    TaskControllerImpl.this.post(new Runnable(){

                        @Override
                        public void run() {
                            if (groupCallback != null) {
                                groupCallback.onSuccess(val$task);
                            }
                        }
                    });
                }

                @Override
                protected void onCancelled(final Callback.CancelledException cex) {
                    super.onCancelled(cex);
                    TaskControllerImpl.this.post(new Runnable(){

                        @Override
                        public void run() {
                            if (groupCallback != null) {
                                groupCallback.onCancelled(val$task, cex);
                            }
                        }
                    });
                }

                @Override
                protected void onError(final Throwable ex, final boolean isCallbackError) {
                    super.onError(ex, isCallbackError);
                    TaskControllerImpl.this.post(new Runnable(){

                        @Override
                        public void run() {
                            if (groupCallback != null) {
                                groupCallback.onError(val$task, ex, isCallbackError);
                            }
                        }
                    });
                }

                @Override
                protected void onFinished() {
                    super.onFinished();
                    TaskControllerImpl.this.post(new Runnable(){

                        @Override
                        public void run() {
                            if (groupCallback != null) {
                                groupCallback.onFinished(val$task);
                            }
                            val$callIfOnAllFinished.run();
                        }
                    });
                }
            });
            ++n2;
        }
        return new Callback.Cancelable((AbsTask[])tasks){
            private final /* synthetic */ AbsTask[] val$tasks;
            {
                this.val$tasks = absTaskArray;
            }

            @Override
            public void cancel() {
                AbsTask[] absTaskArray = this.val$tasks;
                int n = this.val$tasks.length;
                int n2 = 0;
                while (n2 < n) {
                    AbsTask task = absTaskArray[n2];
                    task.cancel();
                    ++n2;
                }
            }

            @Override
            public boolean isCancelled() {
                boolean isCancelled = true;
                AbsTask[] absTaskArray = this.val$tasks;
                int n = this.val$tasks.length;
                int n2 = 0;
                while (n2 < n) {
                    AbsTask task = absTaskArray[n2];
                    if (!task.isCancelled()) {
                        isCancelled = false;
                    }
                    ++n2;
                }
                return isCancelled;
            }
        };
    }

    @Override
    public void autoPost(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            TaskProxy.sHandler.post(runnable);
        }
    }

    @Override
    public void post(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        TaskProxy.sHandler.post(runnable);
    }

    @Override
    public void postDelayed(Runnable runnable, long delayMillis) {
        if (runnable == null) {
            return;
        }
        TaskProxy.sHandler.postDelayed(runnable, delayMillis);
    }

    @Override
    public void run(Runnable runnable) {
        if (!TaskProxy.sDefaultExecutor.isBusy()) {
            TaskProxy.sDefaultExecutor.execute(runnable);
        } else {
            new Thread(runnable).start();
        }
    }

    @Override
    public void removeCallbacks(Runnable runnable) {
        TaskProxy.sHandler.removeCallbacks(runnable);
    }
}

