/*
 * Decompiled with CFR 0.152.
 */
package org.xutils;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.xutils.common.util.KeyValue;
import org.xutils.db.Selector;
import org.xutils.db.sqlite.SqlInfo;
import org.xutils.db.sqlite.WhereBuilder;
import org.xutils.db.table.DbModel;
import org.xutils.db.table.TableEntity;
import org.xutils.ex.DbException;

public interface DbManager
extends Closeable {
    public DaoConfig getDaoConfig();

    public SQLiteDatabase getDatabase();

    public boolean saveBindingId(Object var1) throws DbException;

    public void saveOrUpdate(Object var1) throws DbException;

    public void save(Object var1) throws DbException;

    public void replace(Object var1) throws DbException;

    public void deleteById(Class<?> var1, Object var2) throws DbException;

    public void delete(Object var1) throws DbException;

    public void delete(Class<?> var1) throws DbException;

    public int delete(Class<?> var1, WhereBuilder var2) throws DbException;

    public void update(Object var1, String ... var2) throws DbException;

    public int update(Class<?> var1, WhereBuilder var2, KeyValue ... var3) throws DbException;

    public <T> T findById(Class<T> var1, Object var2) throws DbException;

    public <T> T findFirst(Class<T> var1) throws DbException;

    public <T> List<T> findAll(Class<T> var1) throws DbException;

    public <T> Selector<T> selector(Class<T> var1) throws DbException;

    public DbModel findDbModelFirst(SqlInfo var1) throws DbException;

    public List<DbModel> findDbModelAll(SqlInfo var1) throws DbException;

    public <T> TableEntity<T> getTable(Class<T> var1) throws DbException;

    public void dropTable(Class<?> var1) throws DbException;

    public void addColumn(Class<?> var1, String var2) throws DbException;

    public void dropDb() throws DbException;

    @Override
    public void close() throws IOException;

    public int executeUpdateDelete(SqlInfo var1) throws DbException;

    public int executeUpdateDelete(String var1) throws DbException;

    public void execNonQuery(SqlInfo var1) throws DbException;

    public void execNonQuery(String var1) throws DbException;

    public Cursor execQuery(SqlInfo var1) throws DbException;

    public Cursor execQuery(String var1) throws DbException;

    public static class DaoConfig {
        private File dbDir;
        private String dbName = "xUtils.db";
        private int dbVersion = 1;
        private boolean allowTransaction = true;
        private DbUpgradeListener dbUpgradeListener;
        private TableCreateListener tableCreateListener;

        public DaoConfig setDbDir(File dbDir) {
            this.dbDir = dbDir;
            return this;
        }

        public DaoConfig setDbName(String dbName) {
            if (!TextUtils.isEmpty((CharSequence)dbName)) {
                this.dbName = dbName;
            }
            return this;
        }

        public DaoConfig setDbVersion(int dbVersion) {
            this.dbVersion = dbVersion;
            return this;
        }

        public DaoConfig setAllowTransaction(boolean allowTransaction) {
            this.allowTransaction = allowTransaction;
            return this;
        }

        public DaoConfig setDbUpgradeListener(DbUpgradeListener dbUpgradeListener) {
            this.dbUpgradeListener = dbUpgradeListener;
            return this;
        }

        public DaoConfig setTableCreateListener(TableCreateListener tableCreateListener) {
            this.tableCreateListener = tableCreateListener;
            return this;
        }

        public File getDbDir() {
            return this.dbDir;
        }

        public String getDbName() {
            return this.dbName;
        }

        public int getDbVersion() {
            return this.dbVersion;
        }

        public boolean isAllowTransaction() {
            return this.allowTransaction;
        }

        public DbUpgradeListener getDbUpgradeListener() {
            return this.dbUpgradeListener;
        }

        public TableCreateListener getTableCreateListener() {
            return this.tableCreateListener;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DaoConfig daoConfig = (DaoConfig)o;
            if (!this.dbName.equals(daoConfig.dbName)) {
                return false;
            }
            return this.dbDir == null ? daoConfig.dbDir == null : this.dbDir.equals(daoConfig.dbDir);
        }

        public int hashCode() {
            int result = this.dbName.hashCode();
            result = 31 * result + (this.dbDir != null ? this.dbDir.hashCode() : 0);
            return result;
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.dbDir)) + "/" + this.dbName;
        }
    }

    public static interface DbUpgradeListener {
        public void onUpgrade(DbManager var1, int var2, int var3);
    }

    public static interface TableCreateListener {
        public void onTableCreated(DbManager var1, TableEntity<?> var2);
    }
}

