package cn.bsl.bxbg.zhiban.view;

import android.os.Bundle;
import android.widget.TextView;

import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import cn.bsl.bxbg.zhiban.BaseActivity;
import cn.bsl.bxbg.zhiban.R;
import cn.bsl.bxbg.zhiban.net.client.DutyPlanClient;
import cn.bsl.bxbg.zhiban.net.response.DutiesTbResponse;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;

public class TiaobanDetailsActivity extends BaseActivity {

    @BindView(R.id.duty_times)
    TextView dutyTimes;
    @BindView(R.id.person)
    TextView person;
    @BindView(R.id.change_person)
    TextView changePerson;
    @BindView(R.id.reason)
    TextView reason;
    private String id;
    DutyPlanClient dutyPlanClient = new DutyPlanClient();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_tiaoban_details);
        ButterKnife.bind(this);
        initData();
    }

    private void initData() {
        id = getIntent().getStringExtra("id");
        dutyPlanClient.dutiesTbDetails(id)
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Consumer<List<DutiesTbResponse>>() {
                    @Override
                    public void accept(List<DutiesTbResponse> dutiesTbResponses) throws Exception {
                        String createTime = dutiesTbResponses.get(0).getRefers().getCc_shift().get(0).getCreateTime();
                        String dutyDate = dutiesTbResponses.get(0).getSuperior().getDutyDate();
                        String people = " 早：" + dutiesTbResponses.get(0).getSuperior().getMorning() + "\n 中:" + dutiesTbResponses.get(0).getSuperior().getNoon() + "\n 晚:" + dutiesTbResponses.get(0).getSuperior().getEvening();
                        String change = dutiesTbResponses.get(0).getRefers().getCc_shift().get(0).getApplicant() + " 变更为 " + dutiesTbResponses.get(0).getRefers().getCc_shift().get(0).getTransferredName();
                        dutyTimes.setText(dutyDate);
                        person.setText(people);
                        changePerson.setText(change);
                        reason.setText(dutiesTbResponses.get(0).getRefers().getCc_shift().get(0).getReason());
                    }
                }, Throwable::printStackTrace);

    }
}
