package cn.bsl.bxbg.zhiban.net.client;

import java.util.List;

import cn.bsl.bxbg.zhiban.net.api.DutyAPI;
import cn.bsl.bxbg.zhiban.net.response.CCDuties;
import cn.bsl.bxbg.zhiban.net.response.CCDutiesEdit;
import cn.bsl.bxbg.zhiban.net.response.CCShifts;
import cn.bsl.bxbg.zhiban.net.response.DutiesTbResponse;
import cn.bsl.bxbg.zhiban.net.response.DutyPlanResponse;
import cn.bsl.bxbg.zhiban.net.response.TiaobanBean;
import cn.bsl.bxbg.zhiban.utils.Constant;
import io.reactivex.Observable;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

/**
 * Created by Xinghx on 2018/3/14 0014.
 */

public class DutyPlanClient extends BaseClient {
    DutyAPI dutyAPI = new Retrofit.Builder()
            .baseUrl(Constant.HOST)
            .client(getClient())
            .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
            .addConverterFactory(GsonConverterFactory.create())
            .build()
            .create(DutyAPI.class);

    public Observable<List<DutyPlanResponse>> dutyPlanLeaderRecord() {
        return dutyAPI.dutyPlanLeader("1","100");
    }

    public Observable<List<CCDuties>> dutiesRecord() {
        return dutyAPI.dutiesRecord("1", "100","duty_date");
    }

    public Observable<CCDuties> dutiesById(String id) {
        return dutyAPI.dutiesById(Constant.USER_ID+"",id);
    }

    public Observable<TiaobanBean> tiaobanBean(String transferredName,String id,String reason,String dutyTime) {
        return dutyAPI.tbRecord(Constant.USER_ID,Constant.USER_ID,Constant.USER_NAME,
                transferredName,id,reason,dutyTime);
    }

    public Observable<CCDutiesEdit> editMorning(String cc_id,String morning) {
        return dutyAPI.editMorning(Constant.USER_ID, cc_id, morning);
    }

    public Observable<CCDutiesEdit> editNoon(String cc_id,String noon) {
        return dutyAPI.editNoon(Constant.USER_ID, cc_id, noon);
    }

    public Observable<CCDutiesEdit> editNight(String cc_id,String night) {
        return dutyAPI.editNight(Constant.USER_ID, cc_id, night);
    }

    public Observable<List<DutiesTbResponse>> dutiesTb() {
        return dutyAPI.dutiesTb("1", "1000", "{'cc_shift':{'includes':['applicant_duty_id']}}");
    }

    public Observable<List<DutiesTbResponse>> dutiesTbDetails(String id) {
        return dutyAPI.dutiesTbDetails("1", "1000","{'cc_duty':{'id':{'like':'"+id+"'}}}","{'cc_shift':{'includes':['applicant_duty_id']}}");
    }

    public Call<List<CCShifts>> shiftsRecord() {
        return dutyAPI.ccShifts("1","1000","{'cc_shift':{'applicant':{'equalTo':'"+Constant.USER_NAME+"'}}}");

    }
}
