package cn.bsl.bxbg.zhiban.adapter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import cn.bsl.bxbg.zhiban.R;
import cn.bsl.bxbg.zhiban.net.response.CCShifts;

/**
 * Created by Xinghx on 2018/3/6 0006.
 */

public class TiaobanInfoAdapter extends BaseAdapter {

    private List<CCShifts> ccShiftses;

    public TiaobanInfoAdapter(List<CCShifts> ccShiftses) {
        this.ccShiftses = ccShiftses;
    }

    @Override
    public int getCount() {
        return ccShiftses.size();
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        if (convertView == null) {
            convertView = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_tiaoban_info, parent, false);
            holder = new ViewHolder(convertView);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }
        holder.tbName.setText(ccShiftses.get(position).getApplicant());
        holder.tbTime.setText(ccShiftses.get(position).getShiftTime());
        return convertView;
    }

    static class ViewHolder {
        @BindView(R.id.tb_title)
        TextView tbTitle;
        @BindView(R.id.tb_name)
        TextView tbName;
        @BindView(R.id.tb_time)
        TextView tbTime;

        ViewHolder(View view) {
            ButterKnife.bind(this, view);
        }
    }
}
