package cn.bsl.bxbg.zhiban.net.api;

import java.util.List;

import cn.bsl.bxbg.zhiban.net.response.CCDuties;
import cn.bsl.bxbg.zhiban.net.response.CCDutiesEdit;
import cn.bsl.bxbg.zhiban.net.response.CCShifts;
import cn.bsl.bxbg.zhiban.net.response.CCShiftsUni;
import cn.bsl.bxbg.zhiban.net.response.DutiesTbResponse;
import cn.bsl.bxbg.zhiban.net.response.DutyPlanResponse;
import cn.bsl.bxbg.zhiban.net.response.TiaobanBean;
import io.reactivex.Observable;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

/**
 * Created by Xinghx on 2018/3/14 0014.
 */

public interface DutyAPI {
    @GET("cc_duty_plans")
    Observable<List<DutyPlanResponse>> dutyPlanLeader(@Query("pageNo") String pageNo,
                                                      @Query("pageSize") String pageSize);


    @GET("cc_duties")
    Observable<List<CCDuties>> dutiesRecord(@Query("pageNo") String pageNo,
                                            @Query("pageSize") String pageSize,
                                            @Query("sortItem") String filters);

    @GET("cc_duties/{id}")
    Observable<CCDuties> dutiesById(@Header("X-Auth-Token") String header,
                                          @Path("id") String id);

    @FormUrlEncoded
    @POST("roleManagerController.do")
    Call<ResponseBody> people(@Field("method") String method, @Field("userId") String userId);

    @FormUrlEncoded
    @POST("cc_shifts/new")
    Observable<TiaobanBean> tbRecord(@Header("X-Auth-Token") String header,
                                     @Field("applicantId") String applicantId,
                                     @Field("applicant") String applicant,
                                     @Field("transferredName") String transferredName,
                                     @Field("transferredClass") String transferredClass,
                                     @Field("applicantDutyId") String applicantDutyId,
                                     @Field("reason") String reason,
                                     @Field("shiftTime") String shiftTime,
                                     @Field("status") String status,
                                     @Field("transferredClassTime") String transferredClassTime);

    @FormUrlEncoded
    @POST("cc_duties/{id}/edit")
    Observable<CCDutiesEdit> editMorning(@Header("X-Auth-Token") String header,
                                         @Path("id") String cc_duty_id,
                                         @Field("morning") String morning);

    @FormUrlEncoded
    @POST("cc_duties/{id}/edit")
    Observable<CCDutiesEdit> editNoon(@Header("X-Auth-Token") String header,
                                         @Path("id") String cc_duty_id,
                                         @Field("noon") String noon);

    @FormUrlEncoded
    @POST("cc_duties/{id}/edit")
    Observable<CCDutiesEdit> editNight(@Header("X-Auth-Token") String header,
                                       @Path("id") String cc_duty_id,
                                         @Field("night") String night);

    @GET("cc_duties")
    Observable<List<DutiesTbResponse>> dutiesTb(@Query("pageNo") String pageNo,
                                          @Query("pageSize") String pageSize,
                                          @Query("refers") String refers);

    @GET("cc_duties")
    Observable<List<DutiesTbResponse>> dutiesTbDetails(@Query("pageNo") String pageNo,
                                                @Query("pageSize") String pageSize,
                                                @Query("filters") String filters,
                                                @Query("refers") String refers);

    @GET("cc_shifts")
    Call<List<CCShifts>> ccShifts(@Query("pageNo") String pageNo,
                                  @Query("pageSize") String pageSize,
                                  @Query("filters") String filters);
    @GET("cc_shifts")
    Observable<List<CCShiftsUni>> ccShiftsUnique(@Query("pageNo") String pageNo,
                                           @Query("pageSize") String pageSize,
                                           @Query("filters") String filters,
                                           @Query("includes") String includes);

    @FormUrlEncoded
    @POST("cc_shifts/{cc_shift_id}/edit")
    Observable<CCShifts> ccShiftsEdit(@Header("X-Auth-Token") String header,
                                            @Path("cc_shift_id") String id,
                                            @Field("status") String status);
}
